<?php

//
// Copyright (C) 2013, 2014 FromDual GmbH
//
// This program is commercial software. Use of this software is governed
// by your applicable license agreement with FromDual GmbH
//

// Must be the same base as in index.php
$gMyNameBase = dirname(dirname(__FILE__));

require('../lib/Constants.inc');
require('../lib/Configuration.inc');
require('../lib/Log.inc');
require('../lib/Repository.inc');
include('../lib/Node.inc');

logMessage(LOG_NOTICE, 'Begin page: ' . basename(__FILE__));
session_start();

$hNodeId   = isset($_REQUEST['node_id']) ? intval($_REQUEST['node_id']) : 0;

if ( isset($_SESSION['logged_in']) && ($_SESSION['logged_in'] == 1 ) ) {
  // noop
}
else {
  $rc = 896;
  logMessage(LOG_EMERG, "Not logged in! (rc=$rc)");
  exit($rc);
}

list($ret, $dbh) = openRepositoryDatabase();

list($ret, $aNodes) = getNodesWithFilter($dbh, $aFilter = array('node_id' => $hNodeId));
$aNode = array_shift($aNodes);

closeRepositoryDatabase($dbh);


// Test with ping until database is up
// should be done remotely
// is there not a ping equivalent for the mysql api?

$cmd = $aNode['basedir'] . "/bin/mysqladmin --user=" . $aNode['database_user'] . " --password=" . $aNode['database_user_password'] . " --host=" . $aNode['hostname'] . " --port=" . $aNode['port'] . " ping 2>&1";

$ping_timeout = 10;
$cnt = $ping_timeout;
logMessage(LOG_INFO, 'Test database');
while ( $cnt > 0 ) {
  $stdout = exec($cmd, $output, $ret);
  if ( $ret == OK ) {
    break;
  }
  sleep(1);
  $cnt--;
}

// Check if timeout was reached
if ( $cnt == 0 ) {
  print "<p>Pinging database failed for $ping_timeout seconds.<p>\n";
}
else {
  if ( $ping_timeout-$cnt > 1 ) {
		$sec = 'seconds';
	}
	else {
		$sec = 'second';
	}
  print "<p>Pinging database successful after " . ($ping_timeout-$cnt) . " $sec.<p>\n";
}

logMessage(LOG_NOTICE, 'End page: ' . basename(__FILE__));

?>
