<?php

//
// Copyright (C) 2013, 2014 FromDual GmbH
//
// This program is commercial software. Use of this software is governed
// by your applicable license agreement with FromDual GmbH
//

// Must be the same base as in index.php
$gMyNameBase = dirname(dirname(__FILE__));

require('../lib/Constants.inc');
require('../lib/Configuration.inc');
require('../lib/Log.inc');
require('../lib/Repository.inc');
include('../lib/Server.inc');

logMessage(LOG_NOTICE, 'Begin fragment: ' . basename(__FILE__));
$gIndention += 2;

$hServerId   = isset($_REQUEST['server_id']) ? intval($_REQUEST['server_id']) : 0;

session_start();

if ( isset($_SESSION['logged_in']) && ($_SESSION['logged_in'] == 1 ) ) {
  // noop
}
else {
  $rc = 997;
  logMessage(LOG_EMERG, "Not logged in! (rc=$rc)");
  exit($rc);
}

list($ret, $dbh) = openRepositoryDatabase();
list($ret, $aServers) = getServersWithFilter($dbh, array('server_id' => $hServerId));
$aServer = array_shift($aServers);
closeRepositoryDatabase($dbh);

print $aServer['default_ip'];

$gIndention -= 2;
logMessage(LOG_NOTICE, 'End fragement: ' . basename(__FILE__));

?>
