<?php

//
// Copyright (C) 2013, 2014 FromDual GmbH
//
// This program is commercial software. Use of this software is governed
// by your applicable license agreement with FromDual GmbH
//

// Must be the same base as in index.php
$gMyNameBase = dirname(dirname(__FILE__));

$gLogPriorityThreshold = LOG_INFO;

require('../lib/Constants.inc');
require('../lib/Configuration.inc');
require('../lib/Log.inc');
require('../lib/Repository.inc');
include('../lib/Node.inc');
include('../lib/Cluster.inc');
include('../lib/Database.inc');

logMessage(LOG_NOTICE, 'Begin page: ' . basename(__FILE__));
session_start();

$hMasterId   = isset($_REQUEST['master_id']) ? intval($_REQUEST['master_id']) : 0;
$hSlaveId    = isset($_REQUEST['slave_id']) ? intval($_REQUEST['slave_id']) : 0;
$hStartSlave = isset($_REQUEST['start_slave']) ? intval($_REQUEST['start_slave']) : 0;

if ( isset($_SESSION['logged_in']) && ($_SESSION['logged_in'] == 1 ) ) {
  // noop
}
else {
  $rc = 890;
  logMessage(LOG_EMERG, "Not logged in! (rc=$rc)");
  exit($rc);
}

if ( ($hMasterId == 0) || ($hSlaveId == 0) ) {
	$rc = 132;
  $msg = "There went something terribly wrong: master_id=$hMasterId, slave_id=$hSlaveId (rc=$rc).";
  logMessage(LOG_EMERG, $msg);
	print "<p>$msg</p>\n";
	exit($rc);
}


list($ret, $dbh) = openRepositoryDatabase();

list($rc, $aSlaveNode) = getDatabaseNodeById($dbh, $hSlaveId);
list($ret, $lMasterId) = getMasterOfSlave($dbh, $aSlaveNode['node_id']);
list($ret, $aMasterNode) = getDatabaseNodeById($dbh, $lMasterId);
// print_r($aMasterNode);

closeRepositoryDatabase($dbh);


// Check if binary-log is enabled

list($ret, $mysqli) = openDatabaseConnection($aMasterNode['database_user'], $aMasterNode['database_user_password'], $aMasterNode['hostname'], $aMasterNode['port']);
if ( $ret != OK ) {
	$rc = 927;
	print "<p>Open database " . $aMasterNode['name'] . " failed (rc=$rc)\n";
}

list($ret, $aMasterStatus) = getShowMasterStatus($mysqli);

if ( $aMasterStatus['File'] == '' ) {
	$rc = 769;
	print "<p>Binary Log is NOT enabled. Database " . $aMasterNode['name'] . "cannot server as Master (rc=$rc).</p>\n";
}
closeDatabaseConnection($mysqli);


list($ret, $mysqli) = openDatabaseConnection($aSlaveNode['database_user'], $aSlaveNode['database_user_password'], $aSlaveNode['hostname'], $aSlaveNode['port']);
if ( $ret != OK ) {
	$rc = 133;
	print "<p>Open database " . $aSlaveNode['name'] . " failed (rc=$rc)\n";
}


// todo: 3 possibilites a) from master, b) from slave, c) from moc server
// Do different checks:
// mysqludmp command
// Connect to master
// Connect to Slave
// Slave stopped
// hostname and port matches to master
// user and password works on master
// Check vesion of master, slave and myself
// Check buffer pool, key buffer and log file size, and flush_log_at_trx_commit


// Do a CHANGE MASTER TO on slave first to be sure everything is correct!
// We do not know these values and should guess!!!
// list($ret, $msg) = setSlaveToMaster($mysqli, $pChangeMasterTo);

print "setSlaveToMaster<br />";
// hostname, port, 
print "<pre>"; print_r($aMasterNode); print "</pre>";



// Now dump/restore

$lMysqldump = $aMasterNode['basedir'] . '/bin/mysqldump';

// Can we improve dump when we have a bigger pipe for example 100M as a cache?
// todo: use all from our website to make a good backup
// todo: option sql_log_bin = 0
// skip mysql schema?
$cmd_master = "$lMysqldump --user=" . $aMasterNode['database_user'] . " --password=" . $aMasterNode['database_user_password'] . " --host=" . $aMasterNode['hostname'] . " --port=" . $aMasterNode['port'] . " --single-transaction --all-databases --master-data=1 --hex-blob";
// echo "SET SESSION sql_log_bin = 0"; ...
$cmd_slave  = "mysql --user=" . $aSlaveNode['database_user'] . " --password=" . $aSlaveNode['database_user_password'] . " --host=" . $aSlaveNode['hostname'] . " --port=" . $aSlaveNode['port'];

// todo: must be done completely asynchronous!!!

$cmd = $cmd_master . ' | ' . $cmd_slave . '';
$cmd = $cmd_master . ' > /tmp/oli';
// Caution printing is a security issue!
print $cmd . "\n";

$stdout = exec($cmd, $output, $ret);
// print backup started
// $stdout = system($cmd, $ret);
  print "<pre>\n"; var_dump($stdout, $cmd, $output, $ret); print "</pre>\n";
if ( $ret != 0 ) {
	$rc = 134;
	print "ERROR (rc=$rc);";
	print "<pre>\n"; var_dump($stdout, $cmd, $output, $ret); print "</pre>\n";
}
else {

	if ( $hStartSlave == 1 ) {
		list($ret, $value) = startSlave($mysqli);
	}
	else {
		print "Slave is rebuilt. Please start Slave now...\n";
	}
}

// if everything is ok start slave if wanted
closeDatabaseConnection($mysqli);

logMessage(LOG_NOTICE, 'End page: ' . basename(__FILE__));

?>
