#!/usr/bin/php
<?php

$rc = 0;

$gMyNameBase = basename(__FILE__);

if ( count($argv) == 1 ) {
  $rc = 1;
  printUsage();
  exit($rc);
}

// Parse command line
$shortopts  = "";
$longopts  = array(
  'user:'
, 'password:'
, 'host:'
, 'port:'
, 'socket:'
, 'schema:'
, 'table:'
, 'help'
, 'debug'
, 'dryrun'
);

$aOptions = getopt($shortopts, $longopts);

if ( isset($aOptions['help']) ) {
  printUsage();
  exit($rc);
}

if ( isset($aOptions['debug']) ) {
	print_r($argv);
}

// Set defaults
if ( ! isset($aOptions['user']) ) {
  $aOptions['user'] = 'root';
}
if ( ! isset($aOptions['password']) ) {
  $aOptions['password'] = '';
}
if ( ! isset($aOptions['host']) ) {
  $aOptions['host'] = 'localhost';
}
if ( ! isset($aOptions['port']) ) {
  $aOptions['port'] = 3306;
}
// if ( ! isset($aOptions['socket']) ) {
//   $aOptions['socket'] = '/var/run/mysqld/mysqld.sock';
// }

// If password is a file extrac password from file
if ( file_exists($aOptions['password']) ) {
  
	$handle = @fopen($aOptions['password'], 'r');
	if ( $handle ) {
	
		while ( ($buffer = fgets($handle, 4096)) !== false ) {

      if ( preg_match('/password\s*=\s*(.*)$/', $buffer, $matches) ) {
        $aOptions['password'] = trim($matches[1]);
      }
		}
		if ( ! feof($handle) ) {
			print "Error: unexpected fgets() fail.\n";
    }
		fclose($handle);
	}
}

if ( isset($aOptions['debug']) ) {
	print_r($aOptions);
}

// Check options
// no checks defined yet

// ---------------------------------------------------------------------
function printUsage()
// ---------------------------------------------------------------------
{
  global $gMyNameBase;

  print "

Split the latest partition into this weeks partition and next weeks partition:

usage: $gMyNameBase [--user=<user>] [--password=<password>] [--host=<hostname>]
       [--port=3306] [--socket=<socket>]
       --schema=<schema_name> --table=<table_name>
       [--debug] [--dryrun] [--help]

Options:
  user        Database user who should run the command (default = root).
  password    Password of the database user (default = '') OR it is a
              file where the password is stored in.
  host        Hostname or IP address where database is located (default =
              localhost).
  port        Port where database is listening (default = 3306).
  socket      Socket where database is listening (defaul =
              /var/run/mysqld/mysqld.sock).
  schema      Schema where partitoned table is located.
  table       Table to split the newest partiton.
  help        Prints this help.
  debug       Prints all debugging information.
  dryrun      Only prints SQL statement but do NOT execute.

Examples:

  $gMyNameBase --user=root --password=secret --host=192.168.1.42 --schema=dwh --table=sales

";
}

// ---------------------------------------------------------------------
// MAIN
// ---------------------------------------------------------------------

$mysqli = @new mysqli($aOptions['host'], $aOptions['user'], $aOptions['password'], null, $aOptions['port'], $aOptions['socket']);

if ( mysqli_connect_error() ) {
  $rc = 5;
  printf("ERROR: Connect failed: (%d) %s (rc=$rc).\n", mysqli_connect_errno(), mysqli_connect_error());
  exit($rc);
}
$sql = 'SET NAMES utf8';
if ( isset($aOptions['debug']) ) {
	print "$sql\n";
}
$mysqli->query($sql);

$sql = sprintf("SELECT partition_name, MAX(partition_ordinal_position) AS ptn
  FROM information_schema.partitions
 WHERE table_schema = '%s'
   AND table_name = '%s'
   AND partition_name IS NOT NULL
 GROUP BY partition_name
 ORDER BY ptn DESC
LIMIT 1", $aOptions['schema'], $aOptions['table']);

if ( isset($aOptions['debug']) ) {
	print $sql . "\n";
}

if ( ! $result = $mysqli->query($sql) ) {
  $rc = 2;
  print "ERROR: Invalid query: $sql, " . $mysqli->error . " (rc=$rc)\n";
  exit($rc);
}
if ( ! $record = $result->fetch_array(MYSQLI_ASSOC) ) {
  $rc = 7;
  print "ERROR: No record found (rc=$rc).\n";
  exit($rc);
}

if ( isset($aOptions['debug']) ) {
	print_r($record);
}

# Do some calculations
$ts  = date('Y-m-d', strtotime('+7 day')) . ' 00:00:00';
$ptn = 'p' . date('Y') . '_kw' . sprintf("%02d", date('W')+1);

$sql = sprintf("ALTER TABLE %s.%s
REORGANIZE PARTITION %s
INTO (
  PARTITION %s VALUES LESS THAN (UNIX_TIMESTAMP('%s'))
, PARTITION %s VALUES LESS THAN (MAXVALUE)
)"
, $aOptions['schema'], $aOptions['table'], $record['partition_name']
, $ptn, $ts, $record['partition_name']);

print $sql . "\n";

if ( ! isset($aOptions['dryrun']) ) {
	if ( ! $mysqli->query($sql) ) {
		$rc = 4;
		printf("ERROR: %s %s : %s (rc=$rc).\n", $mysqli->sqlstate, $mysqli->errno, $mysqli->error);
	}
}

$mysqli->close();
exit($rc);

?>
