#!/bin/bash

echo "Do NOT use alter_engine.sh any more! Use alter_engine.pl instead!"
exit 1

len=40

default='root'
printf "%-${len}s: " "User [$default]"
read user
if [ "$user" == "" ] ; then
  user="$default"
fi

default=''
printf "%-${len}s: " "Password [$default]"
stty -echo
read password
stty echo
echo
if [ "$password" == "" ] ; then
  password="$default"
fi

default='test'
printf "%-${len}s: " "Schema from [$default]"
read schema_from
if [ "$schema_from" == "" ] ; then
  schema_from="$default"
fi

default=$schema_from
printf "%-${len}s: " "Schema to [$default]"
read schema_to
if [ "$schema_to" == "" ] ; then
  schema_to="$default"
fi

default='InnoDB'
printf "%-${len}s: " "Engine to [$default] (MyISAM, NDB, ...)"
read engine_to
if [ "$engine_to" == "" ] ; then
  engine_to="$default"
fi

default='simple'
printf "%-${len}s: " "Convert simple or difficult [$default]"
read convert
if [ "$convert" == "" ] ; then
  convert="$default"
fi

# ----------------------------------------------------------------------

tmp_file=/tmp/sql.$$
out_file=$(pwd)/alter_table.sql

# simple
if [ "$convert" != "difficult" ] ; then

  cat <<EOF >$tmp_file
SET @schema_from = '`$schema_from`';
SET @schema_to = '`$schema_to`';
SET @engine_to = '$engine_to';

SELECT CONCAT('ALTER TABLE ', @schema_from, '.', table_name
            , ' ENGINE=', @engine_to, ';') AS statement
  FROM information_schema.tables
 where table_schema = @schema_from
;
EOF

else   # difficult

  cat <<EOF >$tmp_file
SET @schema_from = '$schema_from';
SET @schema_to = '$schema_to';
SET @engine_to = '$engine_to';

SELECT CONCAT('CREATE TABLE ', @schema_to, '.', table_name
            , ' LIKE ', @schema_from, '.', table_name, ';') AS statement
  FROM information_schema.tables
 where table_schema = @schema_from
;

SELECT CONCAT('ALTER TABLE ', @schema_to, '.', table_name
            , ' ENGINE=', @engine_to, ';') AS statement
  FROM information_schema.tables
 where table_schema = @schema_from
;

SELECT CONCAT('INSERT INTO ', @schema_to, '.', table_name
            , ' SELECT * FROM ', @schema_from, '.', table_name, ';') AS statement
  FROM information_schema.tables
 where table_schema = @schema_from
;
EOF

fi

mysql --user=$user --password=$password < $tmp_file | grep -v statement >$out_file

echo
echo "Output written to $out_file"

