<?php

/*

  getInstanceBlackList()
  answerQuestion($str, $aAllowedKeys, $defaultKey)
  copyFromTemplate($pConfFileTemplate, $pConfFile)
  addInstance()
  deleteInstance($pInstance)
  changeInstance($pInstance)
  getInstances($aConfiguration)
  installInstance($aConfiguration)
  askForSocket($aConfiguration)
  askForMyCnf($aConfiguration)

*/

// ---------------------------------------------------------------------
function getInstanceBlackList()
// ---------------------------------------------------------------------
{
  return array('mysql', 'mysqld');
}

// ---------------------------------------------------------------------
function answerQuestion($str, $aAllowedKeys, $defaultKey)
// ---------------------------------------------------------------------
{

  while ( true ) {

    // readline always caused crippled output for multi-line output
    // thus we do it our self
    // $input = strtolower(readline($str));
    print $str;
    $input = strtolower(readline(''));

    // on CR do default Key
    if ( $input == '' ) {
      $input = $defaultKey;
    }

    foreach( $aAllowedKeys as $key ) {
      if ( $key == $input ) {
        return $input;
      }
    }
  }
}

// ---------------------------------------------------------------------
function copyFromTemplate($pConfFileTemplate, $pConfFile)
// ---------------------------------------------------------------------
{
  $rc = 0;

  // Copy template
  print "Copy $pConfFileTemplate to $pConfFile\n";
  if ( ! copy($pConfFileTemplate, $pConfFile) ) {

    $rc = 255;
    print "Cannot copy template $pConfFileTemplate to $pConfFile\n";
    print "Aborting...\n";
    return $rc;
  }

  return $rc;
}

// ---------------------------------------------------------------------
function addInstance()
// ---------------------------------------------------------------------
{
  global $aConfiguration;

  // todo: check if default already exists!
  $default = 'mysqld1';
  print "\nYou have to enter a new instance name. An instance name can consist of 0-9, a-z, A-Z, - and _.\n";
  print "Examples: test, prod, dev, [$default] mysqld-3306\n";
  print "\n";

  $instance = readline("Enter a new instance name: ");
  if ( $instance == '' ) {
    $instance = $default;
  }

  // Check for existing instance name here!
  foreach ( $aConfiguration as $instances ) {
    if ( $instances == $instance ) {
      $rc = 252;
      error("Instance name $instance already exists (rc=$rc).\n");
      return $rc;
    }
  }

  // Check if instance name is on black list:
  $aBlackList = getInstanceBlackList();
  foreach ( $aBlackList as $name ) {
    if ( $name == $instance ) {
      $rc = 253;
      error("Instance name $instance is on blacklist (rc=$rc).");
      readline("Press Enter choose an other one...");
      return $rc;
    }
  }

  $aConfiguration[$instance]          = array();
  $aConfiguration[$instance]['start'] = 'yes';
  $aConfiguration[$instance]['stop']  = 'yes';
  changeInstance($instance);
}

// ---------------------------------------------------------------------
function deleteInstance($pInstance)
// ---------------------------------------------------------------------
{
  $rc = 0;
  global $aConfiguration;

  if ( ! isset($aConfiguration[$pInstance]) ) {
    $rc = 707;
    error("Instance $pInstance does not exist. Please choose a valid instance name (rc=$rc).");
    return $rc;
  }

  $ret = checkDatabase($aConfiguration[$pInstance]);

  if ( $ret != 0 ) {

    print "Delete datadir (" . $aConfiguration[$pInstance]['datadir'] . ") and basedir (" . $aConfiguration[$pInstance]['basedir'] . ") manually.\n";
    unset($aConfiguration[$pInstance]);
    print "Instance $pInstance has been deleted from MyEnv.\n";
    print "Do not forget to safe configuration before leaving installer.\n";
    readline("Press Enter to continue...");
    print "\n\n";
  }
  else {
    $rc = 254;
    error("Please stop instence first before deleting it (rc=$rc).");
    return $rc;
  }

  return $rc;
}

// ---------------------------------------------------------------------
function changeInstance($pInstance)
// ---------------------------------------------------------------------
{
  $rc = 0;
  global $aConfiguration;
  $lHomeDir = $_ENV['HOME'];

  if ( ! in_array($pInstance, getInstances($aConfiguration)) ) {
    $rc = 701;
    error("Instance $pInstance does NOT exist in configuration file (rc=$rc).");
    return $rc;
  }

  print "\n";
  print "Changing instance $pInstance:\n";
  // Just to make sure it is set:
  if ( ! isset($aConfiguration[$pInstance]['name']) ) {
    $aConfiguration[$pInstance]['name'] = $pInstance;
  }


  // Ask for basedir

  $basedir = askForBasedir($aConfiguration[$pInstance]);
  $aConfiguration[$pInstance]['basedir'] = $basedir;

  if ( ! is_dir($aConfiguration[$pInstance]['basedir']) ) {
    print "WARNING: Directory " . $aConfiguration[$pInstance]['basedir'] . " is NOT a directory or does not exist.\n";
    print "Creating directory " . $aConfiguration[$pInstance]['basedir'] . "\n";
    mkdir($aConfiguration[$pInstance]['basedir']);
  }


  // Install binaries as well

  if ( is_dir($aConfiguration[$pInstance]['basedir']) && (count(glob($aConfiguration[$pInstance]['basedir'] . '/*')) == 0) ) {

    print "\n";
    $key = answerQuestion("Shall I download and install mysql binaries under " . $aConfiguration[$pInstance]['basedir'] . " (Y/n)? ", array('y', 'n'), 'y');
    if ( $key == 'y' ) {

      $basedir = $aConfiguration[$pInstance]['basedir'];

      if ( $basedir == '' ) {
        $rc = 702;
        error("MyEnv is not installed yet. Please install MyEnv first with the command installMyEnv.php");
        exit($rc);
      }

      // require("$basedir/lib/myEnv.inc");
      // $lConfFile = $_ENV['MYENV_BASE'] . '/' . 'etc/' . 'myenv.conf';
      $lConfFile = '/etc/myenv/myenv.conf';
      debug("ConfFile: $lConfFile");

      if ( ! file_exists($lConfFile) ) {
        $rc = 703;
        error("MyEnv configuration file $lConfFile does not exist.");
        exit($rc);
      }

      list($ret, $aConfiguration) = getConfiguration($lConfFile);

      $lProductDir = $_ENV['HOME'] . '/' . 'product';
      $lTmpDir     = $_ENV['HOME'] . '/' . 'tmp';

      if ( ! is_dir($lProductDir) ) {
        echo "\n";
        echo "INFO: Product directory $lProductDir does not exist yet.\n";
        echo "INFO: Creating it now.\n";
        mkdir($lProductDir, 0755, true);
      }

      if ( ! is_dir($lTmpDir) ) {
        echo "\n";
        echo "INFO: Tmp directory $lTmpDir does not exist yet.\n";
        echo "INFO: Creating it now.\n";
        mkdir($lTmpDir, 0755, true);
      }

      // Download URL

      print "\n";
      print "For example: http://dev.mysql.com/get/Downloads/MySQL-5.5/mysql-5.5.24-linux2.6-x86_64.tar.gz/from/http://cdn.mysql.com/\n";
      do {
        $url = readline("Please enter the URL for the binary-tarball (Linux non RPM packages) to download: ");
      } while ( $url == '');

      echo "\n";
      $lVersion = extractVersion($url);
      if ( $lVersion == '' ) {
        echo "Version cannot be determined.\n";
      }
      else {
        echo "The version is: $lVersion\n";
      }

      // todo: compare download with platform

      // todo: check if wget or curl is available

      // download
      echo "\n";
      $command = "wget --directory-prefix=$lTmpDir $url 2>&1";
      $stdout = exec($command, $output, $ret);

      if ( $ret != 0 ) {
        $rc = 704;
        error("Download failed. Please try again or manually.");
        exit($rc);
      }

      // get binary path from stdout!
      // Saving to: `/home/myenv/tmp/mysql-5.1.41-linux-i686-glibc23.tar.gz'

      if ( preg_match("/$lTmpDir\/(mysql.*.tar.gz)/", $stdout, $matches) ) {
        $lTarBall = $matches[1];
        echo "Tar-ball file is: $lTarBall\n";
      }
      else {
        $rc = 705;
        error("Cannot extract filename from output. Please try manually.\n");
        exit($rc);
      }

      // todo: check checksum

      // extract binary
      $command = "tar xf $lTmpDir . '/' . $lTarBall --directory $lProductDir";
      echo $command . "\n";
      exec($command, $output, $ret);

      $lBinaryDir = substr($lTarBall, 0, strlen($lTarBall)-strlen('.tar.gz'));

      // create link
      echo "ln -s $lProductDir . '/' . $lBinaryDir $lProductDir . '/' . 'mysql-' . $lVersion\n";
      symlink($lProductDir . '/' . $lBinaryDir, $lProductDir . '/' . 'mysql-' . $lVersion);
    }
  }
  else {
    print "\n";
    print $aConfiguration[$pInstance]['basedir'] . " seems to exist and has already some files in it.\n";
    print "Omitting installation of binary tar ball.\n";
  }

  // datadir
  print "\n";
  print "Set datadir. The datadir is the directory where your MySQL data are located.\n";
  if ( isset($aConfiguration[$pInstance]['datadir']) && ($aConfiguration[$pInstance]['datadir'] != '') ) {
    $default = $aConfiguration[$pInstance]['datadir'];
  }
  else {
    $default = "$lHomeDir/data/$pInstance";
  }
  print "Example: /usr/local/mysql/data, /opt/mysql/data or /var/lib/mysql or " . $aConfiguration[$pInstance]['basedir'] . "/data or [$lHomeDir/data/$pInstance] or $default";
  print "\n";
  $aConfiguration[$pInstance]['datadir'] = rtrim(readline("datadir = "), '/');
  print "\n";

  if ( isset($aConfiguration[$pInstance]['datadir']) && ($aConfiguration[$pInstance]['datadir'] == '') ) {
    $aConfiguration[$pInstance]['datadir'] = $default;
  }
  if ( is_dir($aConfiguration[$pInstance]['datadir']) ) {
    print "WARNING: directory " . $aConfiguration[$pInstance]['datadir'] ." already exist.\n";
  }
  else {
    print "Creating directory " . $aConfiguration[$pInstance]['datadir'] . "\n";
    mkdir($aConfiguration[$pInstance]['datadir'], 0755, true);
  }


  // Install instance

  installInstance($aConfiguration[$pInstance]);


  // port

  print "\n";
  print "Set port.\n";
  if ( isset($aConfiguration[$pInstance]['port']) && ($aConfiguration[$pInstance]['port'] != '') ) {
    $default = $aConfiguration[$pInstance]['port'];
  }
  else {
    $default = 3306;
  }
  print "Example: 3307 or [$default]\n";
  $input = intval(readline("port    = "));
  if ( $input == 0 ) {
    $aConfiguration[$pInstance]['port'] = $default;
  }
  else {
    $aConfiguration[$pInstance]['port'] = $input;
  }
  print "\n";

  // Check if port already is in use
  foreach( getInstances($aConfiguration) as $instance ) {

    if ( ($aConfiguration[$instance]['port'] == $aConfiguration[$pInstance]['port']) && ($instance != $pInstance) ) {
      print "WARNING: Port " . $aConfiguration[$pInstance]['port'] . " already exists under instance $instance.\n";
    }
  }


  // Ask for socket

  $socket = askForSocket($aConfiguration[$pInstance]);
  $aConfiguration[$pInstance]['socket'] = $socket;


  // Ask for my.cnf

  $mycnf = askForMyCnf($aConfiguration[$pInstance]);
  $aConfiguration[$pInstance]['my.cnf'] = $mycnf;

  return $rc;
}

// ---------------------------------------------------------------------
function getInstances($aConfiguration)
// ---------------------------------------------------------------------
{
  $aInstance = array();

  foreach ( $aConfiguration as $key => $value ) {

    if ( $key != 'default' ) {
      array_push($aInstance, $key);
    }
  }
  return $aInstance;
}

// ---------------------------------------------------------------------
function installInstance($aConfiguration)
// ---------------------------------------------------------------------
{

  // Check if datadir exists and is empty directory
  if ( is_dir($aConfiguration['datadir']) && (count(glob($aConfiguration['datadir'] . '/mysql/*')) == 0) ) {

    print "\n";
    $key = answerQuestion("Shall I install a mysql database under " . $aConfiguration['datadir'] . " (Y/n)? ", array('y', 'n'), 'y');
    if ( $key == 'y' ) {

      if ( file_exists($aConfiguration['basedir'] . '/scripts/mysql_install_db') ) {
        $bin = $aConfiguration['basedir'] . '/scripts/mysql_install_db';
      }
      else {
        $bin = $aConfiguration['basedir'] . '/bin/mysql_install_db';
      }

      if ( file_exists($bin) && is_executable($bin) ) {
        $cmd = $bin . " --datadir=" . $aConfiguration['datadir'] . " --basedir=" . $aConfiguration['basedir'];
        exec($cmd, $output, $ret);
      }
      else {
        print "ERROR: File $bin does not exists or is not executable.\n";
        print "Omitting installation of mysql database.\n";
      }
    }
  }
  else {
    print $aConfiguration['datadir'] . " seems to exist and has already some files in it.\n";
    print "Omitting installation of mysql database.\n";
  }
}

// ---------------------------------------------------------------------
function askForMyCnf($aConfiguration)
// ---------------------------------------------------------------------
{

  $aMyCnfCandidates = array(
    '/etc/my.cnf'
  , '/etc/mysql/my.cnf'
  , $aConfiguration['datadir'] . '/my-' . $aConfiguration['port'] . '.cnf'
  , $aConfiguration['datadir'] . '/my.cnf'
  );

  // Default my.cnf:
  if ( isset($aConfiguration['my.cnf']) && ($aConfiguration['my.cnf'] == '') ) {
    $default = $aConfiguration['datadir'] . "/my.cnf";
  }
  elseif ( isset($aConfiguration['my.cnf']) && ($aConfiguration['my.cnf'] != '') ) {
    $default = $aConfiguration['my.cnf'];
    array_push($aMyCnfCandidates, $default);
  }
  else {
    $default = $aConfiguration['datadir'] . '/my.cnf';
  }

  $aMyCnfCandidates = array_unique($aMyCnfCandidates);

  print "\n";
  print "Choose location of my.cnf:\n";
  print "Example: ";

  foreach ( $aMyCnfCandidates as $mycnf ) {
    if ( $mycnf == $default ) {
      print '[' . $mycnf . ']';
    }
    else {
      print $mycnf;
    }
    print ' ';
  }
  print "\n";

  $aConfiguration['my.cnf'] = readline("my.cnf  = ");
  if ( $aConfiguration['my.cnf'] == '' ) {
    $aConfiguration['my.cnf'] = $default;
  }
  print "\n";

  if ( $aConfiguration['my.cnf'] == '' ) {
    print "WARNING: empty my.cnf!\n";
    print "Please create manually.\n";
  }
  // Create my.cnf if not exits
  elseif ( ! is_file($aConfiguration['my.cnf']) ) {
    print "INFO: There is no such file " . $aConfiguration['my.cnf'] . " yet.\n";
    print "Creating file " . $aConfiguration['my.cnf'] . "\n";

    // todo: use our template and make it better. Should come in v1.0.2 or v1.1

    ini_set('track_errors', 1);
    if ( $fh = @fopen($aConfiguration['my.cnf'], 'w') ) {
      fwrite($fh, "[client]\n
port                                   = " . $aConfiguration['port'] . "
socket                                 = " . $aConfiguration['socket'] . "\n\n
[mysqld]\n
basedir                                = " . $aConfiguration['basedir'] . "
datadir                                = " . $aConfiguration['datadir'] . "
port                                   = " . $aConfiguration['port'] . "
socket                                 = " . $aConfiguration['socket'] . "\n
server-id                              = " . $aConfiguration['port'] . "\n\n");
      fclose($fh);
      chmod($aConfiguration['my.cnf'], 0600);
    }
    // Opening my.cnf for writing failed (e.g. /etc/my.cnf)
    else {
      $rc = 706;
      error("Writing to file " . $aConfiguration['my.cnf'] . " failed (rc=$rc)");
      error($php_errormsg);
    }
  }

  print "\n";

  return $aConfiguration['my.cnf'];
}

// ---------------------------------------------------------------------
function askForSocket($aConfiguration)
// ---------------------------------------------------------------------
{
  $aSocketCandidates = array(
    '/tmp/mysql-' . $aConfiguration['port'] . '.sock'
  , '/tmp/mysql-' . $aConfiguration['name'] . '.sock'
  , '/tmp/mysql.sock'
  , '/var/run/mysqld/mysql.sock'
  );

  // Default socket:
  if ( isset($aConfiguration['socket']) && ($aConfiguration['socket'] == '') ) {
    // /tmp/mysql-3306.sock
    $default =  "/tmp/mysql-" . $aConfiguration['port'] . ".sock";
  }
  elseif ( isset($aConfiguration['socket']) && ($aConfiguration['socket'] != '') ) {
    $default =  $aConfiguration['socket'];
    array_push($aSocketCandidates, $default);
  }
  else {
    $default = '/tmp/mysql.sock';
  }

  $aSocketCandidates = array_unique($aSocketCandidates);

  print "\n";
  print "Set socket.\n";
  print "Example: ";
  foreach ( $aSocketCandidates as $socket ) {
    if ( $socket == $default ) {
      print '[' . $socket . ']';
    }
    else {
      print $socket;
    }
    print ' ';
  }
  print "\n";
  $aConfiguration['socket'] = readline("socket  = ");
  if ( $aConfiguration['socket'] == '' ) {
    $aConfiguration['socket'] = $default;
  }
  print "\n";

  return $aConfiguration['socket'];
}

// ---------------------------------------------------------------------
function askForBasedir($aConfiguration)
// ---------------------------------------------------------------------
{
  $lHomeDir = $_ENV['HOME'];

  // Guess candidates from /home/mysql/product
  $aCandidates = glob($lHomeDir . '/product/*', GLOB_ONLYDIR);

  $aBasedirCandidates = array_merge($aCandidates, array(
    '/usr/local/mysql'
  , '/opt/mysql'
//  , $lHomeDir . '/product/mysql-5.6.13'
  , '/usr'
  ));

  // Default basedir:
  if ( isset($aConfiguration['basedir']) && ($aConfiguration['basedir'] == '') ) {
    // /home/mysql/product/mysql
    $default =  $lHomeDir . '/product/mysql';
  }
  elseif ( isset($aConfiguration['basedir']) && ($aConfiguration['basedir'] != '') ) {
    $default =  $aConfiguration['basedir'];
    array_push($aBasedirCandidates, $default);
  }
  else {
    $default = '/usr';
  }

  $aBasedirCandidates = array_unique($aBasedirCandidates);

  print "\n";
  print "Set basedir. The basedir is the directory where your MySQL binaries are located.\n";
  print "Example: ";
  foreach ( $aBasedirCandidates as $basedir ) {
    if ( $basedir == $default ) {
      print '[' . $basedir . ']';
    }
    else {
      print $basedir;
    }
    print "\n";
  }
  print "\n";

  $aConfiguration['basedir'] = rtrim(readline("basedir = "), '/');
  if ( $aConfiguration['basedir'] == '' ) {
    $aConfiguration['basedir'] = $default;
  }
  print "\n";

  return $aConfiguration['basedir'];
}


?>
