#!/bin/bash

#
# installMyEnv
#

PHPINSTALLER=`dirname $(readlink -f $0)`"/installMyEnv.php"
export MYENV_BASE=$(dirname `dirname $PHPINSTALLER`)

PHP=`which php`
ret=$?

if [ $ret -ne 0 ] ; then
	rc=1
	echo "ERROR: Cannot find PHP."
	echo "Please install PHP as follows:"
	echo "RedHat/CentOS: shell> sudo yum install php-cli";
	echo "Ubuntu/Debian: shell> sudo apt-get install php5-cli";
	echo "SLES/OpenSuSE: shell> sudo zypper install php5";
  exit $rc
fi

echo "PHP is installed on $PHP"

echo "Starting MyEnv installer: $PHPINSTALLER"
cmd="$PHP -f $PHPINSTALLER"
if [ $MYENV_DEBUG ] ; then
  echo $cmd
fi
eval $cmd
rc=$?

if [ $MYENV_DEBUG ] ; then
  echo $rc
fi
exit $rc
