#!/usr/bin/php
<?php

$rc = 0;

date_default_timezone_set('Europe/Zurich');

// Caution $_ENV variables are not be known here yet when variables_order
// does NOT contain E!!!
if ( isset($_ENV['MYENV_BASE']) ) {
  $basedir = strval($_ENV['MYENV_BASE']);
}
// We have to guess:
else {
  $basedir = dirname(dirname(__FILE__));
}

require_once($basedir . '/lib/myEnv.inc');
require_once($basedir. '/lib/installMyEnv.inc');

if ( checkMyEnvRequirements() == ERR ) {
  $rc = 700;
  exit($rc);
}

$_ENV['MYENV_BASE'] = $basedir;
$lHomeDir = $_ENV['HOME'];
$lDebug    = isset($_ENV['MYENV_DEBUG']) ? strval($_ENV['MYENV_DEBUG']) : '';

$lConfFile         = '/etc/myenv/myenv.conf';
$lConfFileTemplate = $basedir . '/' . 'etc/' . 'myenv.conf' . '.template';

// ---------------------------------------------------------------------
// Start here
// ---------------------------------------------------------------------

// Initial empty line for better readability
print "\n";

if ( $lDebug != '' ) {
  print "MYENV_DEBUG: basedir=$basedir\n";
  print "MYENV_DEBUG: ConfFile: $lConfFile\n";
}


// Check if installer is started as root user
$lCurrentUser = getCurrentUser();
if ( $lCurrentUser == 'root' ) {

  print "You started the MyEnv installer as user root. You should better use a user like mysql or similar.\n";
  $key = answerQuestion("Do you really want to continue? [y/N]? ", array('y', 'n'), 'n');
  if ( $key == 'n' ) {
    exit(0);
  }
}


// Check if mysql user exists

$file = '/etc/passwd';
$fh = fopen($file, 'r');
if ( ! $fh ) {
  $rc = 716;
  print "ERROR: Cannot open file $file (rc=$rc).\n";
  // No exit here
}
$user = '';
while ( ($buffer = fgets($fh, 4096)) !== false ) {
  if ( substr($buffer, 0, 6) == 'mysql:' ) {
    $user = 'mysql';
  }
}
if ( ! feof($fh) ) {
  $rc = 717;
  print "ERROR: Unexpected fgets() fail (rc=$rc).\n";
  // No exit here
}
fclose($fh);
if ( $user != 'mysql' ) {
  $rc = 708;
  print "ERROR: User mysql does not exist (rc=$rc).\n";
  print "       Create such a user as follows:\n";
  print "       shell> groupadd mysql\n";
  print "       shell> useradd -r -g mysql mysql\n";
  print "       http://dev.mysql.com/doc/refman/5.5/en/binary-installation.html\n";
  answerQuestion("done? ", array(''), '');
  // No exit here
}

// Check if /etc/myenv exists and if it belongs to user mysql

$etc_myenv = '/etc/myenv';

if ( ! is_dir($etc_myenv) ) {

  print "ERROR: Directory $etc_myenv does NOT exist. Please create it\n";
  print "       as follows:\n";
  print "       shell> sudo mkdir $etc_myenv\n";
  print "       shell> sudo chown -R mysql: $etc_myenv\n";
  answerQuestion("done? ", array(''), '');
}

$aPwUid = posix_getpwuid(fileowner($etc_myenv));
if ( $aPwUid['name'] != 'mysql' ) {

  print "ERROR: Directory $etc_myenv does NOT belong to user mysql. Please change\n";
  print "       as as follows:\n";
  print "       shell> sudo chown -R mysql: $etc_myenv\n";
  answerQuestion("done? ", array(''), '');
}

// Check if myenv.conf exists
// Use this? Overwrite with template? Abort?
if ( file_exists($lConfFile) ) {
  print "Configuration file $lConfFile already exists.\n\n";
  $key = answerQuestion("Use this, overwrite with template or abort (U,t,a): ", array('u', 't', 'a'), 'u');
  print "\n";
  if ( $key == 'u' ) {
    // do nothing
  }
  elseif ( $key == 't' ) {
    $rc = 709;
    if ( copyFromTemplate($lConfFileTemplate, $lConfFile) != 0 ) {
      print "Aborting... (rc=$rc)\n";
      exit($rc);
    }
  }
  elseif ( $key == 'a' ) {
    print "Aborting...\n";
    exit($rc);
  }
  else {
    $rc = 710;
    error("Fatal error. Please report this (rc=$rc, key=$key)!");
    exit($rc);
  }
}
// myenv.conf does not exits
// Copy from template?
else {
  print "\nConfiguration file $lConfFile does NOT exist.\n";
  $key = answerQuestion("Copy from template or abort (T, a): ", array('t', 'a'), 't');
  if ( $key == 't' ) {
    $rc = 711;
    if ( copyFromTemplate($lConfFileTemplate, $lConfFile) != 0 ) {
      print "Aborting... (rc=$rc)\n";
      exit($rc);
    }
  }
  elseif ( $key == 'a' ) {
    print "Aborting...\n";
    exit($rc);
  }
  else {
    $rc = 712;
    error("Fatal error. Please report this (rc=$rc, key=$key)!");
    exit($rc);
  }
}

// Get configuration and display for selection
list($ret, $aConfiguration) = getConfiguration($lConfFile);

// Loop as long as customer wants some changes
do {

  $aInstance = getInstances($aConfiguration);

  if ( count($aInstance) > 0 ) {
    print "The following instances are available:\n\n";
    foreach ($aInstance as $instance) {
      print $instance . ' ';
    }
    print "\n";
  }
  else {
    print "\nNo instance exists yet.\n";
  }

  print "An instance is the same as a mysqld process.\n";
  print "\n";
  $key = answerQuestion("What do you want to do next?
o Add a new instance,
o change an existing instance,
o delete an existing instance,
o safe configuration and exit or
o quit without saving
 (A/c/d/s/q)? ", array('a', 'c', 'd', 's', 'q'), 'a');
  print "\n";

  if ( $key == 'a' ) {
    addInstance();
  }
  else if ( $key == 'c' ) {

    if ( count($aInstance) > 0 ) {
      print "The following instances are available to change:\n";
      print "\n";
      foreach ($aInstance as $instance) {
        print $instance . ' ';
      }
      print "\n";
    }
    else {
      print "No instance exists yet.\n";
    }
    print "\n";
    $instance = readline("Enter instance name to change: ");
    if ( $instance == '' ) {
      print "Please enter an instance name.\n\n";
    }
    else {
    print "\n";
      changeInstance($instance);
    }
  }
  else if ( $key == 'd' ) {

    if ( count($aInstance) > 0 ) {
      print "The following instances are available to delete:\n";
      print "\n";
      foreach ($aInstance as $instance) {
        print $instance . ' ';
      }
      print "\n";
    }
    else {
      print "No instance exists yet.\n";
    }
    print "\n";
    $instance = readline("Enter instance name to delete: ");
    if ( $instance == '' ) {
      print "Please enter an instance name.\n\n";
    }
    else {
      print "\n";
      $ret = deleteInstance($instance);
      if ( $ret != 0 ) {
        readline("Press Enter to continue...");
        print "\n\n";
      }
    }
  }
  else if ( $key == 's' ) {
    // do nothing
  }
  else if ( $key == 'q' ) {
    // do nothing
  }
  else {
    $rc = 713;
    error("Fatal error. Please report this (rc=$rc, key=$key)!");
    exit($rc);
  }

} while ( ($key != 'q') && ($key != 's') );

// Abort without safing...
if ( $key == 'q' ) {
  // ask if we are really sure!
  // but only if config has chnaged...
  print "Aborting...\n";
  exit($rc);
}
// Abort with safing
elseif  ( $key == 's' ) {

  // Writing the configuration file
  print "\n";
  print "Writing the configuration file...\n";

  $lConfFileBak      = $lConfFile . '.' . date("Y-m-d-h-i-s");

  if ( file_exists($lConfFileBak) ) {
    unlink($lConfFileBak);
  }
  print "Rename $lConfFile to $lConfFileBak\n";
  if ( rename($lConfFile, $lConfFileBak) ) {

    print "Write $lConfFile\n";
    if ( $fh = fopen($lConfFile, 'w') ) {

      foreach ( $aConfiguration as $instance => $record ) {

        fwrite($fh, "[$instance]\n\n");
        foreach ( $record as $key => $value ) {
          fwrite($fh, sprintf("%-20s = %s\n", $key, $value));
        }
        fwrite($fh, "\n\n");
      }
      fclose($fh);
    }
    else {
      // Writing config file failed
      // Rolling back!
    }
  }
  else {
    $rc = 714;
    print "Renaming the configuration file $lConfFile to $lConfFileBak failed.\n";
    exit($rc);
  }
}
else {
  $rc = 715;
  error("Fatal error. Please report this (rc=$rc, key=$key)!");
  exit($rc);
}

// Adding myenv.profile to interactive shell startup file ~/.bash_profile

if ( is_readable("$lHomeDir/.bash_profile") ) {
  $tag = "# BEGIN MyEnv";
  $cmd = "grep --max-count=1 '$tag' $lHomeDir/.bash_profile";
  # print "$cmd\n";
  exec($cmd, $output, $ret);
}
else {
  $ret = 1;
}

// We have to add the hook
if ( $ret == 1 ) {

  // todo: This is redundant with profile.template!!!
  $lSourceSequence  = ". /etc/myenv/MYENV_BASE\n";
  $lSourceSequence .= 'MYENV_PWD=`pwd`' . "\n";
  $lSourceSequence .= 'cd $MYENV_BASE/bin' . "\n";
  $lSourceSequence .= ". myenv.profile\n";
  $lSourceSequence .= 'cd $MYENV_BASE;' . "\n";
  $lSourceSequence .= '$MYENV_BASE/bin/showMyEnvStatus.php;' . "\n";
  $lSourceSequence .= "cd - > /dev/null\n";
  $lSourceSequence .= 'cd $MYENV_PWD' . "\n";

  print "Do you want to add the following code to your ~/.bash_profile file?";
  print "\n\n";
  print $lSourceSequence;
  print "\n";

  $key = answerQuestion("(Y/n)? ", array('y', 'n'), 'y');
  if ( $key == 'y' ) {

    if ( $fh = fopen("$lHomeDir/.bash_profile", 'a') ) {

      fwrite($fh, "\n");
      fwrite($fh, "# BEGIN MyEnv\n");
      fwrite($fh, "# Written by the MyEnv installMyEnv.php script.\n");
      fwrite($fh, $lSourceSequence);
      fwrite($fh, "# END MyEnv\n");
      fclose($fh);
    }
  }
}

// Add MYENV_HOOK
$MYENV_HOOK = '/etc/myenv/MYENV_BASE';
if ( ! file_exists($MYENV_HOOK) ) {

  print "\nWriting " . $MYENV_HOOK . "\n";
  if ( $fh = fopen($MYENV_HOOK, 'a') ) {

    $lLikedBase = preg_replace("|(.*/myenv)-.*|", "$1", $_ENV['MYENV_BASE']);
    fwrite($fh, "export MYENV_BASE=" . $lLikedBase . "\n");
    fclose($fh);
  }
  if ( ! file_exists($_ENV['MYENV_BASE'] . '/etc/aliases.conf') ) {
    copy($_ENV['MYENV_BASE'] . '/etc/aliases.conf.template', '/etc/myenv/aliases.conf');
  }
  if ( ! file_exists($_ENV['MYENV_BASE'] . '/etc/variables.conf') ) {
    copy($_ENV['MYENV_BASE'] . '/etc/variables.conf.template', '/etc/myenv/variables.conf');
  }
}

// Add MYENV_HOOK
$MYENV_INIT = '/etc/init.d/myenv';
if ( ! file_exists($MYENV_INIT) ) {
  print "\n";
  print "Please copy yourself manually the MyEnv start/stop script to the following location:\n";
  print "shell> sudo cp " . $_ENV['MYENV_BASE'] . "/bin/myenv.server " . $MYENV_INIT . "\n";
  answerQuestion("done? ", array(''), '');

  print "and link it to your O/S runlevels:\n";
  print "RedHat/CentOS: shell> sudo chkconfig --add myenv; chkconfig myenv on\n";
  print "Ubuntu/Debian: shell> sudo update-rc.d myenv defaults\n";
  print "SLES/OpenSuSE: shell> sudo chkconfig --add myenv\n";
  answerQuestion("done? ", array(''), '');
}

print "\n";
print "Now source your profile as follows:\n";
print ". ~/.bash_profile\n";
print "\n";
print "The README gives some hints how to continue...\n";
print "\n";

exit($rc);

?>
