#!/usr/bin/perl -w

use strict;
use warnings;

my $DEBUG = 0;

# Input format length
my $default;

$default = 'root';
printf("%-27s %12s : ", 'User', '[' . $default . ']');
my $user =  <STDIN>;
chomp $user;
if ( $user eq '' ) {
  $user = $default;
}

$default = '';
printf("%-27s %12s : ", 'Password', '[' . $default . ']');
system('/bin/stty', '-echo');   # Disable echoing
my $password =  <STDIN>;
system('/bin/stty', 'echo');   # Turn it back on
print "\n";
chomp $password;
if ( $password eq '' ) {
  $password = $default;
}

$default = 'localhost';
printf("%-27s %12s : ", 'Host', '[' . $default . ']');
my $host =  <STDIN>;
chomp $host;
if ( $host eq '' ) {
  $host = $default;
}

$default = '3306';
printf("%-27s %12s : ", 'Port', '[' . $default . ']');
my $port =  <STDIN>;
chomp $port;
if ( $port eq '' ) {
  $port = $default;
}


$default  ='test';
printf("%-27s %12s : ", 'Schema from (or all)', '[' . $default . ']');
my $schema_from =  <STDIN>;
chomp $schema_from;
if ( $schema_from eq '' ) {
  $schema_from = $default;
}

my $convert = 'simple';
my $schema_to = $schema_from;
if ( $schema_from ne 'all' ) {

  $default = 'simple';
  printf("Simple  : ALTER TABLE xxx ENGINE = ...;\n");
  printf("Advanced: Copy table from one schema to\n");
  printf("          another with changing the\n");
  printf("          Storage Engine.\n");
  printf("%-27s %12s : ", 'Convert simple or advanced', '[' . $default . ']');
  $convert =  <STDIN>;
  chomp $convert;
  if ( $convert eq '' ) {
    $convert = $default;
  }

  if ( $convert eq "advanced" ) {

    $default = 'new';
    printf("%-27s %12s : ", 'Schema to', '[' . $default . ']');
    $schema_to =  <STDIN>;
    chomp $schema_to;
    if ( $schema_to eq '' ) {
      $schema_to = $default;
    }
    if ( $schema_to eq $schema_from ) {
      print 'Schema TO cannot be identical with schema FROM.' . "\n";
      exit;
    }
  }
}

$default = 'InnoDB';
printf("%-27s %12s : ", 'Engine to', '[' . $default . ']');
my $engine_to =  <STDIN>;
chomp $engine_to;
if ( $engine_to eq '' ) {
  $engine_to = $default;
}

# ----------------------------------------------------------------------

my $tmp_file = "/tmp/sql.$$";
if ( $DEBUG != 0 ) {
  print $tmp_file . "\n";
}
my $out_file;
if ( $schema_from eq 'all' ) {
  $out_file = '/tmp/alter_table_all.sql';
}
else {
  $out_file = '/tmp/alter_table_' . $schema_from . '.sql';
}

# simple
if ( $convert ne 'advanced' ) {

  open(my $fh, '>', $tmp_file) or die "Cannot open $tmp_file: $!";
  print $fh 'SET @schema_from = "' . $schema_from . '";' . "\n";
  print $fh 'SET @engine_to = "' . $engine_to . '";' . "\n";
  print $fh "\n";
  print $fh 'SELECT CONCAT(IF(engine = "' . $engine_to . '", "-- ", ""), "ALTER TABLE `", table_schema, "`.`", table_name' . "\n";
  print $fh '            , "` ENGINE=", @engine_to, ";") AS statement' . "\n";
  print $fh '  FROM information_schema.tables' . "\n";
  print $fh ' WHERE table_schema NOT IN ("mysql", "information_schema", "performance_schema", "mysql")' . "\n";
  print $fh '   AND table_type = "BASE TABLE"' . "\n";
  if ( $schema_from ne 'all' ) {
    print $fh '   AND table_schema = @schema_from' . "\n";
  }
  print $fh ";\n";
  close $fh;
}
# advanced
else {

  open(my $fh, '>', $tmp_file) or die "Cannot open $tmp_file: $!";
  print $fh 'SET @schema_from = "' . $schema_from . '";' . "\n";
  print $fh 'SET @schema_to = "' . $schema_to . '";' . "\n";
  print $fh 'SET @engine_to = "' . $engine_to . '";' . "\n";
  print $fh "\n";
  print $fh 'SELECT CONCAT(IF(engine = "' . $engine_to . '", "-- ", ""), "CREATE TABLE `", @schema_to, "`.`", table_name' . "\n";
  print $fh '            , "` LIKE `", @schema_from, "`.`", table_name, "`;") AS statement' . "\n";
  print $fh "  FROM information_schema.tables\n";
  print $fh ' WHERE table_schema = @schema_from' . "\n";
  print $fh '   AND table_type = "BASE TABLE"' . "\n";
  print $fh ";\n";
  print $fh "\n";
  print $fh 'SELECT CONCAT(IF(engine = "' . $engine_to . '", "-- ", ""), "ALTER TABLE `", @schema_to, "`.`", table_name' . "\n";
  print $fh '            , "` ENGINE=", @engine_to, ";") AS statement' . "\n";
  print $fh "  FROM information_schema.tables\n";
  print $fh ' WHERE table_schema = @schema_from' . "\n";
  print $fh '   AND table_type = "BASE TABLE"' . "\n";
  print $fh ";\n";
  print $fh "\n";
  print $fh 'SELECT CONCAT(IF(engine = "' . $engine_to . '", "-- ", ""), "INSERT INTO `", @schema_to, "`.`", table_name' . "\n";
  print $fh '            , "` SELECT * FROM `", @schema_from, "`.`", table_name, "`;") AS statement' . "\n";
  print $fh "  FROM information_schema.tables\n";
  print $fh ' WHERE table_schema = @schema_from' . "\n";
  print $fh '   AND table_type = "BASE TABLE"' . "\n";
  print $fh ";\n";
  print $fh "\n";
  print $fh 'SELECT CONCAT(IF(engine = "' . $engine_to . '", "-- ", ""), "DROP TABLE `", @schema_from, "`.`", table_name' . "\n";
  print $fh '            , ";") AS statement' . "\n";
  print $fh "  FROM information_schema.tables\n";
  print $fh ' WHERE table_schema = @schema_from' . "\n";
  print $fh '   AND table_type = "BASE TABLE"' . "\n";
  print $fh ";\n";
  close $fh;
}

# Some comments to out_file first
open(OUTFILE, '>' . $out_file);
print OUTFILE "-- Commented (--) lines means that these tables are already using the wanted Storage Engine.\n\n";
if ( $convert eq 'advanced' ) {
  print OUTFILE 'CREATE SCHEMA IF NOT EXISTS ' . $schema_to . ";\n\n";
}
print OUTFILE "warnings\n";
close(OUTFILE);

# We use this methode because DBD/DBI may NOT be installed...
my $cmd = "mysql --user=$user --password=$password --host=$host --port=$port < $tmp_file | grep -v statement >>$out_file";
system($cmd);
if ( $DEBUG == 0 ) {
  unlink $tmp_file;
}

# Get MySQL Version
# We use this methode because DBD/DBI may NOT be installed...
my $sql = 'SHOW GLOBAL VARIABLES WHERE Variable_name = "version"';
my $stdout = `mysql --user=$user --password=$password --host=$host --port=$port --execute='$sql' 2>&1 | grep version`;

my $version = '';
my $mr_version = '';
print "\n";
if ( $stdout =~ /^version\s+(\d+)\.(\d+)\.(\d+).*/ ) {
  $version = "$1.$2.$3";
  print "Version is   : $version\n";
  $mr_version = sprintf("%02d%02d%02d", $1, $2, $3);
  print "MR Version is: $mr_version\n";
}
else {
  print "Cannot determine version from $stdout\n";
}


# Complain for not supported MySQL versions

if ( $mr_version < '050000' ) {
  print "\nThe used MySQL version is 4.1 or less. These versions are not supported.\nResults are not predictable any more...\n";
}


# Find tables without a Primary Key

print "\nThe following tables might not have a Primary Key:\n";
# We use this methode because DBD/DBI may NOT be installed...
$sql = 'SELECT DISTINCT t.table_schema, t.table_name
  FROM information_schema.tables AS t
  LEFT JOIN information_schema.columns AS c ON t.table_schema = c.table_schema AND t.table_name = c.table_name AND c.column_key = "PRI"
 WHERE t.table_schema NOT IN ("information_schema", "mysql", "performance_schema")
   AND c.table_name IS NULL';
system("mysql --user=$user --password=$password --host=$host --port=$port --execute='$sql'");
print "The tables above not having a Primary Key will negatively affect perfor-\nmance and data consistency in MySQL Master/Slave replication and Galera\nCluster replication.\n";


# Check for too long Primary Keys for InnoDB

if ( $engine_to =~ /^innodb$/i ) {

  print "\nThe following tables might have a too long Primary Key for InnoDB (> 767 bytes):\n";

  $sql = 'SELECT table_schema, table_name
--     , data_type, character_octet_length, column_key
 , SUM(IF(data_type = "varchar", character_octet_length
     , IF(data_type = "char", character_octet_length
     , IF(data_type = "enum", 2
     , IF(data_type = "tinyint", 1
     , IF(data_type = "smallint", 2
     , IF(data_type = "mediumint", 3
     , IF(data_type = "int", 4
     , IF(data_type = "bigint", 8
     , IF(data_type = "timestamp", 4
     , IF(data_type = "datetime", 8
     , IF(data_type = "time", 4
     , IF(data_type = "date", 4
     , NULL))))))))))))) AS column_length
  FROM information_schema.columns
 WHERE column_key = "PRI"
   AND table_schema NOT IN ("information_schema", "mysql", "performance_schema")
 GROUP BY table_schema, table_name
 HAVING column_length > 767';
  system("mysql --user=$user --password=$password --host=$host --port=$port --execute='$sql'");
}


# Check for FULLTEXT index in MySQL 5.1 and 5.5

if ( $engine_to =~ /^innodb$/i ) {

  print "\n";
  
  if ( $mr_version < '050100' ) {
    print "We cannot find FULLTEXT indexes in MySQL version is 5.0 or older...\n";
  }
  else {

    if ( $mr_version < '050600' ) {

      print "The following tables might have a FULLTEXT index (which is only supported\nin MySQL 5.6 and newer):\n";

      $sql = 'SELECT table_schema, table_name, column_name
  FROM information_schema.statistics
 WHERE index_type = "FULLTEXT"';
      system("mysql --user=$user --password=$password --host=$host --port=$port --execute='$sql'");
    }
  }
}

print "\nOutput written to $out_file\n";
print "After reviewing it you can apply it with mysql --user=root --password=secret < $out_file\n";
exit;
