#!/usr/bin/php
<?php

$rc = 0;

ini_set('date.timezone', 'Europe/Zurich');
// ini_set('error_reporting', E_ALL & ~E_DEPRECATED);
// We want to be more radical:
ini_set('error_reporting', E_ALL);

// Caution $_ENV variables are not be known here yet when variables_order
// does NOT contain E!!!
if ( isset($_ENV['MYENV_BASE']) ) {
  $basedir = strval($_ENV['MYENV_BASE']);
}
// We have to guess:
else {
  $basedir = dirname(dirname(__FILE__));
}

require_once($basedir . '/lib/myEnv.inc');

if ( checkMyEnvRequirements() == ERR ) {
  $rc = 236;
  exit($rc);
}

$_ENV['MYENV_BASE'] = $basedir;
// This is needed for a proper path substitution
if ( isset($_ENV['MYENV_DATABASE']) ) {
  $lOldDatabase = $_ENV['MYENV_DATABASE'];
}
else {
  $lOldDatabase = '';
}

$lDebug    = isset($_ENV['MYENV_DEBUG']) ? strval($_ENV['MYENV_DEBUG']) : '';

$tmp           = strval($argv[1]);
$pDatabaseName = isset($argv[2]) ? strval($argv[2]) : '';

if ( $lDebug != '' ) {
  print "MYENV_DEBUG: tmp file: $tmp\n";
  print "MYENV_DEBUG: database: $pDatabaseName\n";
}

foreach ( array('/etc/my.cnf', '/etc/mysql/my.cnf', '/usr/local/mysql/etc/my.cnf', "~/.my.cnf") as $file ) {
  if ( file_exists($file) ) {
    print "Warning: $file exists. This can screw up myenv.\n";
  }
}

$lConfigurationFile = '/etc/myenv/myenv.conf';

if ( ! is_file($lConfigurationFile) ) {
  $rc = 237;
  print "Warning: Configuration file $lConfigurationFile does not exist!\n";
  print "         Please create or copy from $lConfigurationFile.template (rc=$rc).\n";
  exit($rc);
}

$aConfigurationFile = getConfiguration($lConfigurationFile);
$aDbNames = array();
foreach ( $aConfigurationFile as $dbname => $paramter ) {
  if ( $dbname != 'default' ) {
    array_push($aDbNames, $dbname);
  }
}

$lDbName = '';
if ( $pDatabaseName != '' ) {
  $lDbName = $pDatabaseName;
}
elseif ( isset($_ENV['MYENV_DATABASE']) ) {
  $lDbName = $_ENV['MYENV_DATABASE'];
}
// default database name
elseif ( isset($aConfigurationFile['default']['default']) && ($aConfigurationFile['default']['default'] != '') ) {
  $lDbName = $aConfigurationFile['default']['default'];
}
else {
  $lDbName = $aDbNames[0];
}

if ( $lDebug != '' ) {
  print "MYENV_DEBUG: database: $lDbName\n";
}

$_ENV['INFODIR']         = isset($_ENV['INFODIR']) ? $_ENV['INFODIR'] : '';
$_ENV['INFOPATH']        = isset($_ENV['INFOPATH']) ? $_ENV['INFOPATH'] : '';
# $_ENV['MANPATH']         = isset($_ENV['MANPATH']) ? $_ENV['MANPATH'] : '';
$_ENV['LD_LIBRARY_PATH'] = isset($_ENV['LD_LIBRARY_PATH']) ? $_ENV['LD_LIBRARY_PATH'] : '';

// getEnv
if ( $lOldDatabase == '' ) {
  $aOldDatabaseParameter = array('basedir' => '');
}
else {
  // If database was just deleted this array is empty!
  // And would cause some nasty error messages (Bug #104)
  if ( isset($aConfigurationFile[$lOldDatabase]) ) {
    $aOldDatabaseParameter = $aConfigurationFile[$lOldDatabase];
  }
  else {
    // Thus skip and set some default to prevent noise further down!
    $aOldDatabaseParameter['basedir'] = '';
  }
}
// If database was just deleted this array is empty!
// And would cause some nasty error messages (Bug #104)
if ( isset($aConfigurationFile[$lDbName]) ) {
  $aDatabaseParameter    = $aConfigurationFile[$lDbName];
}
// If DB is not set just set the first one
else {
  $aDatabaseParameter    = $aConfigurationFile[$aDbNames[0]];
}

$file = $aDatabaseParameter['basedir'] . '/my.cnf';
if ( file_exists($file) ) {
  print "Warning: $file exists. This can screw up myenv.\n";
}

// Check if my.cnf file is readable for group or others for security reasons
// printf("%o\n", fileperms($file));
$lConfFile = $aDatabaseParameter['datadir'] . '/my.cnf';

if ( file_exists($lConfFile) && ((fileperms($lConfFile) & 0x001c) > 0) ) {
  print "Warning: File $lConfFile is writeable for group or readable for others!\n";
}

// to avoid a complete mess:
$path = $_ENV['PATH'];
if ( $aDatabaseParameter['basedir'] != '' ) {

  foreach ( array('scripts', 'libexec', 'bin') as $dir ) {

    if ( $aOldDatabaseParameter['basedir'] != '' ) {
      $old = $aOldDatabaseParameter['basedir'] . '/' . $dir;
      $path = deleteDirectoryFromPath($path, $old);
    }

    $new = $aDatabaseParameter['basedir'] . '/'. $dir;
    if ( is_dir($new) ) {
      if ( $lDebug !='' ) { print "MYENV_DEBUG: substitute PATH $old by $new"; }
      // Clean-up to be sure
      $path = deleteDirectoryFromPath($path, $new);
      $path = addDirectoryToPath($path, $new, '', 'left');
    }
  }
}

foreach ( array('scripts', 'libexec', 'bin') as $dir ) {

  $new = $basedir . '/' . $dir;
  if ( is_dir($new) ) {
    if ( $lDebug !='' ) { print "MYENV_DEBUG: substitute PATH $old by $new"; }
    $path = addDirectoryToPath($path, $new, '', 'left');
  }
}

// and last myenv/utl path
$path = addDirectoryToPath($path, "$basedir/utl", '', 'right');

$fh = fopen($tmp, 'w');
if ( $fh === false ) {
  $rc = 238;
  fprint(STDERR, "Cannot open file $tmp\n");
  exit($rc);
}

// Add generic variables here

fwrite($fh, "export MYSQL_HOME=" . $aDatabaseParameter['basedir'] . "\n");
fwrite($fh, "export PATH=$path\n");
fwrite($fh, "export INFODIR=" . addDirectoryToPath($_ENV['INFODIR'], $aDatabaseParameter['basedir'] . "/docs", $aDatabaseParameter['basedir'] . "/docs") . "\n");
fwrite($fh, "export INFOPATH=" . addDirectoryToPath($_ENV['INFOPATH'], $aDatabaseParameter['basedir'] . "/docs", $aDatabaseParameter['basedir'] . "/docs") . "\n");
fwrite($fh, "export LD_LIBRARY_PATH=" . addDirectoryToPath($_ENV['LD_LIBRARY_PATH'], $aDatabaseParameter['basedir'] . "/lib", $aDatabaseParameter['basedir'] . "/lib") . "\n");
fwrite($fh, "export LD_LIBRARY_PATH=" . addDirectoryToPath($_ENV['LD_LIBRARY_PATH'], $aDatabaseParameter['basedir'] . "/lib/mysql", $aDatabaseParameter['basedir'] . "/lib/mysql") . "\n");
fwrite($fh, "export MYSQL_TCP_PORT=" . $aDatabaseParameter['port'] . "\n");
fwrite($fh, "export MYSQL_UNIX_PORT=" . $aDatabaseParameter['socket'] . "\n");
fwrite($fh, "export MYENV_DATABASE=" . $lDbName . "\n");
fwrite($fh, "export MYENV_DATADIR=" . $aDatabaseParameter['datadir'] . "\n");
fwrite($fh, "export MYENV_VERSION=" . '1.0.5' . "\n");
fwrite($fh, "export MYSQL_PS1='\u@\h " . $lDbName . " [\d] SQL> '\n");

// Add user export variables here

$conf = '/etc/myenv/variables.conf';
if ( is_readable($conf) ) {

  $aLines = file($conf, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);

  foreach ( $aLines as $line) {

    $line = trim($line);
    // print $line . "\n";

    // Skip commented lines
    if ( preg_match('/^\s*#/', $line) ) {
      continue;
    }

    $code = 'fwrite($fh, "' . $line . '\n");';
    if ( $lDebug != '' ) {
      print "MYENV_DEBUG: code: $code\n";
    }

    eval($code);
  }
}
else {
  // We do not care if file is not there
}

// Generic alias

foreach ( $aDbNames as $dbname ) {

  $alias = "alias $dbname='setMyEnv $dbname'\n";
  if ( $lDebug != '' ) {
    print "MYENV_DEBUG: alias: $alias\n";
  }
  fwrite($fh, $alias);
}

// Only if really exists!
if ( isset($aDatabaseParameter['clusterdir']) ) {

  if ( is_dir($aDatabaseParameter['clusterdir']) ) {
    $alias = "alias cdc='cd " . $aDatabaseParameter['clusterdir'] . "'\n";
    if ( $lDebug != '' ) {
      print "MYENV_DEBUG: alias: $alias\n";
    }
    fwrite($fh, $alias);
  }
  else {
    $alias = "alias cdc='echo directory " . $aDatabaseParameter['clusterdir'] . " does not exist.'\n";
    if ( $lDebug != '' ) {
      print "MYENV_DEBUG: alias: $alias\n";
    }
    fwrite($fh, $alias);
  }
}
else {
  $alias = "alias cdc='echo no clusterdir defined'\n";
  if ( $lDebug != '' ) {
    print "MYENV_DEBUG: alias: $alias\n";
  }
  fwrite($fh, $alias);
}

// Default myenv aliases

fwrite($fh, "alias cdh='cd " . $aDatabaseParameter['basedir'] . "'\n");
fwrite($fh, "alias cdb='cd " . $aDatabaseParameter['basedir'] . "'\n");
fwrite($fh, "alias cdd='cd " . $aDatabaseParameter['datadir'] . "'\n");
fwrite($fh, "alias cde='cd " . $basedir . "'\n");
fwrite($fh, "alias v='echo \$MYENV_VERSION'\n");
fwrite($fh, "alias cdl='cd " . $basedir . '/log' . "'\n");

fwrite($fh, "alias ll='ls -l'\n");
fwrite($fh, "alias la='ls -la'\n");

// RedHat style is not a bad idea!
fwrite($fh, "alias rm='rm -i'\n");
fwrite($fh, "alias mv='mv -i'\n");

// Add User alias here

$conf = '/etc/myenv/aliases.conf';
if ( is_readable($conf) ) {

  $aLines = file($conf, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);

  foreach ( $aLines as $line) {

    $line = trim($line);
    // print $line . "\n";

    // Skip commented lines
    if ( preg_match('/^\s*#/', $line) ) {
      continue;
    }

    $code = 'fwrite($fh, "' . $line . '\n");';
    if ( $lDebug != '' ) {
      print "MYENV_DEBUG: code: $code\n";
    }

    eval($code);
  }
}
else {
  // We do not care if file is not there
}

fclose($fh);

exit($rc);

?>
