/*
 * Decompiled with CFR 0.152.
 */
package com.ess.util;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Helper {
    private Helper() {
    }

    public static String toHtml(String s) {
        StringBuilder res = new StringBuilder();
        Helper.toHtml(res, s);
        return res.toString();
    }

    public static void toHtml(StringBuilder res, String s) {
        int i = 0;
        while (i < s.length()) {
            char a = s.charAt(i);
            switch (a) {
                case '<': {
                    res.append("&lt;");
                    break;
                }
                case '>': {
                    res.append("&gt;");
                    break;
                }
                case '&': {
                    res.append("&amp;");
                    break;
                }
                case '/': {
                    res.append("&#47;");
                    break;
                }
                case '\r': {
                    break;
                }
                case '\n': {
                    res.append("<br>");
                    break;
                }
                default: {
                    res.append(a);
                }
            }
            ++i;
        }
    }

    public static String toHtmlDocument(String s) {
        StringBuilder res = new StringBuilder("<html>");
        Helper.toHtml(res, s);
        res.append("</html>");
        return res.toString();
    }

    public static <A, B> Map<A, B> createUnmMap(Object[] data) {
        return Collections.unmodifiableMap(Helper.createMap(data));
    }

    public static String getCharHexCode(char a) {
        char[] s = new char[4];
        int i = 4;
        while (--i >= 0) {
            s[i] = (char)(a & 0xF);
            int n = i;
            s[n] = (char)(s[n] + (s[i] >= '\n' ? 55 : 48));
            a = (char)(a >> 4);
        }
        return String.copyValueOf(s);
    }

    public static String toUnicodeString(char a) {
        return "\\u" + Helper.getCharHexCode(a);
    }

    public static int nativeIndexOf(Object[] array, Object item) {
        int i = 0;
        while (i < array.length) {
            if (array[i] == item) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static int indexOf(Object[] array, Object item) {
        if (item == null) {
            int i = 0;
            while (i < array.length) {
                if (array[i] == null) {
                    return i;
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < array.length) {
                if (item.equals(array[i])) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }

    public static <T> Map<Character, T> createSimpleMap(final Object[] data) {
        if ((data.length & 1) != 0) {
            throw new IllegalArgumentException();
        }
        int i = 0;
        while (i < data.length) {
            if (data[i] == null || !(data[i] instanceof Character)) {
                throw new IllegalArgumentException();
            }
            i += 2;
        }
        return new Map<Character, T>(){
            private Set<Map.Entry<Character, T>> entrySet;

            @Override
            public void clear() {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean containsKey(Object key) {
                int i = 0;
                while (i < data.length) {
                    if (data[i].equals(key)) {
                        return true;
                    }
                    i += 2;
                }
                return false;
            }

            @Override
            public boolean containsValue(Object value) {
                int i = 1;
                while (i < data.length) {
                    if (value == null ? data[i] == null : value.equals(data[i])) {
                        return true;
                    }
                    i += 2;
                }
                return false;
            }

            @Override
            public Set<Map.Entry<Character, T>> entrySet() {
                if (this.entrySet == null) {
                    HashSet<1> res = new HashSet<1>();
                    int i = 0;
                    while (i < data.length) {
                        final Character key = (Character)data[i];
                        final Object value = data[i + 1];
                        res.add(new Map.Entry<Character, T>(){

                            @Override
                            public Character getKey() {
                                return key;
                            }

                            @Override
                            public T getValue() {
                                return value;
                            }

                            @Override
                            public T setValue(T value2) {
                                throw new UnsupportedOperationException();
                            }
                        });
                        i += 2;
                    }
                    this.entrySet = Collections.unmodifiableSet(res);
                }
                return this.entrySet;
            }

            @Override
            public T get(Object key) {
                int i = 0;
                while (i < data.length) {
                    if (data[i].equals(key)) {
                        return data[i + 1];
                    }
                    i += 2;
                }
                return null;
            }

            @Override
            public boolean isEmpty() {
                return data.length == 0;
            }

            @Override
            public Set<Character> keySet() {
                throw new UnsupportedOperationException();
            }

            @Override
            public T put(Character key, T value) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void putAll(Map<? extends Character, ? extends T> t) {
                throw new UnsupportedOperationException();
            }

            @Override
            public T remove(Object key) {
                throw new UnsupportedOperationException();
            }

            @Override
            public int size() {
                return data.length >> 1;
            }

            @Override
            public Collection<T> values() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static <A, B> Map<A, B> createMap(Object[] data) {
        assert ((data.length & 1) == 0);
        HashMap<Object, Object> res = new HashMap<Object, Object>();
        int i = 0;
        while (i < data.length) {
            res.put(data[i], data[i + 1]);
            i += 2;
        }
        return res;
    }

    public static <A, B> Map<A, B> createRevertMap(Map<B, A> map) {
        HashMap<A, B> res = new HashMap<A, B>();
        for (Map.Entry<B, A> e : map.entrySet()) {
            if (res.put(e.getValue(), e.getKey()) == null) continue;
            throw new IllegalArgumentException("Duplecated value");
        }
        return res;
    }
}

