/*
 * Decompiled with CFR 0.152.
 */
package com.ess.regexutil.views;

import com.ess.regexutil.Activator;
import com.ess.regexutil.escaping.JavaRegexTransfer;
import com.ess.regexutil.escaping.JavaScriptTransfer;
import com.ess.regexutil.escaping.RegexTransfer;
import com.ess.regexutil.escaping.XmlRegexTransfer;
import com.ess.regexutil.regexparser.Flags;
import com.ess.regexutil.views.DefaultFormValueManager;
import com.ess.regexutil.views.FindAndMatchePanel;
import com.ess.regexutil.views.FlagChangeAction;
import com.ess.regexutil.views.IRegexUtilPanel;
import com.ess.regexutil.views.ModeChangeAction;
import com.ess.regexutil.views.RegexEditor;
import com.ess.regexutil.views.ReplacePanel;
import com.ess.regexutil.views.SplitPanel;
import com.ess.util.EventListener;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;
import org.osgi.framework.BundleContext;

public class RegexView
extends ViewPart {
    private FindAndMatchePanel findAndMatchePanel;
    private SplitPanel splitPanel;
    private ReplacePanel replacePanel;
    private IRegexUtilPanel currentPanel;
    private final Flags flags = new Flags();
    private StackLayout layout;
    private Clipboard clipboard;

    public void createPartControl(Composite parent) {
        this.clipboard = new Clipboard(Display.getDefault());
        this.layout = new StackLayout();
        parent.setLayout((Layout)this.layout);
        IToolBarManager toolBarManager = this.getViewSite().getActionBars().getToolBarManager();
        final ModeChangeAction modeAction = new ModeChangeAction();
        toolBarManager.add((IAction)modeAction);
        modeAction.modeChangeListeners.addListener(new EventListener<ModeChangeAction.Mode>(){

            @Override
            public void notify(ModeChangeAction.Mode mode) {
                RegexView.this.setMode(mode);
            }
        });
        FlagChangeAction flagAction = new FlagChangeAction(this.flags);
        toolBarManager.add((IAction)flagAction);
        CopyAction actionCopySL = new CopyAction(JavaRegexTransfer.instance, "Copy For Java-String (escape '\\')");
        PasteAction actionPasteSL = new PasteAction(JavaRegexTransfer.instance, "Paste From Java-String (unescape '\\')");
        CopyAction actionCopyXml = new CopyAction(XmlRegexTransfer.instance, "Copy For XML (escape '>', '&', ...)");
        PasteAction actionPasteXml = new PasteAction(XmlRegexTransfer.instance, "Paste From XML (unescape '>', '&', ...)");
        CopyAction actionCopyJS = new CopyAction(JavaScriptTransfer.instance, "Copy For JavaScript");
        PasteAction actionPasteJS = new PasteAction(JavaScriptTransfer.instance, "Paste From JavaScript");
        toolBarManager.add((IContributionItem)new Separator());
        toolBarManager.add((IAction)actionPasteSL);
        toolBarManager.add((IAction)actionCopySL);
        toolBarManager.add((IContributionItem)new Separator());
        toolBarManager.add(this.createAboutAction());
        IAction[] actions = new IAction[]{actionCopySL, actionPasteSL, actionCopyXml, actionPasteXml, actionCopyJS, actionPasteJS};
        this.findAndMatchePanel = new FindAndMatchePanel(parent, this.flags, actions);
        this.splitPanel = new SplitPanel(parent, this.flags, actions);
        this.replacePanel = new ReplacePanel(parent, this.flags, actions);
        this.setMode(modeAction.getCurrentMode());
        modeAction.setCurrentModeById(DefaultFormValueManager.getInstance().getDefaultMode());
        this.currentPanel.getRegexEditor().setText(DefaultFormValueManager.getInstance().getDefaultRegex());
        this.currentPanel.getTextEditor().setText(DefaultFormValueManager.getInstance().getDefaultText());
        Activator.getDefault().stopListeners.addListener(new EventListener<BundleContext>(){

            @Override
            public void notify(BundleContext event) {
                DefaultFormValueManager.getInstance().save(RegexView.this.currentPanel.getRegexEditor().getAdapter().getText(), RegexView.this.currentPanel.getTextEditor().getText(), RegexView.this.replacePanel.getReplacement(), modeAction.getCurrentMode().ordinal());
            }
        });
    }

    private void setMode(ModeChangeAction.Mode mode) {
        switch (mode) {
            case Find: {
                this.setPane(this.findAndMatchePanel);
                this.findAndMatchePanel.setMatchMode(false);
                break;
            }
            case Matche: {
                this.setPane(this.findAndMatchePanel);
                this.findAndMatchePanel.setMatchMode(true);
                break;
            }
            case Split: {
                this.setPane(this.splitPanel);
                break;
            }
            case Replace: {
                this.setPane(this.replacePanel);
            }
        }
    }

    private IAction createAboutAction() {
        Action res = new Action(){

            public void run() {
                MessageDialog.openInformation((Shell)RegexView.this.getViewSite().getShell(), (String)"About Regex Util", (String)"http://myregexp.com/\n\n(c) 2007 by Sergey Evdokimov (sergey.evdokimov85@gmail.com)");
            }
        };
        res.setToolTipText("About");
        res.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJS_INFO_TSK"));
        return res;
    }

    private void setPane(IRegexUtilPanel panel) {
        if (panel == this.currentPanel) {
            return;
        }
        if (this.currentPanel != null) {
            panel.getRegexEditor().setText(this.currentPanel.getRegexEditor().getText());
            this.currentPanel.getRegexEditor().setText("");
            panel.getTextEditor().setText(this.currentPanel.getTextEditor().getText());
            this.currentPanel.getTextEditor().setText("");
        }
        this.currentPanel = panel;
        this.layout.topControl = panel.getPanel();
        panel.getPanel().getParent().layout();
    }

    public void setFocus() {
    }

    private class CopyAction
    extends Action {
        private final RegexTransfer tr;

        public CopyAction(RegexTransfer tr, String name) {
            this.tr = tr;
            this.setText(name);
            this.setToolTipText(name);
            this.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_COPY"));
        }

        public void run() {
            RegexEditor regexEditor = RegexView.this.currentPanel.getRegexEditor();
            String text = regexEditor.getSelectionText();
            if (text.length() == 0) {
                text = regexEditor.getText();
            }
            text = this.tr.regexToSource(text);
            RegexView.this.clipboard.setContents(new Object[]{text}, new Transfer[]{TextTransfer.getInstance()});
        }
    }

    private class PasteAction
    extends Action {
        private final RegexTransfer tr;

        public PasteAction(RegexTransfer tr, String name) {
            this.tr = tr;
            this.setText(name);
            this.setToolTipText(name);
            this.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_PASTE"));
        }

        public void run() {
            RegexEditor regexEditor = RegexView.this.currentPanel.getRegexEditor();
            String text = regexEditor.getText();
            Point sel = regexEditor.getSelection();
            String data = (String)RegexView.this.clipboard.getContents((Transfer)TextTransfer.getInstance());
            data = this.tr.sourceToRegex(data);
            regexEditor.setText(String.valueOf(text.substring(0, sel.x)) + data + text.substring(sel.y));
            int caret = sel.x + data.length();
            regexEditor.setSelection(caret, caret);
        }
    }
}

