/*
 * Decompiled with CFR 0.152.
 */
package com.ess.regexutil.views;

import com.ess.regexutil.Activator;
import com.ess.util.ListenersList;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

public class ModeChangeAction
extends Action
implements IMenuCreator {
    private static final Mode DEFAULT_MODE = Mode.Find;
    public final ListenersList<Mode> modeChangeListeners = new ListenersList();
    private Menu menu;
    private Mode currentMode = DEFAULT_MODE;

    public ModeChangeAction() {
        this.setMenuCreator(this);
        this.setText("Mode");
        this.setToolTipText("Mode");
        this.setImageDescriptor(Activator.getImageDescriptor("icons/mode.gif"));
    }

    public void dispose() {
        if (this.menu != null) {
            this.menu.dispose();
        }
    }

    public void setCurrentMode(Mode currentMode) {
        if (this.currentMode != currentMode) {
            this.currentMode = currentMode;
            this.modeChangeListeners.send(currentMode);
        }
    }

    public void setCurrentModeById(int currentMode) {
        Mode[] modes = Mode.values();
        Mode mode = currentMode < 0 || currentMode >= modes.length ? DEFAULT_MODE : modes[currentMode];
        this.setCurrentMode(mode);
    }

    public Menu getMenu(Control parent) {
        if (this.menu == null) {
            this.menu = new Menu(parent);
            Mode[] modeArray = Mode.values();
            int n = modeArray.length;
            int n2 = 0;
            while (n2 < n) {
                Mode mode;
                final Mode fMode = mode = modeArray[n2];
                final MenuItem item = new MenuItem(this.menu, 16);
                item.setText(mode.getText());
                item.setSelection(mode == this.currentMode);
                item.addSelectionListener(new SelectionListener(){

                    public void widgetDefaultSelected(SelectionEvent e) {
                    }

                    public void widgetSelected(SelectionEvent e) {
                        if (item.getSelection()) {
                            ModeChangeAction.this.setCurrentMode(fMode);
                        }
                    }
                });
                ++n2;
            }
        }
        return this.menu;
    }

    public Mode getCurrentMode() {
        return this.currentMode;
    }

    public Menu getMenu(Menu parent) {
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Mode {
        Find("Find sequence"),
        Matche("Match complete text"),
        Split("Split"),
        Replace("Replace");

        private final String text;

        private Mode(String name) {
            this.text = name;
        }

        public String getText() {
            return this.text;
        }
    }
}

