/*
 * Decompiled with CFR 0.152.
 */
package com.ess.regexutil.views;

import com.ess.regexutil.Activator;
import org.eclipse.jface.preference.IPreferenceStore;

public class DefaultFormValueManager {
    private static final String DEFAULT_TEXT = "1900-01-01 2007/08/13 1900.01.01 1900 01 01 1900-01.01 1900 13 01 1900 02 31";
    private static final String DEFAULT_REGEX_TEXT = "(19|20)\\d\\d([- /.])(0[1-9]|1[012])\\2(0[1-9]|[12][0-9]|3[01])";
    private static final String DEFAULT_REPLACEMENT = "1920$210$201";
    private static final int DEFAULT_MODE = 0;
    private static DefaultFormValueManager instance = new DefaultFormValueManager();
    private boolean isInit;
    private String defaultRegex;
    private String defaultText;
    private String defaultReplacement;
    private int defaultMode;

    public static DefaultFormValueManager getInstance() {
        return instance;
    }

    private DefaultFormValueManager() {
    }

    private void init() {
        if (!this.isInit) {
            IPreferenceStore pref = Activator.getDefault().getPreferenceStore();
            boolean saved = pref.getBoolean("saved");
            if (saved) {
                this.defaultRegex = pref.getString("defaultRegex");
                this.defaultText = pref.getString("defaultText");
                this.defaultReplacement = pref.getString("defaultReplacement");
                this.defaultMode = pref.getInt("defaultMode");
                if (DEFAULT_REPLACEMENT.equals(this.defaultReplacement) && !DEFAULT_REGEX_TEXT.equals(this.defaultRegex)) {
                    this.defaultReplacement = "";
                }
            } else {
                this.defaultRegex = DEFAULT_REGEX_TEXT;
                this.defaultText = DEFAULT_TEXT;
                this.defaultReplacement = DEFAULT_REPLACEMENT;
                this.defaultMode = 0;
            }
            this.isInit = true;
        }
    }

    public String getDefaultRegex() {
        this.init();
        return this.defaultRegex;
    }

    public String getDefaultText() {
        this.init();
        return this.defaultText;
    }

    public int getDefaultMode() {
        this.init();
        return this.defaultMode;
    }

    public String getDefaultReplacement() {
        this.init();
        return this.defaultReplacement;
    }

    public void save(String regex, String text, String replacement, int mode) {
        this.defaultRegex = regex;
        this.defaultText = text;
        this.defaultReplacement = replacement;
        this.defaultMode = mode;
        IPreferenceStore pref = Activator.getDefault().getPreferenceStore();
        pref.setValue("defaultRegex", this.defaultRegex);
        pref.setValue("defaultText", this.defaultText);
        pref.setValue("defaultReplacement", this.defaultReplacement);
        pref.setValue("defaultMode", this.defaultMode);
        pref.setValue("saved", true);
        Activator.getDefault().savePluginPreferences();
    }
}

