/*
 * Decompiled with CFR 0.152.
 */
package com.ess.regexutil.swtadapter;

import com.ess.regexutil.parsedtext.ITextEditorAdapter;
import com.ess.regexutil.parsedtext.ITextStyle;
import com.ess.regexutil.parsedtext.StyleData;
import com.ess.regexutil.parsedtext.TextStyle;
import com.ess.util.IListenersList;
import com.ess.util.ListenersList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SWTAdapter
implements ITextEditorAdapter {
    private final ListenersList<String> changeListeners = new ListenersList();
    private final StyledText editor;
    private String text;
    private int caret;
    private Point selection;
    private boolean hasFocus;
    private ITextEditorAdapter.TooltipResolver tooltipResolver;
    private static final Map<Integer, Color> colorMap = new HashMap<Integer, Color>();

    public SWTAdapter(final StyledText editor) {
        this.editor = editor;
        this.text = editor.getText();
        this.caret = editor.getCaretOffset();
        this.selection = editor.getSelection();
        editor.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                SWTAdapter.this.hasFocus = true;
                SWTAdapter.this.someChange();
            }

            public void focusLost(FocusEvent e) {
                SWTAdapter.this.hasFocus = false;
                SWTAdapter.this.someChange();
            }
        });
        editor.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.character == '\u0001') {
                    editor.setSelection(0, editor.getText().length());
                }
                SWTAdapter.this.someChange();
            }
        });
        editor.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                SWTAdapter.this.someChange();
            }
        });
        editor.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SWTAdapter.this.someChange();
            }
        });
        editor.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent arg0) {
                SWTAdapter.this.someChange();
            }

            public void widgetSelected(SelectionEvent arg0) {
                SWTAdapter.this.someChange();
            }
        });
        editor.addMouseMoveListener(new MouseMoveListener(){

            public void mouseMove(MouseEvent e) {
                if (SWTAdapter.this.tooltipResolver == null) {
                    return;
                }
                try {
                    int pos = editor.getOffsetAtLocation(new Point(e.x - editor.getBorderWidth(), e.y));
                    editor.setToolTipText(SWTAdapter.this.tooltipResolver.getTooltip(pos));
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            }
        });
    }

    private static Color getColor(Integer rgb) {
        Color res = colorMap.get(rgb);
        if (res == null) {
            res = new Color((Device)Display.getDefault(), rgb >> 16 & 0xFF, rgb >> 8 & 0xFF, rgb & 0xFF);
            colorMap.put(rgb, res);
        }
        return res;
    }

    @Override
    public int getCaret() {
        return this.caret;
    }

    @Override
    public int getEndSelection() {
        return this.selection.y;
    }

    @Override
    public int getStartSelection() {
        return this.selection.x;
    }

    @Override
    public String getText() {
        return this.text;
    }

    private int innerGetCaret() {
        if (this.hasFocus) {
            return this.editor.getCaretOffset();
        }
        return -1;
    }

    private void someChange() {
        String event = null;
        if (!this.editor.getText().equals(this.text)) {
            event = this.text = this.editor.getText();
        }
        int newCaret = this.innerGetCaret();
        Point newSelection = this.editor.getSelection();
        if (event != null || this.caret != newCaret || !this.selection.equals((Object)newSelection)) {
            this.caret = newCaret;
            this.selection = newSelection;
            this.changeListeners.safeSend(event);
        }
    }

    @Override
    public void paint(StyleData data) {
        int length = this.text.length();
        ArrayList<StyleRange> styles = new ArrayList<StyleRange>(length);
        int i = 0;
        while (i < length) {
            StyleRange style = new StyleRange(0, 0, null, null, 0);
            style.background = SWTAdapter.getColor(data.background[i]);
            style.foreground = SWTAdapter.getColor(data.foreground[i]);
            style.fontStyle = (data.italic[i] ? 2 : 0) | (data.bold[i] ? 1 : 0);
            style.start = i;
            int k = i + 1;
            while (k < length && data.isEquals(i, k)) {
                ++k;
            }
            style.length = k - i;
            i = k;
            styles.add(style);
        }
        this.editor.setStyleRanges(styles.toArray(new StyleRange[styles.size()]));
    }

    @Override
    public IListenersList<String> getListenersList() {
        return this.changeListeners;
    }

    public static int colorToInt(Color c) {
        return c.getRed() << 16 | c.getGreen() << 8 | c.getBlue();
    }

    @Override
    public ITextStyle getSelectionStyle() {
        return new TextStyle(SWTAdapter.colorToInt(this.editor.getSelectionForeground()), SWTAdapter.colorToInt(this.editor.getSelectionBackground()), null, null);
    }

    @Override
    public void setText(String text) {
        this.editor.setText(text);
    }

    @Override
    public void setTooltipResolver(ITextEditorAdapter.TooltipResolver tooltipResolver) {
        this.tooltipResolver = tooltipResolver;
    }
}

