/*
 * Decompiled with CFR 0.152.
 */
package com.ess.regexutil.replacementparser;

import com.ess.regexutil.controls.RegexHighlighter;
import com.ess.regexutil.parsedtext.ITextItem;
import com.ess.regexutil.parsedtext.TextItem;
import com.ess.regexutil.regexparser.ErrorItem;
import com.ess.regexutil.replacementparser.EscapedSymbol;
import com.ess.regexutil.replacementparser.RepGroup;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReplacementParser {
    private static final ReplacementParser instance = new ReplacementParser();

    public static ReplacementParser getInstance() {
        return instance;
    }

    private ReplacementParser() {
    }

    public List<ITextItem> parse(RegexHighlighter highlighter, String replacement) {
        ArrayList<ITextItem> res = new ArrayList<ITextItem>();
        int groupCount = highlighter.getParsedRegex().getGroupCount();
        int i = 0;
        while (i < replacement.length()) {
            int k;
            TextItem item;
            char a = replacement.charAt(i);
            if (a == '\\') {
                item = i + 1 == replacement.length() ? new ErrorItem(i, 1, null) : new EscapedSymbol(i, replacement);
            } else if (a == '$') {
                k = i + 1;
                if (k == replacement.length() || replacement.charAt(k) < '0' || replacement.charAt(k) > '9') {
                    item = new ErrorItem(i, 1, null);
                } else {
                    int newRefNum;
                    int nextDigit;
                    int refNum = replacement.charAt(k) - 48;
                    ++k;
                    while (k < replacement.length() && (nextDigit = replacement.charAt(k) - 48) >= 0 && nextDigit <= 9 && groupCount >= (newRefNum = refNum * 10 + nextDigit)) {
                        refNum = newRefNum;
                        ++k;
                    }
                    item = groupCount <= refNum ? new ErrorItem(i, k - i, "There are no group #" + refNum) : new RepGroup(i, k - i, refNum);
                }
            } else {
                k = i + 1;
                while (k < replacement.length()) {
                    char c = replacement.charAt(k);
                    if (c == '\\' || c == '$') break;
                    ++k;
                }
                item = new TextItem(i, k - i);
            }
            res.add(item);
            i += item.getLength();
        }
        return res;
    }
}

