/*
 * Decompiled with CFR 0.152.
 */
package com.ess.regexutil.regexparser;

import com.ess.regexutil.parsedtext.ITextItem;
import com.ess.regexutil.parsedtext.TextItem;
import com.ess.regexutil.regexparser.AndInBracket;
import com.ess.regexutil.regexparser.BraceMulteplexors;
import com.ess.regexutil.regexparser.CharByCode;
import com.ess.regexutil.regexparser.CloseBracket;
import com.ess.regexutil.regexparser.CommentItem;
import com.ess.regexutil.regexparser.ControlCor;
import com.ess.regexutil.regexparser.Dote;
import com.ess.regexutil.regexparser.ErrorItem;
import com.ess.regexutil.regexparser.EscapeComment;
import com.ess.regexutil.regexparser.EscapeP;
import com.ess.regexutil.regexparser.EscapedChar;
import com.ess.regexutil.regexparser.GroupNumber;
import com.ess.regexutil.regexparser.IOneSymbol;
import com.ess.regexutil.regexparser.Interval;
import com.ess.regexutil.regexparser.ItemFactory;
import com.ess.regexutil.regexparser.ItemFactoryList;
import com.ess.regexutil.regexparser.LiteralItem;
import com.ess.regexutil.regexparser.Multeplexor;
import com.ess.regexutil.regexparser.OpenBracket;
import com.ess.regexutil.regexparser.OrSymbol;
import com.ess.regexutil.regexparser.SimpleGroupItem;
import com.ess.regexutil.regexparser.SimpleSymbol;
import com.ess.regexutil.regexparser.SpecEscape;
import com.ess.regexutil.regexparser.SpecSymbol;
import com.ess.regexutil.regexparser.SqrCloseBracket;
import com.ess.regexutil.regexparser.SqrOpenBracket;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class RegexParser {
    private static RegexParser instance = new RegexParser();
    private static final ItemFactoryList ESCAPED_ITEM_FACTORY_LIST = new ItemFactoryList(new ItemFactory[]{SimpleGroupItem.factory, SpecEscape.factory, CharByCode.factory, ControlCor.factory, EscapeP.factory, EscapeComment.factory, EscapedChar.factory});

    RegexParser() {
    }

    public static RegexParser getInstance() {
        return instance;
    }

    public List<TextItem> parse(String regex, int flags) {
        if (regex.indexOf(65535) != -1) {
            throw new IllegalArgumentException("Unsupported regex with symbol 0xFFFF");
        }
        ArrayList<TextItem> res = new ArrayList<TextItem>(regex.length());
        if ((flags & 0x10) != 0) {
            res.add(new LiteralItem(regex));
            return res;
        }
        RegexParserState st = new RegexParserState(String.valueOf(regex) + '\uffff', flags);
        int[] flagStack = new int[regex.length()];
        int top = 0;
        block13: while (true) {
            TextItem item;
            char a = st.get();
            switch (a) {
                case '\\': {
                    item = this.getEscapedItem(st);
                    break;
                }
                case '$': 
                case '^': {
                    item = new SpecSymbol(st);
                    break;
                }
                case '\uffff': {
                    break block13;
                }
                case '|': {
                    item = new OrSymbol(st);
                    break;
                }
                case '.': {
                    item = new Dote(st);
                    break;
                }
                case '*': 
                case '+': 
                case '?': {
                    item = new Multeplexor(st);
                    break;
                }
                case '{': {
                    item = BraceMulteplexors.factory.tryCreate(st);
                    break;
                }
                case '(': {
                    OpenBracket openBracket = new OpenBracket(st);
                    if (openBracket.getGroupNumber() != -1) {
                        RegexParserState regexParserState = st;
                        regexParserState.groupCount = regexParserState.groupCount + 1;
                    }
                    flagStack[top++] = st.flags;
                    st.flags = openBracket.changeFlags(st.flags);
                    if (openBracket.isFlagWithoutBracket()) {
                        flagStack[top - 1] = st.flags;
                    }
                    item = openBracket;
                    break;
                }
                case '[': {
                    item = null;
                    RegexParserState regexParserState = st;
                    regexParserState.flags = regexParserState.flags | 0x1000000;
                    this.parseBrackets(res, st);
                    RegexParserState regexParserState2 = st;
                    regexParserState2.flags = regexParserState2.flags & 0xFEFFFFFF;
                    break;
                }
                case ')': {
                    CloseBracket closeBracket = new CloseBracket(st);
                    if (top > 0) {
                        st.flags = flagStack[--top];
                    }
                    item = closeBracket;
                    break;
                }
                case '#': {
                    if ((st.flags & 4) != 0) {
                        item = new CommentItem(st);
                        break;
                    }
                }
                default: {
                    item = new SimpleSymbol(st);
                }
            }
            if (item == null) continue;
            RegexParserState regexParserState = st;
            regexParserState.index = regexParserState.index + item.getLength();
            res.add(item);
        }
        int resSize = res.size();
        int k = resSize - 1;
        while (--k >= 1) {
            TextItem item = (TextItem)res.get(k);
            item.setPred((ITextItem)res.get(k - 1));
            item.setNext((ITextItem)res.get(k + 1));
        }
        if (resSize > 1) {
            ((TextItem)res.get(0)).setNext((ITextItem)res.get(1));
            ((TextItem)res.get(resSize - 1)).setPred((ITextItem)res.get(resSize - 2));
        }
        k = 0;
        while (k < res.size()) {
            ((TextItem)res.get(k)).verify();
            ++k;
        }
        this.postTest(res, regex, flags);
        return res;
    }

    private void postTest(List<TextItem> res, String regex, int flags) {
        boolean hasRealError;
        try {
            Pattern.compile(regex, flags);
            hasRealError = false;
        }
        catch (RuntimeException runtimeException) {
            hasRealError = true;
        }
        boolean hasOurError = false;
        for (TextItem item : res) {
            if (!item.isError()) continue;
            hasOurError = true;
            break;
        }
        if (hasRealError != hasOurError) {
            System.err.println("Internal error: (ourError: " + hasOurError + " realError: " + hasRealError + ") regex: " + regex);
        }
    }

    private void parseBrackets(List res, RegexParserState st) {
        TextItem item;
        SqrOpenBracket openBracket = new SqrOpenBracket(st);
        RegexParserState regexParserState = st;
        regexParserState.index = regexParserState.index + openBracket.getLength();
        res.add(openBracket);
        if (st.get() == ']') {
            res.add(new SimpleSymbol(st));
            RegexParserState regexParserState2 = st;
            regexParserState2.index = regexParserState2.index + 1;
        }
        int state = 0;
        block13: do {
            char a = st.get();
            switch (a) {
                case '\\': {
                    item = this.getEscapedItem(st);
                    if (!(item instanceof GroupNumber) && !(item instanceof SpecEscape)) break;
                    item = new ErrorItem(st, item.getLength(), "This item may not be in \"[..]\"");
                    break;
                }
                case ']': {
                    item = new SqrCloseBracket(st);
                    break;
                }
                case '\uffff': {
                    break block13;
                }
                case '[': {
                    item = null;
                    this.parseBrackets(res, st);
                    break;
                }
                case '#': {
                    item = (st.flags & 4) != 0 ? new CommentItem(st) : new SimpleSymbol(st);
                    break;
                }
                case '&': {
                    item = st.get(1) == '&' ? new AndInBracket(st) : new SimpleSymbol(st);
                    break;
                }
                default: {
                    item = new SimpleSymbol(st);
                }
            }
            if (item == null) continue;
            switch (state) {
                case 0: {
                    if (!(item instanceof IOneSymbol)) break;
                    state = 1;
                    break;
                }
                case 1: {
                    if (!(item instanceof IOneSymbol)) {
                        state = 0;
                        break;
                    }
                    if (!(item instanceof SimpleSymbol) || ((SimpleSymbol)item).getSymbol() != '-') break;
                    state = 2;
                    break;
                }
                case 2: {
                    SimpleSymbol minus;
                    if (!(item instanceof IOneSymbol)) {
                        if (!(item instanceof EscapeComment) && !(item instanceof SqrCloseBracket)) {
                            minus = (SimpleSymbol)res.remove(res.size() - 1);
                            st.index = minus.getIndex();
                            res.add(new ErrorItem(st, 1, null));
                            RegexParserState regexParserState3 = st;
                            regexParserState3.index = regexParserState3.index + 1;
                        }
                    } else {
                        minus = (SimpleSymbol)res.remove(res.size() - 1);
                        IOneSymbol firstItem = (IOneSymbol)res.remove(res.size() - 1);
                        IOneSymbol secondItem = (IOneSymbol)((Object)item);
                        st.index = firstItem.getIndex();
                        item = firstItem.getSymbol() > secondItem.getSymbol() ? new ErrorItem(st, minus.getLength() + firstItem.getLength() + secondItem.getLength(), null) : new Interval(st, firstItem, minus, secondItem);
                        st.index = item.getIndex();
                    }
                    state = 0;
                }
            }
            RegexParserState regexParserState4 = st;
            regexParserState4.index = regexParserState4.index + item.getLength();
            res.add(item);
        } while (!(item instanceof SqrCloseBracket));
    }

    private TextItem getEscapedItem(RegexParserState st) {
        char a = st.get(1);
        if (a == '\uffff') {
            return new ErrorItem(st, 1, "Illegal/unsupported escape sequence");
        }
        if (a >= '1' && a <= '9') {
            int group = a - 48;
            if (st.groupCount < group) {
                return new ErrorItem(st, 2, "There are not group #" + a);
            }
            int k = st.getIndex() + 1;
            while ((a = st.getText().charAt(++k)) >= '0' && a <= '9') {
                int newGroup = group * 10 + a - 48;
                if (st.groupCount - 1 < newGroup) break;
                group = newGroup;
            }
            return new GroupNumber(st, k - st.index, group);
        }
        TextItem res = ESCAPED_ITEM_FACTORY_LIST.create(st);
        if (res != null) {
            return res;
        }
        return new ErrorItem(st, 2, "Illegal/unsupported escape sequence: \\" + a);
    }

    public class RegexParserState {
        private final String text;
        private int flags;
        private int index;
        private int groupCount;

        private RegexParserState(String text, int flags) {
            this.text = text;
            this.flags = flags;
            this.groupCount = 1;
        }

        public char get(int i) {
            return this.text.charAt(this.index + i);
        }

        public char get() {
            return this.text.charAt(this.index);
        }

        public int getFlags() {
            return this.flags;
        }

        public int getIndex() {
            return this.index;
        }

        public String getText() {
            return this.text;
        }

        public int getGroupCount() {
            return this.groupCount;
        }
    }
}

