/*
 * Decompiled with CFR 0.152.
 */
package com.ess.regexutil.regexparser;

import com.ess.regexutil.parsedtext.ITextItem;
import com.ess.regexutil.parsedtext.ParsedText;
import com.ess.regexutil.parsedtext.TextItem;
import com.ess.regexutil.regexparser.OpenBracket;
import com.ess.regexutil.regexparser.RegexParser;
import java.util.List;
import java.util.regex.Pattern;

public class ParsedRegex
extends ParsedText {
    private final String regex;
    private final int flags;
    private int groupCount = 1;
    private Pattern pattern;

    public ParsedRegex(String regex, int flags) {
        List<TextItem> list = RegexParser.getInstance().parse(regex, flags);
        this.setList(list);
        if (!this.isError) {
            try {
                Pattern.compile(regex, flags);
            }
            catch (Throwable throwable) {
                this.isError = true;
            }
        }
        if (!this.isError) {
            int i = list.size();
            while (--i >= 0) {
                int groupCount;
                ITextItem item = list.get(i);
                if (!(item instanceof OpenBracket) || (groupCount = ((OpenBracket)item).getGroupNumber()) == -1) continue;
                this.groupCount = groupCount + 1;
                break;
            }
        } else {
            this.groupCount = 0;
        }
        this.regex = regex;
        this.flags = flags;
    }

    public int getGroupCount() {
        return this.groupCount;
    }

    public Pattern getPattern() {
        if (this.isError) {
            return null;
        }
        if (this.pattern == null) {
            this.pattern = Pattern.compile(this.regex, this.flags);
        }
        return this.pattern;
    }

    public int getFlags() {
        return this.flags;
    }

    public String getRegex() {
        return this.regex;
    }
}

