/*
 * Decompiled with CFR 0.152.
 */
package com.ess.regexutil.regexparser;

import com.ess.regexutil.parsedtext.ITextItem;
import com.ess.regexutil.parsedtext.StyleData;
import com.ess.regexutil.regexparser.CloseBracket;
import com.ess.regexutil.regexparser.OpenBracket;
import com.ess.regexutil.regexparser.RegexItem;
import com.ess.regexutil.regexparser.RegexParser;

public class OrSymbol
extends RegexItem {
    private int rightPoint;
    private int leftPoint;
    private final String s;

    public OrSymbol(RegexParser.RegexParserState st) {
        super(st, 1);
        this.s = st.getText();
        this.hint = "U|V - Alternation: U or V\n\nFirst tries to match subexpression U. Falls back and tries to match V if U didn't match.\n\nExamples:\n- The expression \"A|B\" applied to text \"BA\" first matches \"B\", then \"A\".\n- The expression \"AB|BC|CD\" applied to text \"ABC BC DAB\" matches, in sequence:\n  \"AB\" in the first word, the second word \"BC\", \"AB\" at the very end.";
        this.style = rc.getComma();
    }

    protected void highlightChild(StyleData sd) {
        rc.getChildElement().apply(sd, this.leftPoint, this.getIndex());
        rc.getChildElement().apply(sd, this.getEnd(), this.rightPoint);
    }

    public void verify() {
        int rang = 0;
        ITextItem item = this.getPred();
        while (item != null) {
            if (item instanceof OpenBracket && --rang < 0) {
                this.leftPoint = item.getEnd();
                break;
            }
            if (item instanceof CloseBracket) {
                ++rang;
            }
            item = item.getPred();
        }
        rang = 0;
        item = this.getNext();
        while (item != null) {
            if (item instanceof CloseBracket && --rang < 0) {
                this.rightPoint = item.getIndex();
                break;
            }
            if (item instanceof OpenBracket) {
                ++rang;
            }
            this.rightPoint = item.getEnd();
            item = item.getNext();
        }
        if (this.rightPoint == 0) {
            this.rightPoint = this.s.length();
        }
    }

    public boolean canAddGroup(int start, int end) {
        return end <= this.leftPoint || start >= this.rightPoint || start >= this.leftPoint && end <= this.getIndex() || start <= this.leftPoint && end >= this.rightPoint || start >= this.leftPoint && end >= this.getIndex() || start >= this.getEnd() && end <= this.rightPoint;
    }
}

