/*
 * Decompiled with CFR 0.152.
 */
package com.ess.regexutil.regexparser;

import com.ess.regexutil.regexparser.Bracket;
import com.ess.regexutil.regexparser.Messages;
import com.ess.regexutil.regexparser.RegexParser;
import com.ess.util.Helper;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class OpenBracket
extends Bracket {
    private static final Pattern PATTERN = Pattern.compile("\\G(?:[=!>]|<[=!]|([imsducx]*)(?:-([imsducx]*))?(:|\\)))");
    private static final Map<Character, Integer> FLAGS_CODE = Helper.createSimpleMap(new Object[]{Character.valueOf('d'), 1, Character.valueOf('i'), 2, Character.valueOf('x'), 4, Character.valueOf('m'), 8, Character.valueOf('s'), 32, Character.valueOf('u'), 64, Character.valueOf('c'), 0});
    private int addFlags;
    private int removeFlags;
    private int groupNumber;
    private boolean flagWithoutBracket;

    public OpenBracket(RegexParser.RegexParserState st) {
        super(st, 1, '(', true);
        if (st.get(1) == '?') {
            Matcher m = PATTERN.matcher(st.getText());
            if (m.find(st.getIndex() + 2)) {
                int length = m.group().length() + 2;
                this.addFlags = this.convertFlags(m.group(1));
                this.removeFlags = this.convertFlags(m.group(2));
                if (")".equals(m.group(3))) {
                    --length;
                    this.flagWithoutBracket = true;
                }
                this.length = length;
            }
            this.groupNumber = -1;
        } else {
            this.groupNumber = st.getGroupCount();
        }
    }

    protected void setOtherBracket(Bracket otherBracket) {
        super.setOtherBracket(otherBracket);
        this.hint = this.groupNumber == -1 ? (this.flagWithoutBracket ? Messages.get("OpenBracket.OpenBracket_FlagModification") : Messages.get("OpenBracket.OpenBracket.Non_capturing_group")) : String.valueOf(Messages.get("OpenBracket.OpenBracket.capturing_group_n")) + this.groupNumber;
    }

    public boolean isFlagWithoutBracket() {
        return this.flagWithoutBracket;
    }

    public int getGroupNumber() {
        return this.groupNumber;
    }

    private int convertFlags(String s) {
        int res = 0;
        if (s != null) {
            int i = s.length();
            while (--i >= 0) {
                res |= FLAGS_CODE.get(Character.valueOf(s.charAt(i))).intValue();
            }
        }
        return res;
    }

    public int changeFlags(int flags) {
        return (flags | this.addFlags) & ~this.removeFlags;
    }
}

