/*
 * Decompiled with CFR 0.152.
 */
package com.ess.regexutil.regexparser;

import com.ess.regexutil.parsedtext.ITextItem;
import com.ess.regexutil.parsedtext.StyleData;
import com.ess.regexutil.regexparser.BraceMulteplexors;
import com.ess.regexutil.regexparser.Bracket;
import com.ess.regexutil.regexparser.CharByCode;
import com.ess.regexutil.regexparser.CloseBracket;
import com.ess.regexutil.regexparser.ControlCor;
import com.ess.regexutil.regexparser.Dote;
import com.ess.regexutil.regexparser.ErrorItem;
import com.ess.regexutil.regexparser.EscapeComment;
import com.ess.regexutil.regexparser.EscapeP;
import com.ess.regexutil.regexparser.EscapedChar;
import com.ess.regexutil.regexparser.GroupNumber;
import com.ess.regexutil.regexparser.LiteralItem;
import com.ess.regexutil.regexparser.OpenBracket;
import com.ess.regexutil.regexparser.OrSymbol;
import com.ess.regexutil.regexparser.RegexItem;
import com.ess.regexutil.regexparser.RegexParser;
import com.ess.regexutil.regexparser.SimpleGroupItem;
import com.ess.regexutil.regexparser.SimpleSymbol;
import com.ess.regexutil.regexparser.SpecEscape;
import com.ess.regexutil.regexparser.SpecSymbol;
import com.ess.regexutil.regexparser.SqrCloseBracket;
import com.ess.util.Helper;
import java.util.Map;

public class Multeplexor
extends RegexItem {
    private final char additionSymbol;
    private final char symbol;
    private int hilightStart;
    private static final String[] HINT_MAP = new String[]{"? - Greedy match 0 or 1 times", "* - Greedy match 0 or more times", "+ - Greedy match 1 or more times", "?? - Lazy match 0 or 1 times", "*? - Lazy match 0 or more times", "+? - Lazy match 1 or more times", "?+ - Possessive match 0 or 1 times (no backtracking)", "*+ Possessive match 0 or more times (no backtracking)", "++ - Possessive match 1 or more times (no backtracking)"};
    public static final Map<Class<ITextItem>, Boolean> canBeAfterMap = Helper.createUnmMap(new Object[]{BraceMulteplexors.class, Boolean.FALSE, CharByCode.class, Boolean.TRUE, ControlCor.class, Boolean.TRUE, Dote.class, Boolean.TRUE, ErrorItem.class, Boolean.TRUE, EscapeComment.class, Boolean.TRUE, LiteralItem.class, Boolean.TRUE, EscapedChar.class, Boolean.TRUE, EscapeP.class, Boolean.TRUE, GroupNumber.class, Boolean.TRUE, Multeplexor.class, Boolean.FALSE, OpenBracket.class, Boolean.FALSE, OrSymbol.class, Boolean.FALSE, SimpleGroupItem.class, Boolean.TRUE, SimpleSymbol.class, Boolean.TRUE, SpecEscape.class, Boolean.FALSE, SpecSymbol.class, Boolean.FALSE, SqrCloseBracket.class, Boolean.TRUE});

    public Multeplexor(RegexParser.RegexParserState st) {
        super(st, 1);
        this.symbol = st.get();
        char a = st.get(1);
        if (a == '+' || a == '?') {
            this.additionSymbol = a;
            this.length = 2;
        } else {
            this.additionSymbol = '\u0000';
        }
        this.style = rc.getComma();
    }

    public static int getPrevIndex(ITextItem pred) {
        if (pred instanceof Bracket) {
            Bracket other = ((Bracket)pred).getOtherBracket();
            return other == null ? pred.getIndex() : other.getIndex();
        }
        return pred.getIndex();
    }

    public void verify() {
        if (Multeplexor.testByApplicable(this.getPred())) {
            this.hilightStart = Multeplexor.getPrevIndex(this.getPred());
            this.hint = HINT_MAP[(this.additionSymbol == '\u0000' ? 0 : (this.additionSymbol == '?' ? 1 : 2)) * 3 + this.symbol == 63 ? 0 : (this.symbol == '*' ? 1 : 2)];
        } else {
            this.isError = true;
        }
    }

    protected void highlightChild(StyleData sd) {
        rc.getChildElement().apply(sd, this.hilightStart, this.getIndex());
    }

    public boolean canAddGroup(int start, int end) {
        return end <= this.hilightStart || start >= this.getEnd() || start >= this.hilightStart && end <= this.getIndex() || start <= this.hilightStart && end >= this.getEnd();
    }

    public static boolean testByApplicable(ITextItem pred) {
        if (pred == null) {
            return false;
        }
        if (pred instanceof CloseBracket) {
            OpenBracket openBracket = (OpenBracket)((CloseBracket)pred).getOtherBracket();
            return openBracket == null || !openBracket.isFlagWithoutBracket();
        }
        return canBeAfterMap.get(pred.getClass());
    }
}

