/*
 * Decompiled with CFR 0.152.
 */
package com.ess.regexutil.regexparser;

import com.ess.regexutil.parsedtext.ITextItem;
import com.ess.regexutil.parsedtext.StyleData;
import com.ess.regexutil.regexparser.OpenBracket;
import com.ess.regexutil.regexparser.RegexItem;
import com.ess.regexutil.regexparser.RegexParser;

public class GroupNumber
extends RegexItem {
    private int groupNumber;
    private OpenBracket bracket;

    public GroupNumber(RegexParser.RegexParserState st, int length, int groupNumber) {
        super(st, length);
        this.groupNumber = groupNumber;
    }

    protected void highlightChild(StyleData sd) {
        if (this.bracket != null) {
            rc.getChildElement().apply(sd, this.bracket.getIndex(), this.bracket.getOtherBracket().getEnd());
        }
    }

    public void verify() {
        ITextItem item = this.getPred();
        while (item != null) {
            OpenBracket bracket;
            if (item instanceof OpenBracket && (bracket = (OpenBracket)item).getGroupNumber() != -1 && !bracket.isError() && bracket.getGroupNumber() == this.groupNumber) {
                this.bracket = bracket;
                this.hint = "\\i - Match of the capturing group i";
                this.style = rc.getNumber();
                return;
            }
            item = item.getPred();
        }
        this.hint = "There are no group #" + this.groupNumber;
        this.style = rc.getNotUsage();
    }

    public int getGroupNumber() {
        return this.groupNumber;
    }
}

