/*
 * Decompiled with CFR 0.152.
 */
package com.ess.regexutil.regexparser;

import com.ess.regexutil.regexparser.IOneSymbol;
import com.ess.regexutil.regexparser.ItemFactory;
import com.ess.regexutil.regexparser.RegexItem;
import com.ess.regexutil.regexparser.RegexParser;
import com.ess.regexutil.regexparser.SimpleSymbol;

public class EscapedChar
extends RegexItem
implements IOneSymbol {
    private final char symbol;
    private static final String needEscape = "\\.*?+|^$(){[";
    private static final String needEscapeBrack = "\\[]$^-";
    private final boolean notNeed;
    public static final ItemFactory factory = new ItemFactory(){

        public RegexItem tryCreate(RegexParser.RegexParserState st) {
            char a = st.get(1);
            if (a == '0' || a >= 'a' && a <= 'z' || a >= 'A' && a <= 'Z') {
                return null;
            }
            return new EscapedChar(st);
        }
    };

    public EscapedChar(RegexParser.RegexParserState st) {
        super(st, 2);
        this.symbol = st.get(1);
        String s = (st.getFlags() & 0x1000000) == 0 ? needEscape : needEscapeBrack;
        boolean bl = this.notNeed = s.indexOf(this.symbol) == -1;
        if (this.notNeed) {
            this.hint = String.valueOf(SimpleSymbol.getHint(this.symbol)) + " (escaping is not necessarily)";
            this.style = rc.getNotUsage();
        } else {
            this.hint = SimpleSymbol.getHint(this.symbol);
        }
    }

    public char getSymbol() {
        return this.symbol;
    }
}

