/*
 * Decompiled with CFR 0.152.
 */
package com.ess.regexutil.regexparser;

import com.ess.regexutil.parsedtext.StyleData;
import com.ess.regexutil.regexparser.ItemFactory;
import com.ess.regexutil.regexparser.RegexItem;
import com.ess.regexutil.regexparser.RegexParser;

public class EscapeComment
extends RegexItem {
    private final boolean endToE;
    public static final ItemFactory factory = new ItemFactory(){

        public RegexItem tryCreate(RegexParser.RegexParserState st) {
            if (st.get(1) != 'Q') {
                return null;
            }
            int end = st.getText().indexOf("\\E", st.getIndex() + 2);
            if (end == -1) {
                return new EscapeComment(st, st.getText().length() - st.getIndex() - 1, false);
            }
            return new EscapeComment(st, end + 2 - st.getIndex(), true);
        }
    };

    public EscapeComment(RegexParser.RegexParserState st, int length, boolean endToE) {
        super(st, length);
        this.endToE = endToE;
        this.hint = "All characters between \\Q and the next \\E are taken literally and are not interpreted.\n\nExample:\nThe expression \"\\Qnew int[] {42}\\E;\" matches text \"new int[] {42}\".";
    }

    protected void highlightInternal(StyleData sd, int caret) {
        rc.getComma().apply(sd, this.getIndex(), this.getIndex() + 2);
        this.getEnd();
        if (this.endToE) {
            int end = this.getEnd();
            rc.getComma().apply(sd, end - 2, end);
        }
        this.paint(sd, rc.getEscapeComment());
    }
}

