/*
 * Decompiled with CFR 0.152.
 */
package com.ess.regexutil.regexparser;

import com.ess.regexutil.regexparser.IOneSymbol;
import com.ess.regexutil.regexparser.ItemFactory;
import com.ess.regexutil.regexparser.RegexItem;
import com.ess.regexutil.regexparser.RegexParser;
import com.ess.util.Helper;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CharByCode
extends RegexItem
implements IOneSymbol {
    private static final Pattern charByCodePattern = Pattern.compile("(0[0-3]?[0-7]{1,2})|(?:x([\\p{XDigit}]{2}))|(?:u([\\p{XDigit}]{4}))|([aefnrtv])");
    private static final Map<Character, String> hintMap = Helper.createSimpleMap(new Object[]{Character.valueOf('\t'), "The tab character '\\t' ('\\u0009')", Character.valueOf('\n'), "The newline (line feed) character '\\n' ('\\u000A')", Character.valueOf('\r'), "The carriage-return character '\\r' ('\\u000D')", Character.valueOf('\f'), "The form-feed character '\\f' ('\\u000C')", Character.valueOf('\u0007'), "The alert (bell) character '\\a' ('\\u0007')", Character.valueOf('\u001b'), "The escape character '\\e' ('\\u001B')", Character.valueOf(' '), "The space ' ' ('\\u0020')"});
    private static final Map<Character, Character> map = Helper.createSimpleMap(new Object[]{Character.valueOf('a'), Character.valueOf('\u0007'), Character.valueOf('e'), Character.valueOf('\u001b'), Character.valueOf('f'), Character.valueOf('\f'), Character.valueOf('n'), Character.valueOf('\n'), Character.valueOf('r'), Character.valueOf('\r'), Character.valueOf('t'), Character.valueOf('\t'), Character.valueOf('v'), Character.valueOf('\u000b')});
    private final char symbol;
    public static final ItemFactory factory = new ItemFactory(){

        public RegexItem tryCreate(RegexParser.RegexParserState st) {
            Matcher m = charByCodePattern.matcher(st.getText());
            if (m.find(st.getIndex() + 1) && m.start() == st.getIndex() + 1) {
                return new CharByCode(st, m, null);
            }
            return null;
        }
    };

    private CharByCode(RegexParser.RegexParserState st, Matcher m) {
        super(st, 0);
        if (m.group(1) != null) {
            this.symbol = (char)Integer.parseInt(m.group(1), 8);
        } else if (m.group(2) != null) {
            this.symbol = (char)Integer.parseInt(m.group(2), 16);
        } else if (m.group(3) != null) {
            this.symbol = (char)Integer.parseInt(m.group(3), 16);
        } else if (m.group(4) != null) {
            this.symbol = map.get(Character.valueOf(m.group(4).charAt(0))).charValue();
        } else {
            throw new InternalError();
        }
        this.length = m.group().length() + 1;
        this.hint = hintMap.get(Character.valueOf(this.symbol));
        if (this.hint == null) {
            this.hint = !Character.isISOControl(this.symbol) ? "The symbol '" + this.symbol + "' (\\u" + Helper.getCharHexCode(this.symbol) + ')' : "The symbol '\\u" + Helper.getCharHexCode(this.symbol) + '\'';
        }
        this.style = rc.getSymbolGroup();
    }

    public char getSymbol() {
        return this.symbol;
    }

    /* synthetic */ CharByCode(RegexParser.RegexParserState regexParserState, Matcher matcher, CharByCode charByCode) {
        this(regexParserState, matcher);
    }
}

