/*
 * Decompiled with CFR 0.152.
 */
package com.ess.regexutil.regexparser;

import com.ess.regexutil.parsedtext.ITextItem;
import com.ess.regexutil.parsedtext.StyleData;
import com.ess.regexutil.regexparser.Messages;
import com.ess.regexutil.regexparser.RegexItem;
import com.ess.regexutil.regexparser.RegexParser;

public abstract class Bracket
extends RegexItem {
    protected Bracket otherBracket;
    protected final char type;
    protected final boolean isOpen;

    protected Bracket(RegexParser.RegexParserState st, int length, char type, boolean isOpen) {
        super(st, length);
        this.type = type;
        this.isOpen = isOpen;
        this.isError = true;
        this.hint = this.getErrorHint();
    }

    public String getErrorHint() {
        return Messages.get("Bracket.PairedBracketNotFound");
    }

    protected void highlightInternal(StyleData sd, int caret) {
        this.paint(sd, rc.getComma());
        if (this.otherBracket != null && this.hasCaret(caret)) {
            this.paint(sd, rc.getCurrentBracket());
            this.otherBracket.paint(sd, rc.getCurrentBracket());
        }
    }

    public boolean isOpen() {
        return this.isOpen;
    }

    public char getType() {
        return this.type;
    }

    public Bracket getOtherBracket() {
        return this.otherBracket;
    }

    protected void setOtherBracket(Bracket otherBracket) {
        this.otherBracket = otherBracket;
        this.isError = false;
        this.hint = null;
    }

    public boolean canAddGroup(int start, int end) {
        return !this.isOpen() || end <= this.getIndex() || start >= this.otherBracket.getEnd() || start >= this.getEnd() && end <= this.otherBracket.getIndex() || start <= this.getIndex() && end >= this.otherBracket.getEnd();
    }

    public void verify() {
        if (this.isOpen()) {
            return;
        }
        ITextItem item = this.getPred();
        while (item != null) {
            if (item instanceof Bracket) {
                Bracket br = (Bracket)item;
                if (br.isOpen()) {
                    if (br.getType() == this.getType() && br.getOtherBracket() == null) {
                        this.setOtherBracket(br);
                        br.setOtherBracket(this);
                    }
                    return;
                }
                if (br.isError()) {
                    return;
                }
                item = br.getOtherBracket();
            }
            item = item.getPred();
        }
    }
}

