/*
 * Decompiled with CFR 0.152.
 */
package com.ess.regexutil.regexparser;

import com.ess.regexutil.parsedtext.ITextStyle;
import com.ess.regexutil.parsedtext.StyleData;
import com.ess.regexutil.parsedtext.TextItem;
import com.ess.regexutil.regexparser.ErrorItem;
import com.ess.regexutil.regexparser.ItemFactory;
import com.ess.regexutil.regexparser.Messages;
import com.ess.regexutil.regexparser.Multeplexor;
import com.ess.regexutil.regexparser.RegexItem;
import com.ess.regexutil.regexparser.RegexParser;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class BraceMulteplexors
extends RegexItem {
    private static final Pattern inBraces = Pattern.compile("\\G(?:(?:(\\d+)(,(\\d*)?)?)|([^{}()\\[\\]#}]*))\\}([\\+\\?])?");
    private static final String[] HINT_MAP = new String[]{Messages.get("BraceMulteplexors.1"), Messages.get("BraceMulteplexors.2"), Messages.get("BraceMulteplexors.3"), Messages.get("BraceMulteplexors.4"), Messages.get("BraceMulteplexors.5"), Messages.get("BraceMulteplexors.6"), Messages.get("BraceMulteplexors.7"), Messages.get("BraceMulteplexors.8"), Messages.get("BraceMulteplexors.9")};
    public static final ItemFactory factory = new ItemFactory(){

        public TextItem tryCreate(RegexParser.RegexParserState st) {
            int i;
            Matcher m = inBraces.matcher(st.getText());
            if (!m.find((i = st.getIndex()) + 1)) {
                return new ErrorItem(i, 1, Messages.get("BraceMulteplexors.10"));
            }
            int length = 1 + m.group().length();
            if (m.group(4) != null) {
                return new ErrorItem(i, length, Messages.getF("BraceMulteplexors.Is_not_legal_argument", m.group(4)));
            }
            String sFrom = m.group(1);
            String sTo = m.group(3);
            if (sTo != null && sTo.length() > 0 && BraceMulteplexors.compare(sFrom, sTo) > 0) {
                return new ErrorItem(i, length, Messages.getF("BraceMulteplexors.first_big", sFrom, sTo));
            }
            return new BraceMulteplexors(st, length, sTo == null ? TYPE.EQUALS : (sTo.length() == 0 ? TYPE.FROM : TYPE.FROM_TO), sFrom, sTo, m.group(5) == null ? (char)'\u0000' : m.group(5).charAt(0));
        }
    };
    private final TYPE type;
    private final String s1;
    private final String s2;
    private final char additionSymbol;
    private int hilightStart;

    private static int compare(String s1, String s2) {
        if (s1.length() == s2.length()) {
            return s1.compareTo(s2);
        }
        return s1.length() - s2.length();
    }

    public BraceMulteplexors(RegexParser.RegexParserState st, int length, TYPE type, String s1, String s2, char additionSymbol) {
        super(st, length);
        this.type = type;
        this.s1 = s1;
        this.s2 = s2;
        this.additionSymbol = additionSymbol;
        this.hint = HINT_MAP[(additionSymbol == '\u0000' ? 0 : (additionSymbol == '?' ? 1 : 2)) * 3 + (type == TYPE.EQUALS ? 0 : (type == TYPE.FROM ? 1 : 2))];
    }

    protected void highlightChild(StyleData sd) {
        rc.getChildElement().apply(sd, this.hilightStart, this.getIndex());
    }

    protected void highlightInternal(StyleData sd, int caret) {
        int i = this.getIndex();
        ITextStyle c = rc.getComma();
        c.apply(sd, i, i + 1);
        rc.getNumber().apply(sd, ++i, i + this.s1.length());
        i += this.s1.length();
        if (this.type != TYPE.EQUALS) {
            c.apply(sd, i, i + 1);
            ++i;
            if (this.type == TYPE.FROM_TO) {
                rc.getNumber().apply(sd, i, i + this.s2.length());
                i += this.s2.length();
            }
        }
        c.apply(sd, i, i + 1);
        if (this.additionSymbol != '\u0000') {
            c.apply(sd, i, i + 1);
            ++i;
        }
    }

    public boolean canAddGroup(int start, int end) {
        return end <= this.hilightStart || start >= this.getEnd() || start >= this.hilightStart && end <= this.getIndex() || start <= this.hilightStart && end >= this.getEnd();
    }

    public void verify() {
        this.hilightStart = Multeplexor.testByApplicable(this.getPred()) ? Multeplexor.getPrevIndex(this.getPred()) : this.getIndex();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum TYPE {
        EQUALS,
        FROM,
        FROM_TO;

    }
}

