/*
 * Decompiled with CFR 0.152.
 */
package com.ess.regexutil.parsedtext;

import com.ess.regexutil.parsedtext.ITextStyle;
import com.ess.regexutil.parsedtext.StyleData;
import java.util.Arrays;

public class TextStyle
implements ITextStyle {
    public static final ITextStyle EMPTY_STYLE = new TextStyle();
    public static final ITextStyle BOLD_STYLE = new TextStyle(null, null, Boolean.TRUE, null);
    public static final ITextStyle ITALIC_STYLE = new TextStyle(null, null, null, Boolean.TRUE);
    private Integer foreground;
    private Integer background;
    private Boolean bold;
    private Boolean italic;

    public TextStyle() {
    }

    public TextStyle(Integer foreground, Integer background, Boolean bold, Boolean italic) {
        this.foreground = foreground;
        this.background = background;
        this.bold = bold;
        this.italic = italic;
    }

    public Integer getBackground() {
        return this.background;
    }

    public void setBackground(Integer background) {
        this.background = background;
    }

    public Boolean getBold() {
        return this.bold;
    }

    public void setBold(Boolean bold) {
        this.bold = bold;
    }

    public Integer getForeground() {
        return this.foreground;
    }

    public void setForeground(Integer foreground) {
        this.foreground = foreground;
    }

    public Boolean getItalic() {
        return this.italic;
    }

    public void setItalic(Boolean italic) {
        this.italic = italic;
    }

    public void apply(StyleData sd, int start, int end) {
        if (this.bold != null) {
            Arrays.fill(sd.bold, start, end, this.bold);
        }
        if (this.italic != null) {
            Arrays.fill(sd.italic, start, end, this.italic);
        }
        if (this.foreground != null) {
            Arrays.fill(sd.foreground, start, end, this.foreground);
        }
        if (this.background != null) {
            Arrays.fill(sd.background, start, end, this.background);
        }
    }

    public static ITextStyle foregroundStyle(int color) {
        return new TextStyle(color, null, null, null);
    }

    public static ITextStyle backgroundStyle(int color) {
        return new TextStyle(null, color, null, null);
    }

    public static ITextStyle boldStyle(int color) {
        return new TextStyle(null, color, null, null);
    }
}

