/*
 * Decompiled with CFR 0.152.
 */
package com.ess.regexutil.parsedtext;

import java.util.Arrays;

public class StyleData {
    public final boolean[] italic;
    public final boolean[] bold;
    public final int[] foreground;
    public final int[] background;

    public StyleData(int length) {
        this.italic = new boolean[length];
        this.bold = new boolean[length];
        this.foreground = new int[length];
        this.background = new int[length];
    }

    public StyleData getInstance(int length) {
        if (length > this.italic.length) {
            return new StyleData(length * 3 / 2);
        }
        return this;
    }

    private int getLength() {
        return this.italic.length;
    }

    public boolean isEquals(int i1, int i2) {
        return this.foreground[i1] == this.foreground[i2] && this.background[i1] == this.background[i2] && this.bold[i1] == this.bold[i2] && this.italic[i1] == this.italic[i2];
    }

    public void clear(int defaultBackground, int defaultForeground) {
        this.clear(this.getLength(), defaultBackground, defaultForeground);
    }

    public void clear(int length, int defaultBackground, int defaultForeground) {
        Arrays.fill(this.italic, 0, length, false);
        Arrays.fill(this.bold, 0, length, false);
        Arrays.fill(this.foreground, 0, length, defaultForeground);
        Arrays.fill(this.background, 0, length, defaultBackground);
    }

    public boolean isEquals(StyleData sd, int start, int end) {
        int i = start;
        while (i < end) {
            if (sd.foreground[i] != this.foreground[i] || sd.background[i] != this.background[i] || sd.bold[i] != this.bold[i] || sd.italic[i] != this.italic[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

