/*
 * Decompiled with CFR 0.152.
 */
package com.ess.regexutil.parsedtext;

import com.ess.regexutil.parsedtext.ITextItem;
import com.ess.regexutil.parsedtext.StyleData;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParsedText {
    private List<ITextItem> list;
    private List<ITextItem> unmList;
    protected boolean isError;

    protected void setList(List list) {
        this.list = list;
        this.unmList = Collections.unmodifiableList(list);
        this.isError = false;
        int i = 0;
        while (i < list.size()) {
            if (((ITextItem)list.get(i)).isError()) {
                this.isError = true;
                break;
            }
            ++i;
        }
    }

    public boolean isError() {
        return this.isError;
    }

    public void paint(StyleData sd, int caret) {
        for (ITextItem item : this.list) {
            item.highlight(sd, caret);
        }
    }

    public ITextItem getItemAtCaretLocation(int caret) {
        for (ITextItem item : this.list) {
            if (!item.hasCaret(caret)) continue;
            return item;
        }
        return null;
    }

    public ITextItem getItem(int index) {
        if (index == -1) {
            return null;
        }
        for (ITextItem item : this.list) {
            if (index < item.getLength()) {
                return item;
            }
            index -= item.getLength();
        }
        return null;
    }

    public List<ITextItem> getList() {
        return this.unmList;
    }

    public boolean canAddGroup(int start, int end) {
        for (ITextItem item : this.list) {
            if (item.canAddGroup(start, end)) continue;
            return false;
        }
        return true;
    }
}

