/*
 * Decompiled with CFR 0.152.
 */
package com.ess.regexutil.escaping;

import com.ess.regexutil.escaping.RegexTransfer;
import com.ess.util.Helper;
import java.util.Map;

public class XmlRegexTransfer
implements RegexTransfer {
    public static final XmlRegexTransfer instance = new XmlRegexTransfer();
    private Map<Character, String> replace = Helper.createSimpleMap(new Object[]{Character.valueOf('&'), "amp;", Character.valueOf('<'), "lt;", Character.valueOf('>'), "gt;", Character.valueOf('\''), "apos;", Character.valueOf('\"'), "quot;"});

    private XmlRegexTransfer() {
    }

    public String regexToSource(String regex) {
        StringBuilder res = new StringBuilder();
        int i = 0;
        while (i < regex.length()) {
            char a = regex.charAt(i);
            String s = this.replace.get(Character.valueOf(a));
            if (s != null) {
                res.append('&').append(s);
            } else {
                res.append(a);
            }
            ++i;
        }
        return res.length() == regex.length() ? regex : res.toString();
    }

    public String sourceToRegex(String source) {
        StringBuilder res = new StringBuilder(source.length());
        int i = 0;
        while (i < source.length()) {
            char a = source.charAt(i);
            if (a == '&') {
                for (Map.Entry<Character, String> e : this.replace.entrySet()) {
                    if (!source.startsWith(e.getValue(), i + 1)) continue;
                    res.append(e.getKey());
                    i += e.getValue().length();
                    a = '\u0000';
                    break;
                }
                if (a != '\u0000') {
                    res.append(a);
                }
            } else {
                res.append(a);
            }
            ++i;
        }
        return res.length() == source.length() ? source : res.toString();
    }
}

