/*
 * Decompiled with CFR 0.152.
 */
package com.ess.regexutil.escaping;

import com.ess.regexutil.escaping.RegexTransfer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JavaRegexTransfer
implements RegexTransfer {
    public static final JavaRegexTransfer instance = new JavaRegexTransfer();
    private final String STRING_LITERAL_REGEX = "([^\n\r\"\\\\])|\\\\(?:([btnfr\"'\\\\])|([0-3]?[0-7]{1,2})|u(\\p{XDigit}{4}))";
    private final Pattern CHAR_IN_STRING = Pattern.compile("([^\n\r\"\\\\])|\\\\(?:([btnfr\"'\\\\])|([0-3]?[0-7]{1,2})|u(\\p{XDigit}{4}))|.");
    private final Pattern STRING = Pattern.compile("\\s*(?:=\\s*)?\"((?:([^\n\r\"\\\\])|\\\\(?:([btnfr\"'\\\\])|([0-3]?[0-7]{1,2})|u(\\p{XDigit}{4})))*)\"\\s*(;\\s*)?");
    private final Pattern REGEX_TO_JAVA = Pattern.compile("\\\\[tnrf]|.");

    private JavaRegexTransfer() {
    }

    public String regexToSource(String regex) {
        Matcher m = this.REGEX_TO_JAVA.matcher(regex);
        StringBuilder res = new StringBuilder();
        while (m.find()) {
            if (m.group().length() > 1) {
                res.append(m.group());
                continue;
            }
            char a = m.group().charAt(0);
            if (a == '\"' || a == '\\') {
                res.append('\\');
            }
            res.append(a);
        }
        return res.toString();
    }

    public String sourceToRegex(String source) {
        Matcher m = this.STRING.matcher(source);
        if (m.matches()) {
            source = m.group(1);
        }
        m = this.CHAR_IN_STRING.matcher(source);
        StringBuilder res = new StringBuilder();
        while (m.find()) {
            char a;
            if (m.group(2) != null) {
                char a2 = m.group(2).charAt(0);
                if (a2 == 'b') {
                    res.append("\\010");
                    continue;
                }
                if (a2 == 't' || a2 == 'n' || a2 == 'r' || a2 == 'f') {
                    res.append('\\').append(a2);
                    continue;
                }
                res.append(a2);
                continue;
            }
            if (m.group(3) != null) {
                String str = m.group(3);
                a = (char)Integer.parseInt(str, 8);
                if (Character.isISOControl(a)) {
                    res.append("\\0").append(str);
                    continue;
                }
                res.append(a);
                continue;
            }
            if (m.group(4) != null) {
                String str = m.group(4);
                a = (char)Integer.parseInt(str, 16);
                if (Character.isISOControl(a) || a > '\u009f') {
                    res.append(m.group());
                    continue;
                }
                res.append(a);
                continue;
            }
            res.append(m.group());
        }
        return res.toString();
    }
}

