/*
 * Decompiled with CFR 0.152.
 */
package com.ess.regexutil.controls;

import com.ess.regexutil.controls.RegexHighlighter;
import com.ess.regexutil.parsedtext.ITextEditorAdapter;
import com.ess.regexutil.parsedtext.ITextStyle;
import com.ess.regexutil.parsedtext.StyleData;
import com.ess.regexutil.regexparser.ParsedRegex;
import com.ess.regexutil.regexparser.RegexConfig;
import com.ess.util.EmptyArrays;
import com.ess.util.EventListener;
import java.util.Arrays;

public class SplitHilighter {
    private final ITextEditorAdapter textEditor;
    private final ITextEditorAdapter resultEditor;
    private final RegexHighlighter highlighter;
    private String[] splittedText;
    private StyleData sd = new StyleData(100);
    private boolean isDisable;

    public SplitHilighter(ITextEditorAdapter textEditor, ITextEditorAdapter resultEditor, RegexHighlighter highlighter, boolean isDisable) {
        this.textEditor = textEditor;
        this.resultEditor = resultEditor;
        this.highlighter = highlighter;
        this.isDisable = isDisable;
        highlighter.regexChangeListeners.addListener(new EventListener<ParsedRegex>(){

            @Override
            public void notify(ParsedRegex event) {
                if (event != null && !SplitHilighter.this.isDisable) {
                    SplitHilighter.this.resplit();
                }
            }
        });
        textEditor.getListenersList().addListener(new EventListener<String>(){

            @Override
            public void notify(String event) {
                if (event != null && !SplitHilighter.this.isDisable) {
                    SplitHilighter.this.resplit();
                }
            }
        });
    }

    public boolean isDisable() {
        return this.isDisable;
    }

    public void setDisable(boolean isDisable) {
        if (this.isDisable == isDisable) {
            return;
        }
        this.isDisable = isDisable;
        if (isDisable) {
            this.resplit();
        }
    }

    private void resplit() {
        Object[] newSplittedText;
        ParsedRegex parsedRegex = this.highlighter.getParsedRegex();
        if (parsedRegex.isError()) {
            newSplittedText = EmptyArrays.STRINGS;
        } else {
            try {
                newSplittedText = parsedRegex.getPattern().split(this.textEditor.getText());
            }
            catch (Throwable e) {
                String res = "Exception thrown: " + e;
                this.sd = this.sd.getInstance(res.length());
                RegexConfig.getInstance().getError().apply(this.sd, 0, res.length());
                this.resultEditor.setText(res);
                this.resultEditor.paint(this.sd);
                return;
            }
        }
        if (Arrays.equals(this.splittedText, newSplittedText)) {
            return;
        }
        int numberLength = String.valueOf(newSplittedText.length - 1).length();
        this.splittedText = newSplittedText;
        this.sd = this.sd.getInstance(this.textEditor.getText().length() * (5 + numberLength + 2 + 1));
        ITextStyle defaultStyle = RegexConfig.getInstance().getSplitResultDefaultStyle();
        ITextStyle partNumberStyle = RegexConfig.getInstance().getSplitPartNumberStyle();
        ITextStyle resultStyle = RegexConfig.getInstance().getSplitResultStyle();
        StringBuilder res = new StringBuilder();
        int iLength = 1;
        int iLimit = 10;
        int i = 0;
        while (i < newSplittedText.length) {
            int partStart = res.length();
            res.append("part ");
            if (i == iLimit) {
                iLimit *= 10;
            }
            int k = ++iLength;
            while (k < numberLength) {
                res.append(' ');
                ++k;
            }
            res.append(i);
            res.append(": ");
            int textStart = res.length();
            res.append((String)newSplittedText[i]);
            res.append("\r\n");
            defaultStyle.apply(this.sd, partStart, res.length());
            partNumberStyle.apply(this.sd, partStart, textStart);
            resultStyle.apply(this.sd, textStart, res.length());
            ++i;
        }
        this.resultEditor.setText(res.toString());
        this.resultEditor.paint(this.sd);
    }
}

