/*
 * Decompiled with CFR 0.152.
 */
package com.ess.regexutil.controls;

import com.ess.regexutil.controls.RegexHighlighter;
import com.ess.regexutil.parsedtext.ITextEditorAdapter;
import com.ess.regexutil.parsedtext.ITextItem;
import com.ess.regexutil.parsedtext.ITextStyle;
import com.ess.regexutil.parsedtext.StyleData;
import com.ess.regexutil.parsedtext.TextStyle;
import com.ess.regexutil.regexparser.Bracket;
import com.ess.regexutil.regexparser.CloseBracket;
import com.ess.regexutil.regexparser.GroupNumber;
import com.ess.regexutil.regexparser.OpenBracket;
import com.ess.regexutil.regexparser.ParsedRegex;
import com.ess.regexutil.regexparser.RegexConfig;
import com.ess.util.EventListener;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SecondaryEditorHilighter {
    private ITextStyle selectionStyle;
    private ITextEditorAdapter textEditor;
    private ITextEditorAdapter regexEditor;
    private RegexHighlighter highlighter;
    private StyleData sd = new StyleData(100);
    private boolean matchMode;
    private boolean isDisable;

    public SecondaryEditorHilighter(RegexHighlighter highlighter, ITextEditorAdapter textEditor, boolean isDisable) {
        this.isDisable = isDisable;
        this.highlighter = highlighter;
        this.textEditor = textEditor;
        this.regexEditor = highlighter.getRegexEditor();
        textEditor.getListenersList().addListener(new EventListener<String>(){

            @Override
            public void notify(String event) {
                if (SecondaryEditorHilighter.this.isDisable) {
                    return;
                }
                if (event != null) {
                    SecondaryEditorHilighter.this.repaint();
                }
            }
        });
        highlighter.regexChangeListeners.addListener(new EventListener<ParsedRegex>(){

            @Override
            public void notify(ParsedRegex event) {
                if (SecondaryEditorHilighter.this.isDisable) {
                    return;
                }
                SecondaryEditorHilighter.this.repaint();
            }
        });
        this.selectionStyle = new TextStyle(0xFFFFFF, 0x3399FF, null, null);
    }

    public boolean isMatchMode() {
        return this.matchMode;
    }

    public void setMatchMode(boolean matchMode) {
        if (this.matchMode == matchMode) {
            return;
        }
        this.matchMode = matchMode;
        this.repaint();
    }

    public boolean isDisable() {
        return this.isDisable;
    }

    public void setDisable(boolean isDisable) {
        if (this.isDisable != isDisable) {
            this.isDisable = isDisable;
            if (!isDisable) {
                this.repaint();
            }
        }
    }

    private void repaint() {
        block22: {
            ParsedRegex parsedRegex = this.highlighter.getParsedRegex();
            String text = this.textEditor.getText();
            this.sd = this.sd.getInstance(text.length());
            try {
                int endSel;
                RegexConfig.getInstance().getTextDefaultStyle().apply(this.sd, 0, text.length());
                if (parsedRegex.isError()) break block22;
                Pattern pattern = parsedRegex.getPattern();
                int highLightingGroup = -1;
                int startSel = this.regexEditor.getStartSelection();
                if (startSel == (endSel = this.regexEditor.getEndSelection())) {
                    OpenBracket bracket;
                    int caret = this.regexEditor.getCaret();
                    ITextItem item = parsedRegex.getItemAtCaretLocation(caret);
                    if ((item instanceof OpenBracket || item instanceof CloseBracket) && (bracket = item instanceof CloseBracket ? (OpenBracket)((CloseBracket)item).getOtherBracket() : (OpenBracket)item).getGroupNumber() != -1) {
                        highLightingGroup = bracket.getGroupNumber();
                    }
                } else {
                    ITextItem firstItem = parsedRegex.getItem(startSel);
                    if (firstItem != null && firstItem.getIndex() == startSel) {
                        ITextItem lastItem = firstItem;
                        while (lastItem != null && lastItem.getEnd() < endSel) {
                            lastItem = lastItem instanceof Bracket && ((Bracket)lastItem).isOpen() ? ((Bracket)lastItem).getOtherBracket() : lastItem.getNext();
                        }
                        if (lastItem != null && lastItem.getEnd() == endSel && parsedRegex.canAddGroup(startSel, endSel)) {
                            highLightingGroup = 1;
                            ITextItem item = firstItem.getPred();
                            while (item != null) {
                                if (item instanceof OpenBracket && ((OpenBracket)item).getGroupNumber() != -1) {
                                    highLightingGroup = ((OpenBracket)item).getGroupNumber() + 1;
                                    break;
                                }
                                item = item.getPred();
                            }
                            String regex = parsedRegex.getRegex();
                            StringBuilder res = new StringBuilder();
                            List<ITextItem> list = parsedRegex.getList();
                            for (ITextItem item2 : list) {
                                if (item2 == firstItem) {
                                    res.append('(');
                                }
                                if (item2 instanceof GroupNumber && ((GroupNumber)item2).getGroupNumber() >= highLightingGroup) {
                                    res.append('\\').append(((GroupNumber)item2).getGroupNumber() + 1);
                                } else {
                                    res.append(regex, item2.getIndex(), item2.getEnd());
                                }
                                if (item2 != lastItem) continue;
                                res.append(')');
                            }
                            try {
                                pattern = Pattern.compile(res.toString(), parsedRegex.getFlags());
                            }
                            catch (RuntimeException e) {
                                highLightingGroup = -1;
                                System.err.println("Error: " + e);
                            }
                        }
                    }
                }
                Matcher m = pattern.matcher(text);
                if (this.matchMode) {
                    if (m.matches()) {
                        RegexConfig.getInstance().getMatchedText1().apply(this.sd, 0, text.length());
                        if (highLightingGroup != -1 && m.group(highLightingGroup) != null) {
                            this.selectionStyle.apply(this.sd, m.start(highLightingGroup), m.end(highLightingGroup));
                        }
                    }
                } else {
                    int i = 0;
                    while (m.find()) {
                        (!(i & true) ? RegexConfig.getInstance().getMatchedText1() : RegexConfig.getInstance().getMatchedText2()).apply(this.sd, m.start(), m.end());
                        if (highLightingGroup != -1 && m.group(highLightingGroup) != null) {
                            this.selectionStyle.apply(this.sd, m.start(highLightingGroup), m.end(highLightingGroup));
                        }
                        ++i;
                    }
                }
            }
            catch (Throwable throwable) {
                RegexConfig.getInstance().getError().apply(this.sd, 0, text.length());
            }
        }
        this.textEditor.paint(this.sd);
    }
}

