/*
 * Decompiled with CFR 0.152.
 */
package com.ess.regexutil.controls;

import com.ess.regexutil.controls.RegexHighlighter;
import com.ess.regexutil.parsedtext.ITextEditorAdapter;
import com.ess.regexutil.parsedtext.ITextStyle;
import com.ess.regexutil.parsedtext.StyleData;
import com.ess.regexutil.regexparser.ParsedRegex;
import com.ess.regexutil.regexparser.RegexConfig;
import com.ess.regexutil.replacementparser.ParsedReplacement;
import com.ess.util.EventListener;
import java.awt.Point;
import java.util.ArrayList;
import java.util.regex.Matcher;

public class ReplaceHilighter {
    private final ITextEditorAdapter textEditor;
    private final ITextEditorAdapter replacementEditor;
    private final ITextEditorAdapter resultEditor;
    private final RegexHighlighter highlighter;
    private ParsedReplacement parsedReplacement;
    private ArrayList<Point> bounds = new ArrayList();
    private StyleData sd = new StyleData(100);
    private boolean isDisable;

    public ReplaceHilighter(ITextEditorAdapter textEditor, ITextEditorAdapter resultEditor, RegexHighlighter highlighter, ITextEditorAdapter replacementEditor, boolean isDisable) {
        this.textEditor = textEditor;
        this.resultEditor = resultEditor;
        this.highlighter = highlighter;
        this.replacementEditor = replacementEditor;
        this.isDisable = isDisable;
        this.reparceReplacement();
        highlighter.regexChangeListeners.addListener(new EventListener<ParsedRegex>(){

            @Override
            public void notify(ParsedRegex event) {
                if (ReplaceHilighter.this.isDisable) {
                    return;
                }
                if (event != null) {
                    ReplaceHilighter.this.reparceReplacement();
                    ReplaceHilighter.this.rereplace();
                }
            }
        });
        textEditor.getListenersList().addListener(new EventListener<String>(){

            @Override
            public void notify(String event) {
                if (ReplaceHilighter.this.isDisable) {
                    return;
                }
                if (event != null) {
                    ReplaceHilighter.this.rereplace();
                }
            }
        });
        replacementEditor.getListenersList().addListener(new EventListener<String>(){

            @Override
            public void notify(String event) {
                if (ReplaceHilighter.this.isDisable) {
                    return;
                }
                if (event != null) {
                    ReplaceHilighter.this.reparceReplacement();
                    ReplaceHilighter.this.rereplace();
                } else {
                    ReplaceHilighter.this.repaintReplacement();
                }
            }
        });
    }

    public boolean isDisable() {
        return this.isDisable;
    }

    public void setDisable(boolean isDisable) {
        if (this.isDisable != isDisable) {
            this.isDisable = isDisable;
            if (!isDisable) {
                this.reparceReplacement();
                this.rereplace();
            }
        }
    }

    private void reparceReplacement() {
        this.parsedReplacement = new ParsedReplacement(this.highlighter, this.replacementEditor.getText());
        this.repaintReplacement();
    }

    private void repaintReplacement() {
        String replacement = this.replacementEditor.getText();
        this.sd = this.sd.getInstance(replacement.length());
        RegexConfig.getInstance().getDefaultStyle().apply(this.sd, 0, replacement.length());
        this.parsedReplacement.paint(this.sd, this.replacementEditor.getCaret());
        this.replacementEditor.paint(this.sd);
    }

    private void rereplace() {
        if (this.parsedReplacement.isError() || this.highlighter.getParsedRegex().isError()) {
            this.resultEditor.setText("");
            return;
        }
        String replacement = this.replacementEditor.getText();
        try {
            Matcher m = this.highlighter.getParsedRegex().getPattern().matcher(this.textEditor.getText());
            StringBuffer res = new StringBuffer();
            int lastGroupEnd = 0;
            while (m.find()) {
                int bufferEnd = res.length();
                m.appendReplacement(res, replacement);
                this.bounds.add(new Point(bufferEnd + (m.start() - lastGroupEnd), res.length()));
                lastGroupEnd = m.end();
            }
            m.appendTail(res);
            this.sd = this.sd.getInstance(res.length());
            RegexConfig.getInstance().getDefaultStyle().apply(this.sd, 0, res.length());
            ITextStyle replacedStyle = RegexConfig.getInstance().getReplaced();
            for (Point p : this.bounds) {
                replacedStyle.apply(this.sd, p.x, p.y);
            }
            this.bounds.clear();
            this.resultEditor.setText(res.toString());
            this.resultEditor.paint(this.sd);
        }
        catch (Throwable e) {
            String res = "Exception thrown: " + e;
            this.sd = this.sd.getInstance(res.length());
            RegexConfig.getInstance().getError().apply(this.sd, 0, res.length());
            this.resultEditor.setText(res);
            this.resultEditor.paint(this.sd);
        }
    }
}

