/*
 * Decompiled with CFR 0.152.
 */
package com.ess.regexutil.controls;

import com.ess.regexutil.parsedtext.ITextEditorAdapter;
import com.ess.regexutil.parsedtext.ITextItem;
import com.ess.regexutil.parsedtext.StyleData;
import com.ess.regexutil.regexparser.Flags;
import com.ess.regexutil.regexparser.ParsedRegex;
import com.ess.regexutil.regexparser.RegexConfig;
import com.ess.util.EventListener;
import com.ess.util.ListenersList;

public class RegexHighlighter {
    public final ListenersList<ParsedRegex> regexChangeListeners = new ListenersList();
    private ParsedRegex parsedRegex;
    private ITextEditorAdapter editor;
    private Flags flags;
    private StyleData sd = new StyleData(100);

    public RegexHighlighter(ITextEditorAdapter editor, Flags flags) {
        this.editor = editor;
        this.flags = flags;
        flags.changeListeners.addListener(new EventListener<Integer>(){

            @Override
            public void notify(Integer event) {
                RegexHighlighter.this.reparsing();
            }
        });
        editor.getListenersList().addListener(new EventListener<String>(){

            @Override
            public void notify(String event) {
                if (event != null) {
                    RegexHighlighter.this.reparsing();
                } else {
                    RegexHighlighter.this.repaint(true);
                }
            }
        });
        editor.setTooltipResolver(new ITextEditorAdapter.TooltipResolver(){

            public String getTooltip(int pos) {
                ITextItem item = RegexHighlighter.this.parsedRegex.getItem(pos);
                return item == null ? null : item.getHint();
            }
        });
        this.reparsing();
    }

    private void repaint(boolean needSend) {
        int length = this.editor.getText().length();
        this.sd = this.sd.getInstance(length);
        RegexConfig.getInstance().getRegexDefaultStyle().apply(this.sd, 0, length);
        this.parsedRegex.paint(this.sd, this.editor.getCaret());
        this.editor.paint(this.sd);
        if (needSend) {
            this.regexChangeListeners.send();
        }
    }

    private void reparsing() {
        this.parsedRegex = new ParsedRegex(this.editor.getText(), this.flags.getFlags());
        this.repaint(false);
        this.regexChangeListeners.send(this.parsedRegex);
    }

    public ParsedRegex getParsedRegex() {
        return this.parsedRegex;
    }

    public ITextEditorAdapter getRegexEditor() {
        return this.editor;
    }
}

