/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.index.core;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Logger;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.DateTools;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.PrefixQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.LockObtainFailedException;
import org.apache.lucene.store.NIOFSDirectory;
import org.apache.lucene.util.Version;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.internal.tasks.core.AbstractTask;
import org.eclipse.mylyn.internal.tasks.core.ITaskList;
import org.eclipse.mylyn.internal.tasks.core.ITaskListChangeListener;
import org.eclipse.mylyn.internal.tasks.core.ITaskListRunnable;
import org.eclipse.mylyn.internal.tasks.core.TaskAttachment;
import org.eclipse.mylyn.internal.tasks.core.TaskComment;
import org.eclipse.mylyn.internal.tasks.core.TaskContainerDelta;
import org.eclipse.mylyn.internal.tasks.core.TaskList;
import org.eclipse.mylyn.internal.tasks.core.data.ITaskDataManagerListener;
import org.eclipse.mylyn.internal.tasks.core.data.TaskDataManager;
import org.eclipse.mylyn.internal.tasks.core.data.TaskDataManagerEvent;
import org.eclipse.mylyn.internal.tasks.index.core.Messages;
import org.eclipse.mylyn.internal.tasks.index.core.TaskAnalyzer;
import org.eclipse.mylyn.tasks.core.IRepositoryElement;
import org.eclipse.mylyn.tasks.core.IRepositoryListener;
import org.eclipse.mylyn.tasks.core.IRepositoryManager;
import org.eclipse.mylyn.tasks.core.IRepositoryPerson;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.ITaskAttachment;
import org.eclipse.mylyn.tasks.core.ITaskComment;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.data.AbstractTaskSchema;
import org.eclipse.mylyn.tasks.core.data.DefaultTaskSchema;
import org.eclipse.mylyn.tasks.core.data.ITaskDataManager;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.core.data.TaskData;

public class TaskListIndex
implements ITaskDataManagerListener,
ITaskListChangeListener,
IRepositoryListener {
    private static final Object COMMAND_RESET_INDEX = "index:reset";
    private static final String INDEX_TASK_ATTRIBUTE_PREFIX = "index:";
    private static final String TASK_ATTRIBUTE_IDENTIFIER = "index:handle-identifier";
    private static final String TASK_ATTRIBUTE_REPOSITORY_URL = "index:repository-url";
    private static final String TASK_ATTRIBUTE_CONTENT = "index:content";
    private static final String TASK_ATTRIBUTE_PERSON = "index:person";
    private static final String TASK_ATTRIBUTE_ATTACHMENT_NAME = "index:attachment";
    public static final AbstractTaskSchema.Field FIELD_IDENTIFIER = new AbstractTaskSchema.Field("index:handle-identifier", Messages.TaskListIndex_field_identifier, "shortText", "identifier", new AbstractTaskSchema.Flag[0]);
    public static final AbstractTaskSchema.Field FIELD_REPOSITORY_URL = new AbstractTaskSchema.Field("index:repository-url", Messages.TaskListIndex_field_repository_url, "url", "repository_url", new AbstractTaskSchema.Flag[0]);
    public static final AbstractTaskSchema.Field FIELD_CONTENT = new AbstractTaskSchema.Field("index:content", Messages.TaskListIndex_field_content, "longText", "content", new AbstractTaskSchema.Flag[0]);
    public static final AbstractTaskSchema.Field FIELD_PERSON = new AbstractTaskSchema.Field("index:person", Messages.TaskListIndex_field_person, "person", "person", new AbstractTaskSchema.Flag[0]);
    public static final AbstractTaskSchema.Field FIELD_TASK_KEY = DefaultTaskSchema.getInstance().TASK_KEY;
    public static final AbstractTaskSchema.Field FIELD_SUMMARY = DefaultTaskSchema.getInstance().SUMMARY;
    public static final AbstractTaskSchema.Field FIELD_ATTACHMENT_NAME = new AbstractTaskSchema.Field("index:attachment", Messages.TaskListIndex_field_attachment, "shortText", "attachment", new AbstractTaskSchema.Flag[0]);
    private final Set<AbstractTaskSchema.Field> specialFields = new HashSet<AbstractTaskSchema.Field>();
    private final Set<AbstractTaskSchema.Field> indexedFields = new LinkedHashSet<AbstractTaskSchema.Field>();
    private Directory directory;
    private MaintainIndexJob maintainIndexJob;
    private final Map<ITask, TaskData> reindexQueue;
    private IndexReader indexReader;
    private volatile boolean rebuildIndex;
    private String lastPatternString;
    private Set<String> lastResults;
    private AbstractTaskSchema.Field defaultField;
    private final TaskList taskList;
    private final TaskDataManager dataManager;
    private final IRepositoryManager repositoryManager;
    private long startupDelay;
    private long reindexDelay;
    private int maxMatchSearchHits;
    private final ReadWriteLock indexReaderLock;

    private TaskListIndex(TaskList taskList, TaskDataManager dataManager, IRepositoryManager repositoryManager) {
        this.specialFields.add(FIELD_IDENTIFIER);
        this.specialFields.add(FIELD_REPOSITORY_URL);
        this.specialFields.add(FIELD_CONTENT);
        this.specialFields.add(FIELD_PERSON);
        this.specialFields.add(FIELD_TASK_KEY);
        this.specialFields.add(FIELD_ATTACHMENT_NAME);
        this.addIndexedField(FIELD_IDENTIFIER);
        this.addIndexedField(FIELD_TASK_KEY);
        this.addIndexedField(FIELD_REPOSITORY_URL);
        this.addIndexedField(FIELD_SUMMARY);
        this.addIndexedField(FIELD_CONTENT);
        this.addIndexedField(FIELD_ATTACHMENT_NAME);
        this.addIndexedField(DefaultTaskSchema.getInstance().USER_ASSIGNED);
        this.addIndexedField(DefaultTaskSchema.getInstance().USER_REPORTER);
        this.addIndexedField(FIELD_PERSON);
        this.addIndexedField(DefaultTaskSchema.getInstance().COMPONENT);
        this.addIndexedField(DefaultTaskSchema.getInstance().DATE_COMPLETION);
        this.addIndexedField(DefaultTaskSchema.getInstance().DATE_CREATION);
        this.addIndexedField(DefaultTaskSchema.getInstance().DATE_DUE);
        this.addIndexedField(DefaultTaskSchema.getInstance().DATE_MODIFICATION);
        this.addIndexedField(DefaultTaskSchema.getInstance().DESCRIPTION);
        this.addIndexedField(DefaultTaskSchema.getInstance().KEYWORDS);
        this.addIndexedField(DefaultTaskSchema.getInstance().PRODUCT);
        this.addIndexedField(DefaultTaskSchema.getInstance().RESOLUTION);
        this.addIndexedField(DefaultTaskSchema.getInstance().SEVERITY);
        this.addIndexedField(DefaultTaskSchema.getInstance().STATUS);
        this.reindexQueue = new HashMap<ITask, TaskData>();
        this.rebuildIndex = false;
        this.defaultField = FIELD_SUMMARY;
        this.startupDelay = 6000L;
        this.reindexDelay = 3000L;
        this.maxMatchSearchHits = 1500;
        this.indexReaderLock = new ReentrantReadWriteLock(true);
        Assert.isNotNull((Object)taskList);
        Assert.isNotNull((Object)dataManager);
        Assert.isNotNull((Object)repositoryManager);
        this.taskList = taskList;
        this.dataManager = dataManager;
        this.repositoryManager = repositoryManager;
    }

    private void addIndexedField(AbstractTaskSchema.Field field) {
        Assert.isNotNull((Object)field);
        Assert.isNotNull((Object)field.getIndexKey());
        this.indexedFields.add(field);
    }

    public ITaskList getTaskList() {
        return this.taskList;
    }

    public ITaskDataManager getDataManager() {
        return this.dataManager;
    }

    public IRepositoryManager getRepositoryManager() {
        return this.repositoryManager;
    }

    public TaskListIndex(TaskList taskList, TaskDataManager dataManager, IRepositoryManager repositoryManager, File indexLocation) {
        this(taskList, dataManager, repositoryManager, indexLocation, 6000L);
    }

    public TaskListIndex(TaskList taskList, TaskDataManager dataManager, IRepositoryManager repositoryManager, File indexLocation, long startupDelay) {
        this(taskList, dataManager, repositoryManager);
        Assert.isTrue((startupDelay >= 0L && startupDelay <= 60000L ? 1 : 0) != 0);
        Assert.isNotNull((Object)indexLocation);
        this.startupDelay = startupDelay;
        this.setLocationInternal(indexLocation);
        this.initialize();
    }

    public TaskListIndex(TaskList taskList, TaskDataManager dataManager, IRepositoryManager repositoryManager, Directory directory) {
        this(taskList, dataManager, repositoryManager);
        this.directory = directory;
        this.initialize();
    }

    public long getReindexDelay() {
        return this.reindexDelay;
    }

    public void setReindexDelay(long reindexDelay) {
        Assert.isTrue((reindexDelay >= 0L ? 1 : 0) != 0);
        this.reindexDelay = reindexDelay;
    }

    public void setLocation(File indexLocation) {
        try {
            this.waitUntilIdle();
        }
        catch (InterruptedException interruptedException) {}
        this.setLocationInternal(indexLocation);
        this.rebuildIndex = true;
        this.scheduleIndexMaintenance(MaintainIndexType.STARTUP);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setLocationInternal(File indexLocation) {
        boolean newLocationExists = indexLocation.exists();
        if (!newLocationExists && !indexLocation.mkdirs()) {
            StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.index.core", "Cannot create task list index folder: " + indexLocation));
        }
        Lock writeLock = this.indexReaderLock.writeLock();
        writeLock.lock();
        try {
            TaskListIndex taskListIndex = this;
            synchronized (taskListIndex) {
                if (this.indexReader != null) {
                    try {
                        this.indexReader.close();
                    }
                    catch (IOException iOException) {}
                    this.indexReader = null;
                }
                if (indexLocation.exists() && indexLocation.isDirectory()) {
                    if (this.directory != null) {
                        try {
                            this.directory.close();
                        }
                        catch (IOException e) {
                            StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.index.core", "Cannot close index: " + e.getMessage(), (Throwable)e));
                        }
                    }
                    try {
                        this.directory = new NIOFSDirectory(indexLocation);
                    }
                    catch (IOException e) {
                        StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.index.core", "Cannot create task list index", (Throwable)e));
                    }
                }
            }
        }
        finally {
            writeLock.unlock();
        }
    }

    public AbstractTaskSchema.Field getDefaultField() {
        return this.defaultField;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDefaultField(AbstractTaskSchema.Field defaultField) {
        Assert.isNotNull((Object)defaultField);
        Assert.isNotNull((Object)defaultField.getIndexKey());
        Assert.isTrue((boolean)this.indexedFields.contains(defaultField));
        this.defaultField = defaultField;
        TaskListIndex taskListIndex = this;
        synchronized (taskListIndex) {
            this.lastResults = null;
        }
    }

    public Set<AbstractTaskSchema.Field> getIndexedFields() {
        return Collections.unmodifiableSet(this.indexedFields);
    }

    public int getMaxMatchSearchHits() {
        return this.maxMatchSearchHits;
    }

    public void setMaxMatchSearchHits(int maxMatchSearchHits) {
        this.maxMatchSearchHits = maxMatchSearchHits;
    }

    private void initialize() {
        if (!this.rebuildIndex) {
            IndexReader indexReader = null;
            try {
                indexReader = this.getIndexReader();
            }
            catch (Exception exception) {}
            if (indexReader == null) {
                this.rebuildIndex = true;
            }
        }
        this.maintainIndexJob = new MaintainIndexJob();
        this.dataManager.addListener((ITaskDataManagerListener)this);
        this.taskList.addChangeListener((ITaskListChangeListener)this);
        this.repositoryManager.addListener((IRepositoryListener)this);
        this.scheduleIndexMaintenance(MaintainIndexType.STARTUP);
    }

    private void scheduleIndexMaintenance(MaintainIndexType type) {
        long delay = 0L;
        switch (type) {
            case STARTUP: {
                delay = this.startupDelay;
                break;
            }
            case REINDEX: {
                delay = this.reindexDelay;
            }
        }
        if (delay == 0L) {
            this.maintainIndexJob.cancel();
            try {
                this.maintainIndexJob.join();
            }
            catch (InterruptedException interruptedException) {}
            try {
                this.maintainIndex((IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException e) {
                MultiStatus logStatus = new MultiStatus("org.eclipse.mylyn.tasks.index.core", 0, "Failed to update task list index", (Throwable)e);
                logStatus.add(e.getStatus());
                StatusHandler.log((IStatus)logStatus);
            }
        } else {
            this.maintainIndexJob.schedule(delay);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean matches(ITask task, String patternString) {
        block24: {
            if (patternString.equals(COMMAND_RESET_INDEX)) {
                this.reindex();
            }
            Lock readLock = this.indexReaderLock.readLock();
            readLock.lock();
            try {
                TaskListIndex indexSearcher;
                Set<String> hits;
                IndexReader indexReader;
                block26: {
                    boolean needIndexHit;
                    indexReader = this.getIndexReader();
                    if (indexReader == null) break block24;
                    TaskListIndex taskListIndex = this;
                    synchronized (taskListIndex) {
                        needIndexHit = this.lastResults == null || this.lastPatternString == null || !this.lastPatternString.equals(patternString);
                    }
                    if (needIndexHit) {
                        this.lastPatternString = patternString;
                        hits = new HashSet<String>();
                        indexSearcher = new IndexSearcher(indexReader);
                        try {
                            try {
                                Query query = this.computeQuery(patternString);
                                TopDocs results = indexSearcher.search(query, this.maxMatchSearchHits);
                                ScoreDoc[] scoreDocArray = results.scoreDocs;
                                int n = results.scoreDocs.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    ScoreDoc scoreDoc = scoreDocArray[n2];
                                    Document document = indexReader.document(scoreDoc.doc);
                                    hits.add(document.get(FIELD_IDENTIFIER.getIndexKey()));
                                    ++n2;
                                }
                            }
                            catch (IOException e) {
                                StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.index.core", "Unexpected failure within task list index", (Throwable)e));
                                try {
                                    indexSearcher.close();
                                }
                                catch (IOException iOException) {}
                                break block26;
                            }
                        }
                        catch (Throwable throwable) {
                            try {
                                indexSearcher.close();
                            }
                            catch (IOException iOException) {}
                            throw throwable;
                        }
                        try {
                            indexSearcher.close();
                        }
                        catch (IOException iOException) {}
                    } else {
                        hits = this.lastResults;
                    }
                }
                indexSearcher = this;
                synchronized (indexSearcher) {
                    if (this.indexReader == indexReader) {
                        this.lastPatternString = patternString;
                        this.lastResults = hits;
                    }
                }
                String taskIdentifier = task.getHandleIdentifier();
                boolean bl = hits != null && hits.contains(taskIdentifier);
                return bl;
            }
            finally {
                readLock.unlock();
            }
        }
        return false;
    }

    public void reindex() {
        this.rebuildIndex = true;
        this.scheduleIndexMaintenance(MaintainIndexType.REINDEX);
    }

    public void waitUntilIdle() throws InterruptedException {
        if (!Platform.isRunning() && this.reindexDelay != 0L) {
            Logger.getLogger(TaskListIndex.class.getName()).warning("Index job joining may not work properly when Eclipse platform is not running");
        }
        this.maintainIndexJob.join();
    }

    public void find(String patternString, TaskCollector collector, int resultsLimit) {
        block15: {
            Assert.isNotNull((Object)patternString);
            Assert.isNotNull((Object)collector);
            Assert.isTrue((resultsLimit > 0 ? 1 : 0) != 0);
            Lock readLock = this.indexReaderLock.readLock();
            readLock.lock();
            try {
                IndexReader indexReader = this.getIndexReader();
                if (indexReader == null) break block15;
                IndexSearcher indexSearcher = new IndexSearcher(indexReader);
                try {
                    try {
                        Query query = this.computeQuery(patternString);
                        TopDocs results = indexSearcher.search(query, resultsLimit);
                        ScoreDoc[] scoreDocArray = results.scoreDocs;
                        int n = results.scoreDocs.length;
                        int n2 = 0;
                        while (n2 < n) {
                            ScoreDoc scoreDoc = scoreDocArray[n2];
                            Document document = indexReader.document(scoreDoc.doc);
                            String taskIdentifier = document.get(FIELD_IDENTIFIER.getIndexKey());
                            AbstractTask task = this.taskList.getTask(taskIdentifier);
                            if (task != null) {
                                collector.collect((ITask)task);
                            }
                            ++n2;
                        }
                    }
                    catch (IOException e) {
                        StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.index.core", "Unexpected failure within task list index", (Throwable)e));
                        try {
                            indexSearcher.close();
                        }
                        catch (IOException iOException) {}
                        break block15;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        indexSearcher.close();
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
                try {
                    indexSearcher.close();
                }
                catch (IOException iOException) {}
            }
            finally {
                readLock.unlock();
            }
        }
    }

    private Query computeQuery(String patternString) {
        Query q;
        boolean hasBooleanSpecifiers;
        String upperPatternString = patternString.toUpperCase();
        boolean bl = hasBooleanSpecifiers = upperPatternString.contains(" OR ") || upperPatternString.contains(" AND ") || upperPatternString.contains(" NOT ");
        if (!hasBooleanSpecifiers && this.defaultField.equals((Object)FIELD_SUMMARY) && !this.containsSpecialCharacters(patternString)) {
            return new PrefixQuery(new Term(this.defaultField.getIndexKey(), patternString));
        }
        QueryParser qp = new QueryParser(Version.LUCENE_CURRENT, this.defaultField.getIndexKey(), (Analyzer)TaskAnalyzer.instance());
        try {
            q = qp.parse(patternString);
        }
        catch (ParseException parseException) {
            return new PrefixQuery(new Term(this.defaultField.getIndexKey(), patternString));
        }
        if (q instanceof BooleanQuery) {
            BooleanQuery query = (BooleanQuery)q;
            BooleanClause[] booleanClauseArray = query.getClauses();
            int n = booleanClauseArray.length;
            int n2 = 0;
            while (n2 < n) {
                BooleanClause clause = booleanClauseArray[n2];
                if (clause.getQuery() instanceof TermQuery) {
                    TermQuery termQuery = (TermQuery)clause.getQuery();
                    clause.setQuery((Query)new PrefixQuery(termQuery.getTerm()));
                }
                if (!hasBooleanSpecifiers) {
                    clause.setOccur(BooleanClause.Occur.MUST);
                }
                ++n2;
            }
        } else if (q instanceof TermQuery) {
            return new PrefixQuery(((TermQuery)q).getTerm());
        }
        return q;
    }

    private boolean containsSpecialCharacters(String patternString) {
        return patternString.indexOf(58) >= 0 || patternString.indexOf(34) >= 0 || patternString.indexOf(42) >= 0 || patternString.indexOf(63) >= 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        this.dataManager.removeListener((ITaskDataManagerListener)this);
        this.taskList.removeChangeListener((ITaskListChangeListener)this);
        this.repositoryManager.removeListener((IRepositoryListener)this);
        this.maintainIndexJob.cancel();
        try {
            this.maintainIndexJob.join();
        }
        catch (InterruptedException interruptedException) {}
        Lock writeLock = this.indexReaderLock.writeLock();
        writeLock.lock();
        try {
            TaskListIndex taskListIndex = this;
            synchronized (taskListIndex) {
                if (this.indexReader != null) {
                    try {
                        this.indexReader.close();
                    }
                    catch (IOException iOException) {}
                    this.indexReader = null;
                }
            }
            try {
                this.directory.close();
            }
            catch (IOException e) {
                StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.index.core", "Cannot close index: " + e.getMessage(), (Throwable)e));
            }
        }
        finally {
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IndexReader getIndexReader() {
        try {
            TaskListIndex taskListIndex = this;
            synchronized (taskListIndex) {
                if (this.indexReader == null) {
                    this.indexReader = IndexReader.open((Directory)this.directory, (boolean)true);
                    this.lastResults = null;
                }
                return this.indexReader;
            }
        }
        catch (CorruptIndexException corruptIndexException) {
            this.rebuildIndex = true;
            if (this.maintainIndexJob != null) {
                this.scheduleIndexMaintenance(MaintainIndexType.REINDEX);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.rebuildIndex = true;
        }
        catch (IOException iOException) {}
        return null;
    }

    public void taskDataUpdated(TaskDataManagerEvent event) {
        this.reindex(event.getTask(), event.getTaskData());
    }

    public void editsDiscarded(TaskDataManagerEvent event) {
        this.reindex(event.getTask(), event.getTaskData());
    }

    public void containersChanged(Set<TaskContainerDelta> containers) {
        block3: for (TaskContainerDelta delta : containers) {
            switch (delta.getKind()) {
                case ADDED: 
                case REMOVED: 
                case CONTENT: {
                    ITask task;
                    IRepositoryElement element = delta.getElement();
                    if (!(element instanceof ITask) || !"local".equals(((AbstractTask)(task = (ITask)element)).getConnectorKind())) continue block3;
                    this.reindex(task, null);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void reindex(ITask task, TaskData taskData) {
        if (task == null) {
            return;
        }
        if (!this.taskIsIndexable(task, taskData)) {
            return;
        }
        Map<ITask, TaskData> map = this.reindexQueue;
        synchronized (map) {
            this.reindexQueue.put(task, taskData);
        }
        this.scheduleIndexMaintenance(MaintainIndexType.REINDEX);
    }

    private void addIndexedAttributes(Document document, ITask task, TaskAttribute root) {
        this.addIndexedAttribute(document, FIELD_TASK_KEY, task.getTaskKey());
        this.addIndexedAttribute(document, FIELD_REPOSITORY_URL, task.getRepositoryUrl());
        this.addIndexedAttribute(document, FIELD_SUMMARY, root.getMappedAttribute("task.common.summary"));
        for (TaskAttribute contentAttribute : this.computeContentAttributes(root)) {
            this.addIndexedAttribute(document, FIELD_CONTENT, contentAttribute);
        }
        this.addIndexedDateAttributes(document, task);
        TaskData taskData = root.getTaskData();
        List commentAttributes = taskData.getAttributeMapper().getAttributesByType(taskData, "comment");
        for (TaskAttribute commentAttribute : commentAttributes) {
            IRepositoryPerson author;
            TaskComment taskComment = new TaskComment(taskData.getAttributeMapper().getTaskRepository(), task, commentAttribute);
            taskData.getAttributeMapper().updateTaskComment((ITaskComment)taskComment, commentAttribute);
            String text = taskComment.getText();
            if (text.length() != 0) {
                this.addIndexedAttribute(document, FIELD_CONTENT, text);
            }
            if ((author = taskComment.getAuthor()) == null) continue;
            this.addIndexedAttribute(document, FIELD_PERSON, author.getPersonId());
        }
        List personAttributes = taskData.getAttributeMapper().getAttributesByType(taskData, "person");
        for (TaskAttribute personAttribute : personAttributes) {
            this.addIndexedAttribute(document, FIELD_PERSON, personAttribute);
        }
        TaskRepository repository = this.getRepositoryManager().getRepository(task.getConnectorKind(), task.getRepositoryUrl());
        if (repository != null) {
            List attachmentAttributes = taskData.getAttributeMapper().getAttributesByType(taskData, "attachment");
            HashSet<String> attachmentNames = new HashSet<String>();
            for (TaskAttribute attribute : attachmentAttributes) {
                TaskAttachment taskAttachment = new TaskAttachment(repository, task, attribute);
                taskData.getAttributeMapper().updateTaskAttachment((ITaskAttachment)taskAttachment, attribute);
                if (attachmentNames.add(taskAttachment.getFileName())) {
                    this.addIndexedAttribute(document, FIELD_ATTACHMENT_NAME, taskAttachment.getFileName());
                }
                this.addIndexedAttribute(document, FIELD_CONTENT, taskAttachment.getDescription());
            }
        }
        for (AbstractTaskSchema.Field field : this.indexedFields) {
            if (this.specialFields.contains(field)) continue;
            this.addIndexedAttribute(document, field, root.getMappedAttribute(field.getKey()));
        }
    }

    private Collection<TaskAttribute> computeContentAttributes(TaskAttribute root) {
        LinkedHashSet<TaskAttribute> attributes = new LinkedHashSet<TaskAttribute>();
        TaskAttribute attribute2 = root.getMappedAttribute("task.common.summary");
        if (attribute2 != null) {
            attributes.add(attribute2);
        }
        if ((attribute2 = root.getMappedAttribute("task.common.description")) != null) {
            attributes.add(attribute2);
        }
        for (TaskAttribute attribute2 : root.getAttributes().values()) {
            if (!Boolean.parseBoolean(attribute2.getMetaData().getValue("task.meta.index.content"))) continue;
            attributes.add(attribute2);
        }
        return attributes;
    }

    private void addIndexedAttributes(Document document, ITask task) {
        this.addIndexedAttribute(document, FIELD_TASK_KEY, task.getTaskKey());
        this.addIndexedAttribute(document, FIELD_REPOSITORY_URL, task.getRepositoryUrl());
        this.addIndexedAttribute(document, FIELD_SUMMARY, task.getSummary());
        this.addIndexedAttribute(document, FIELD_CONTENT, task.getSummary());
        this.addIndexedAttribute(document, FIELD_CONTENT, ((AbstractTask)task).getNotes());
        this.addIndexedDateAttributes(document, task);
    }

    private void addIndexedDateAttributes(Document document, ITask task) {
        this.addIndexedAttribute(document, DefaultTaskSchema.getInstance().DATE_COMPLETION, task.getCompletionDate());
        this.addIndexedAttribute(document, DefaultTaskSchema.getInstance().DATE_CREATION, task.getCreationDate());
        this.addIndexedAttribute(document, DefaultTaskSchema.getInstance().DATE_DUE, task.getDueDate());
        this.addIndexedAttribute(document, DefaultTaskSchema.getInstance().DATE_MODIFICATION, task.getModificationDate());
    }

    private void addIndexedAttribute(Document document, AbstractTaskSchema.Field indexField, TaskAttribute attribute) {
        if (attribute == null) {
            return;
        }
        List values = attribute.getTaskData().getAttributeMapper().getValueLabels(attribute);
        if (values.isEmpty()) {
            return;
        }
        if (this.isPersonField(indexField)) {
            IRepositoryPerson repositoryPerson = attribute.getTaskData().getAttributeMapper().getRepositoryPerson(attribute);
            this.addIndexedAttribute(document, indexField, repositoryPerson);
            if (values.size() <= 1) {
                return;
            }
        }
        for (String value : values) {
            if (value.length() == 0) continue;
            this.addIndexedAttribute(document, indexField, value);
        }
    }

    private boolean isPersonField(AbstractTaskSchema.Field indexField) {
        return "person".equals(indexField.getType());
    }

    private void addIndexedAttribute(Document document, AbstractTaskSchema.Field indexField, IRepositoryPerson person) {
        if (person != null) {
            this.addIndexedAttribute(document, indexField, person.getPersonId());
            this.addIndexedAttribute(document, indexField, person.getName());
        }
    }

    private void addIndexedAttribute(Document document, AbstractTaskSchema.Field indexField, String value) {
        if (value == null) {
            return;
        }
        Field field = document.getField(indexField.getIndexKey());
        if (field == null) {
            field = new Field(indexField.getIndexKey(), value, Field.Store.YES, Field.Index.ANALYZED);
            document.add((Fieldable)field);
        } else {
            String existingValue = field.stringValue();
            if (!indexField.equals((Object)FIELD_PERSON) || !existingValue.contains(value)) {
                field.setValue(String.valueOf(existingValue) + " " + value);
            }
        }
    }

    private void addIndexedAttribute(Document document, AbstractTaskSchema.Field indexField, Date date) {
        if (date == null) {
            return;
        }
        String value = DateTools.dateToString((Date)date, (DateTools.Resolution)DateTools.Resolution.HOUR);
        Field field = document.getField(indexField.getIndexKey());
        if (field == null) {
            field = new Field(indexField.getIndexKey(), value, Field.Store.YES, Field.Index.ANALYZED);
            document.add((Fieldable)field);
        } else {
            field.setValue(value);
        }
    }

    public String computeQueryFieldDateRange(AbstractTaskSchema.Field field, Date lowerBoundInclusive, Date upperBoundInclusive) {
        return String.valueOf(field.getIndexKey()) + ":[" + DateTools.dateToString((Date)lowerBoundInclusive, (DateTools.Resolution)DateTools.Resolution.DAY) + " TO " + DateTools.dateToString((Date)upperBoundInclusive, (DateTools.Resolution)DateTools.Resolution.DAY) + "]";
    }

    protected boolean taskIsIndexable(ITask task, TaskData taskData) {
        return true;
    }

    public String escapeFieldValue(String value) {
        String escaped = value.replaceAll("([\\+\\-\\!\\(\\)\\{\\}\\[\\]^\"~\\*\\?:\\\\]|&&|\\|\\|)", "\\\\$1");
        return escaped;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void maintainIndex(IProgressMonitor m) throws CoreException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)m, (int)2000);
        try {
            try {
                Object reader;
                if (!this.rebuildIndex) {
                    try {
                        reader = IndexReader.open((Directory)this.directory, (boolean)false);
                        reader.close();
                    }
                    catch (CorruptIndexException corruptIndexException) {
                        this.rebuildIndex = true;
                    }
                }
                if (this.rebuildIndex) {
                    reader = this.reindexQueue;
                    synchronized (reader) {
                        this.reindexQueue.clear();
                    }
                    IStatus status = this.rebuildIndexCompletely(monitor.newChild(1000));
                    if (!status.isOK()) {
                        StatusHandler.log((IStatus)status);
                    }
                } else {
                    monitor.worked(1000);
                }
                this.indexQueuedTasks(monitor.newChild(1000));
                this.closeIndexReader();
            }
            catch (IOException e) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.mylyn.tasks.index.core", "Unexpected exception: " + e.getMessage(), (Throwable)e));
            }
        }
        finally {
            monitor.done();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeIndexReader() throws IOException {
        Lock writeLock = this.indexReaderLock.writeLock();
        writeLock.lock();
        try {
            TaskListIndex taskListIndex = this;
            synchronized (taskListIndex) {
                if (this.indexReader != null) {
                    this.indexReader.close();
                    this.indexReader = null;
                }
            }
        }
        finally {
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void indexQueuedTasks(SubMonitor monitor) throws CorruptIndexException, LockObtainFailedException, IOException, CoreException {
        Map<ITask, TaskData> map = this.reindexQueue;
        synchronized (map) {
            if (this.reindexQueue.isEmpty()) {
                return;
            }
            monitor.beginTask(Messages.TaskListIndex_task_rebuilding_index, this.reindexQueue.size());
        }
        try {
            IndexWriter writer = null;
            try {
                HashMap<ITask, TaskData> workingQueue = new HashMap<ITask, TaskData>();
                block19: while (true) {
                    workingQueue.clear();
                    Map<ITask, TaskData> map2 = this.reindexQueue;
                    synchronized (map2) {
                        if (this.reindexQueue.isEmpty()) {
                            break;
                        }
                        workingQueue.putAll(this.reindexQueue);
                        this.reindexQueue.keySet().removeAll(workingQueue.keySet());
                    }
                    if (writer == null) {
                        try {
                            writer = this.createIndexWriter(false);
                        }
                        catch (CorruptIndexException corruptIndexException) {
                            this.rebuildIndex = true;
                            map2 = this.reindexQueue;
                            synchronized (map2) {
                                this.reindexQueue.clear();
                            }
                            this.rebuildIndexCompletely(monitor);
                            if (writer != null) {
                                writer.close();
                            }
                            monitor.done();
                            return;
                        }
                    }
                    monitor.setWorkRemaining(workingQueue.size());
                    Iterator iterator = workingQueue.entrySet().iterator();
                    while (true) {
                        if (!iterator.hasNext()) continue block19;
                        Map.Entry entry = iterator.next();
                        ITask task = (ITask)entry.getKey();
                        TaskData taskData = (TaskData)entry.getValue();
                        writer.deleteDocuments(new Term(FIELD_IDENTIFIER.getIndexKey(), task.getHandleIdentifier()));
                        this.add(writer, task, taskData);
                        monitor.worked(1);
                    }
                    break;
                }
            }
            finally {
                if (writer != null) {
                    writer.close();
                }
            }
        }
        finally {
            monitor.done();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IStatus rebuildIndexCompletely(SubMonitor monitor) throws CorruptIndexException, LockObtainFailedException, IOException, CoreException {
        MultiStatus multiStatus = new MultiStatus("org.eclipse.mylyn.tasks.index.core", 0, null, null);
        TaskListState taskListState = new TaskListState();
        this.taskList.run((ITaskListRunnable)taskListState, (IProgressMonitor)monitor.newChild(0));
        monitor.beginTask(Messages.TaskListIndex_task_rebuilding_index, taskListState.indexableTasks.size());
        try {
            IndexWriter writer;
            try {
                writer = this.createIndexWriter(true);
            }
            catch (CorruptIndexException e) {
                if (this.directory instanceof FSDirectory) {
                    this.cleanDirectory(((FSDirectory)this.directory).getFile());
                    writer = this.createIndexWriter(true);
                }
                throw e;
            }
            try {
                for (ITask task : taskListState.indexableTasks) {
                    if (this.taskIsIndexable(task, null)) {
                        try {
                            TaskData taskData = this.dataManager.getTaskData(task);
                            this.add(writer, task, taskData);
                        }
                        catch (CoreException e) {
                            multiStatus.add(e.getStatus());
                        }
                    }
                    monitor.worked(1);
                }
                TaskListIndex taskListIndex = this;
                synchronized (taskListIndex) {
                    this.rebuildIndex = false;
                }
            }
            finally {
                writer.close();
            }
        }
        finally {
            monitor.done();
        }
        return multiStatus;
    }

    private void cleanDirectory(File file) throws IOException {
        File[] children;
        if (file.exists() && (children = file.listFiles()) != null) {
            File[] fileArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                File child = fileArray[n2];
                if (child.isDirectory()) {
                    this.cleanDirectory(child);
                }
                child.delete();
                ++n2;
            }
        }
    }

    protected IndexWriter createIndexWriter(boolean create) throws CorruptIndexException, LockObtainFailedException, IOException {
        return new IndexWriter(this.directory, (Analyzer)TaskAnalyzer.instance(), create, IndexWriter.MaxFieldLength.UNLIMITED);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void add(IndexWriter writer, ITask task, TaskData taskData) throws CorruptIndexException, IOException {
        if (!this.taskIsIndexable(task, taskData)) {
            return;
        }
        Document document = new Document();
        document.add((Fieldable)new Field(FIELD_IDENTIFIER.getIndexKey(), task.getHandleIdentifier(), Field.Store.YES, Field.Index.ANALYZED));
        if (taskData == null) {
            if (!"local".equals(((AbstractTask)task).getConnectorKind())) return;
            this.addIndexedAttributes(document, task);
        } else {
            this.addIndexedAttributes(document, task, taskData.getRoot());
        }
        writer.addDocument(document);
    }

    public void repositoryAdded(TaskRepository repository) {
    }

    public void repositoryRemoved(TaskRepository repository) {
    }

    public void repositorySettingsChanged(TaskRepository repository) {
    }

    public void repositoryUrlChanged(TaskRepository repository, String oldUrl) {
        this.reindex();
    }

    private class MaintainIndexJob
    extends Job {
        public MaintainIndexJob() {
            super(Messages.TaskListIndex_indexerJob);
            this.setUser(false);
            this.setSystem(true);
            this.setPriority(30);
        }

        public IStatus run(IProgressMonitor m) {
            if (m.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            try {
                TaskListIndex.this.maintainIndex(m);
            }
            catch (CoreException e) {
                MultiStatus logStatus = new MultiStatus("org.eclipse.mylyn.tasks.index.core", 0, "Failed to update task list index", (Throwable)e);
                logStatus.add(e.getStatus());
                StatusHandler.log((IStatus)logStatus);
            }
            return Status.OK_STATUS;
        }
    }

    private static enum MaintainIndexType {
        STARTUP,
        REINDEX;

    }

    public static abstract class TaskCollector {
        public abstract void collect(ITask var1);
    }

    private class TaskListState
    implements ITaskListRunnable {
        List<ITask> indexableTasks;

        private TaskListState() {
        }

        public void execute(IProgressMonitor monitor) throws CoreException {
            Collection tasks = TaskListIndex.this.taskList.getAllTasks();
            this.indexableTasks = new ArrayList<ITask>(tasks.size());
            for (ITask task : tasks) {
                if (!TaskListIndex.this.taskIsIndexable(task, null)) continue;
                this.indexableTasks.add(task);
            }
        }
    }
}

