/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.textile.core;

import org.eclipse.mylyn.wikitext.tests.AbstractMarkupGenerationTest;
import org.eclipse.mylyn.wikitext.textile.core.TextileLanguage;
import org.junit.Test;

public class TextileCommentBlockTest
extends AbstractMarkupGenerationTest<TextileLanguage> {
    @Test
    public void testSimpleComment() {
        this.assertMarkup("<p>one two</p><p>three</p>", "one two\n\n###. comment\n\nthree");
    }

    @Test
    public void testMultiLineComment() {
        this.assertMarkup("<p>one two</p><p>three</p>", "one two\n\n###. comment\nline two\nline three\n\nthree");
    }

    @Test
    public void testNotAComment() {
        this.assertMarkup("<p>one two</p><p>###.nocomment</p><p>three</p>", "one two\n\n###.nocomment\n\nthree");
    }

    @Test
    public void testNotAComment2() {
        this.assertMarkup("<p>one two<br/>###.nocomment</p><p>three</p>", "one two\n###.nocomment\n\nthree");
    }

    @Test
    public void testExtendedComment() {
        this.assertMarkup("<p>para</p>", "###.. extended comment\n\n\nwith more\n\np. para");
    }

    @Override
    protected TextileLanguage createMarkupLanguage() {
        return new TextileLanguage();
    }
}

