/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.core.parser.builder;

import java.io.StringWriter;
import java.io.Writer;
import junit.framework.TestCase;
import org.eclipse.mylyn.wikitext.confluence.core.ConfluenceLanguage;
import org.eclipse.mylyn.wikitext.core.parser.Attributes;
import org.eclipse.mylyn.wikitext.core.parser.DocumentBuilder;
import org.eclipse.mylyn.wikitext.core.parser.LinkAttributes;
import org.eclipse.mylyn.wikitext.core.parser.MarkupParser;
import org.eclipse.mylyn.wikitext.core.parser.TableAttributes;
import org.eclipse.mylyn.wikitext.core.parser.builder.DocBookDocumentBuilder;
import org.eclipse.mylyn.wikitext.core.parser.markup.MarkupLanguage;
import org.eclipse.mylyn.wikitext.tests.TestUtil;
import org.eclipse.mylyn.wikitext.textile.core.TextileLanguage;

public class DocBookDocumentBuilderTest
extends TestCase {
    private MarkupParser parser;
    private StringWriter out;
    private DocBookDocumentBuilder builder;

    public void setUp() {
        this.parser = new MarkupParser();
        this.parser.setMarkupLanguage((MarkupLanguage)new TextileLanguage());
        this.out = new StringWriter();
        this.builder = new DocBookDocumentBuilder((Writer)this.out);
        this.parser.setBuilder((DocumentBuilder)this.builder);
    }

    public void testInlineImage() {
        this.parser.parse("some text !(inline)images/foo.png! some text");
        String docbook = this.out.toString();
        TestUtil.println("DocBook: \n" + docbook);
        DocBookDocumentBuilderTest.assertTrue((boolean)docbook.contains("<inlinemediaobject role=\"inline\"><imageobject><imagedata fileref=\"images/foo.png\"/></imageobject></inlinemediaobject>"));
    }

    public void testInlineQuote() {
        this.parser.setMarkupLanguage((MarkupLanguage)new ConfluenceLanguage());
        this.parser.parse("some text {quote}quoted text{quote} some text");
        String docbook = this.out.toString();
        TestUtil.println("DocBook: \n" + docbook);
        DocBookDocumentBuilderTest.assertTrue((boolean)docbook.contains("<para>some text <quote>quoted text</quote> some text</para>"));
    }

    public void testImage() {
        this.parser.parse("some text !images/foo.png! some text");
        String docbook = this.out.toString();
        TestUtil.println("DocBook: \n" + docbook);
        DocBookDocumentBuilderTest.assertTrue((boolean)docbook.contains("<mediaobject><imageobject><imagedata fileref=\"images/foo.png\"/></imageobject></mediaobject>"));
    }

    public void testImageWithScaling() {
        this.parser.parse("some text !{width:80%}images/foo.png! some text");
        String docbook = this.out.toString();
        TestUtil.println("DocBook: \n" + docbook);
        DocBookDocumentBuilderTest.assertTrue((boolean)docbook.contains("<mediaobject><imageobject><imagedata fileref=\"images/foo.png\" scale=\"80\"/></imageobject></mediaobject>"));
    }

    public void testDefinitionList() {
        this.builder.beginDocument();
        this.builder.beginBlock(DocumentBuilder.BlockType.DEFINITION_LIST, new Attributes());
        this.builder.beginBlock(DocumentBuilder.BlockType.DEFINITION_TERM, new Attributes());
        this.builder.characters("foo");
        this.builder.endBlock();
        this.builder.beginBlock(DocumentBuilder.BlockType.DEFINITION_ITEM, new Attributes());
        this.builder.characters("Foo definition");
        this.builder.endBlock();
        this.builder.beginBlock(DocumentBuilder.BlockType.DEFINITION_TERM, new Attributes());
        this.builder.characters("bar");
        this.builder.endBlock();
        this.builder.beginBlock(DocumentBuilder.BlockType.DEFINITION_ITEM, new Attributes());
        this.builder.characters("Bar definition");
        this.builder.endBlock();
        this.builder.endBlock();
        this.builder.endDocument();
        String docbook = this.out.toString();
        TestUtil.println("DocBook: \n" + docbook);
        DocBookDocumentBuilderTest.assertTrue((boolean)docbook.contains("<variablelist><varlistentry><term>foo</term><listitem><para>Foo definition</para></listitem></varlistentry><varlistentry><term>bar</term><listitem><para>Bar definition</para></listitem></varlistentry></variablelist>"));
    }

    public void testGlossaryUsesDefinitionList() {
        this.builder.setAutomaticGlossary(false);
        this.parser.parse("ABW(A Better Way) is not NIMBY(Not In My Back Yard)\n\n{glossary}");
        String docbook = this.out.toString();
        TestUtil.println("DocBook: \n" + docbook);
        DocBookDocumentBuilderTest.assertTrue((boolean)docbook.contains("<variablelist><varlistentry><term>ABW</term><listitem><para>A Better Way</para></listitem></varlistentry><varlistentry><term>NIMBY</term><listitem><para>Not In My Back Yard</para></listitem></varlistentry></variablelist>"));
    }

    public void testAutomaticGlossaryOnByDefault() {
        DocBookDocumentBuilderTest.assertTrue((boolean)this.builder.isAutomaticGlossary());
    }

    public void testNestedListsCreatesValidDocbook() {
        this.builder.beginDocument();
        this.builder.beginBlock(DocumentBuilder.BlockType.BULLETED_LIST, new Attributes());
        this.builder.beginBlock(DocumentBuilder.BlockType.LIST_ITEM, new Attributes());
        this.builder.characters("foo");
        this.builder.beginBlock(DocumentBuilder.BlockType.BULLETED_LIST, new Attributes());
        this.builder.beginBlock(DocumentBuilder.BlockType.LIST_ITEM, new Attributes());
        this.builder.characters("bar");
        this.builder.endBlock();
        this.builder.endBlock();
        this.builder.characters("foo2");
        this.builder.endBlock();
        this.builder.beginBlock(DocumentBuilder.BlockType.LIST_ITEM, new Attributes());
        this.builder.characters("baz");
        this.builder.endBlock();
        this.builder.endBlock();
        this.builder.endDocument();
        String docbook = this.out.toString();
        TestUtil.println("DocBook: \n" + docbook);
        DocBookDocumentBuilderTest.assertTrue((boolean)docbook.contains("<itemizedlist><listitem><para>foo</para><itemizedlist><listitem><para>bar</para></listitem></itemizedlist><para>foo2</para></listitem><listitem><para>baz</para></listitem></itemizedlist>"));
    }

    public void testDiv() {
        this.builder.beginDocument();
        this.builder.beginBlock(DocumentBuilder.BlockType.DIV, new Attributes());
        this.builder.beginBlock(DocumentBuilder.BlockType.PARAGRAPH, new Attributes());
        this.builder.characters("foo");
        this.builder.endBlock();
        this.builder.beginBlock(DocumentBuilder.BlockType.PARAGRAPH, new Attributes());
        this.builder.characters("bar");
        this.builder.endBlock();
        this.builder.endBlock();
        this.builder.endDocument();
        String docbook = this.out.toString();
        TestUtil.println("DocBook: \n" + docbook);
        DocBookDocumentBuilderTest.assertTrue((boolean)docbook.contains("<book><title></title><chapter><title></title><para>foo</para><para>bar</para></chapter></book>"));
    }

    public void testSpanLink() {
        this.builder.beginDocument();
        this.builder.beginBlock(DocumentBuilder.BlockType.DIV, new Attributes());
        this.builder.beginBlock(DocumentBuilder.BlockType.PARAGRAPH, new Attributes());
        LinkAttributes attributes = new LinkAttributes();
        attributes.setHref("#test1234");
        this.builder.beginSpan(DocumentBuilder.SpanType.LINK, (Attributes)attributes);
        this.builder.beginSpan(DocumentBuilder.SpanType.EMPHASIS, new Attributes());
        this.builder.characters("link text");
        this.builder.endSpan();
        this.builder.endSpan();
        this.builder.endBlock();
        this.builder.endBlock();
        this.builder.endDocument();
        String docbook = this.out.toString();
        TestUtil.println("DocBook: \n" + docbook);
        DocBookDocumentBuilderTest.assertTrue((boolean)docbook.contains("<book><title></title><chapter><title></title><para><link linkend=\"test1234\"><emphasis>link text</emphasis></link></para></chapter></book>"));
    }

    public void testTableClass() {
        this.builder.beginDocument();
        TableAttributes tableAttributes = new TableAttributes();
        tableAttributes.appendCssClass("foo");
        this.builder.beginBlock(DocumentBuilder.BlockType.TABLE, (Attributes)tableAttributes);
        this.builder.beginBlock(DocumentBuilder.BlockType.TABLE_ROW, new Attributes());
        this.builder.beginBlock(DocumentBuilder.BlockType.TABLE_CELL_NORMAL, new Attributes());
        this.builder.characters("text");
        this.builder.endBlock();
        this.builder.endBlock();
        this.builder.endBlock();
        this.builder.endDocument();
        String docbook = this.out.toString();
        TestUtil.println("DocBook: \n" + docbook);
        DocBookDocumentBuilderTest.assertTrue((boolean)docbook.contains("<informaltable role=\"foo\"><tr><td>text</td></tr></informaltable>"));
    }
}

