/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.search;

import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.mylyn.commons.core.ExtensionPointReader;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.internal.tasks.core.ITaskList;
import org.eclipse.mylyn.internal.tasks.ui.search.AbstractSearchHandler;
import org.eclipse.mylyn.internal.tasks.ui.search.AbstractSearchProvider;
import org.eclipse.mylyn.internal.tasks.ui.search.DefaultSearchHandler;
import org.eclipse.mylyn.tasks.core.IRepositoryQuery;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.ui.IWorkbenchWindow;

public class SearchUtil {
    private static final String EXTENSION_SEARCH_PROVIDER = "searchProvider";
    private static final String EXTENSION_SEARCH_HANDLER = "searchHandler";
    private static AbstractSearchProvider provider;

    private static final AbstractSearchProvider getSearchProvider() {
        if (provider != null) {
            return provider;
        }
        ExtensionPointReader reader = new ExtensionPointReader("org.eclipse.mylyn.tasks.ui", EXTENSION_SEARCH_PROVIDER, EXTENSION_SEARCH_PROVIDER, AbstractSearchProvider.class);
        reader.read();
        List providers = reader.getItems();
        if (providers.size() == 0) {
            StatusHandler.log((IStatus)new Status(2, "org.eclipse.mylyn.tasks.ui", "No search provider was registed. Tasks search is not available."));
        } else if (providers.size() > 1) {
            StatusHandler.log((IStatus)new Status(2, "org.eclipse.mylyn.tasks.ui", "More than one search provider was registered."));
        }
        provider = (AbstractSearchProvider)reader.getItem();
        if (provider == null) {
            provider = new NullSearchProvider();
        }
        return provider;
    }

    public static AbstractSearchHandler createSearchHandler() {
        AbstractSearchHandler searchHandler;
        ExtensionPointReader reader = new ExtensionPointReader("org.eclipse.mylyn.tasks.ui", EXTENSION_SEARCH_HANDLER, EXTENSION_SEARCH_HANDLER, AbstractSearchHandler.class);
        reader.read();
        if (reader.getItems().size() > 1) {
            StatusHandler.log((IStatus)new Status(2, "org.eclipse.mylyn.tasks.ui", "More than one task list search handler was registered."));
        }
        if ((searchHandler = (AbstractSearchHandler)reader.getItem()) == null) {
            searchHandler = new DefaultSearchHandler();
        }
        return searchHandler;
    }

    public static boolean supportsTaskSearch() {
        return !(SearchUtil.getSearchProvider() instanceof NullSearchProvider);
    }

    public static void openSearchDialog(IWorkbenchWindow window) {
        SearchUtil.getSearchProvider().openSearchDialog(window);
    }

    public static void runSearchQuery(ITaskList tasklist, TaskRepository repository, IRepositoryQuery repositoryQuery) {
        SearchUtil.getSearchProvider().runSearchQuery(tasklist, repository, repositoryQuery, false);
    }

    public static void runSearchQuery(ITaskList tasklist, TaskRepository repository, IRepositoryQuery repositoryQuery, boolean activateResultView) {
        SearchUtil.getSearchProvider().runSearchQuery(tasklist, repository, repositoryQuery, activateResultView);
    }

    private static class NullSearchProvider
    extends AbstractSearchProvider {
        private NullSearchProvider() {
        }

        @Override
        public void openSearchDialog(IWorkbenchWindow window) {
        }

        @Override
        public void runSearchQuery(ITaskList tasklist, TaskRepository repository, IRepositoryQuery query, boolean activateResultView) {
        }
    }
}

