/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.mylyn.internal.tasks.core.ITasksCoreConstants;
import org.eclipse.mylyn.internal.tasks.core.data.TaskDataManager;
import org.eclipse.mylyn.internal.tasks.ui.Messages;
import org.eclipse.mylyn.internal.tasks.ui.TaskListModifyOperation;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.TaskRepository;

public class RefactorRepositoryUrlOperation
extends TaskListModifyOperation {
    private final String oldUrl;
    private final String newUrl;
    private final TaskRepository repository;

    public RefactorRepositoryUrlOperation(String oldUrl, String newUrl) {
        this(null, oldUrl, newUrl);
    }

    public RefactorRepositoryUrlOperation(TaskRepository repository, String oldUrl, String newUrl) {
        super(ITasksCoreConstants.ROOT_SCHEDULING_RULE);
        Assert.isNotNull((Object)oldUrl);
        Assert.isNotNull((Object)newUrl);
        Assert.isTrue((!oldUrl.equals(newUrl) ? 1 : 0) != 0);
        this.repository = repository;
        this.oldUrl = oldUrl;
        this.newUrl = newUrl;
    }

    @Override
    protected void operations(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
        try {
            monitor.beginTask(Messages.RefactorRepositoryUrlOperation_Repository_URL_update, -1);
            this.refactorOfflineHandles(this.oldUrl, this.newUrl);
            this.getTaskList().refactorRepositoryUrl(this.oldUrl, this.newUrl);
            TasksUiPlugin.getContextStore().refactorRepositoryUrl(this.repository, this.oldUrl, this.newUrl);
            TasksUiPlugin.getTaskActivityMonitor().reloadActivityTime();
        }
        finally {
            monitor.done();
        }
    }

    private void refactorOfflineHandles(String oldRepositoryUrl, String newRepositoryUrl) throws CoreException {
        TaskDataManager taskDataManager = TasksUiPlugin.getTaskDataManager();
        for (ITask task : this.getTaskList().getAllTasks()) {
            if (oldRepositoryUrl.equals(task.getAttribute("outgoingNewRepositoryUrl"))) {
                taskDataManager.refactorRepositoryUrl(task, task.getRepositoryUrl(), newRepositoryUrl);
            }
            if (!task.getRepositoryUrl().equals(oldRepositoryUrl)) continue;
            taskDataManager.refactorRepositoryUrl(task, newRepositoryUrl, newRepositoryUrl);
        }
    }
}

