/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.tests.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import junit.framework.AssertionFailedError;
import org.eclipse.mylyn.commons.sdk.util.CommonTestUtil;

@Deprecated
public class TestUtil {
    public static final String KEY_CREDENTIALS_FILE = "mylyn.credentials";

    public static Credentials readCredentials() {
        return TestUtil.readCredentials(PrivilegeLevel.USER, null);
    }

    public static Credentials readCredentials(PrivilegeLevel level) {
        return TestUtil.readCredentials(level, null);
    }

    public static Credentials readCredentials(PrivilegeLevel level, String realm) {
        Properties properties = new Properties();
        try {
            File file;
            String filename = System.getProperty(KEY_CREDENTIALS_FILE);
            if (filename == null) {
                try {
                    file = TestUtil.getFile(TestUtil.class, "credentials.properties");
                    if (!file.exists()) {
                        throw new AssertionFailedError();
                    }
                }
                catch (AssertionFailedError assertionFailedError) {
                    file = new File(new File(System.getProperty("user.home"), ".mylyn"), "credentials.properties");
                }
            } else {
                file = new File(filename);
            }
            properties.load(new FileInputStream(file));
        }
        catch (Exception e) {
            AssertionFailedError error = new AssertionFailedError("must define credentials in $HOME/.mylyn/credentials.properties");
            error.initCause((Throwable)e);
            throw error;
        }
        String defaultPassword = properties.getProperty("pass");
        realm = realm != null ? String.valueOf(realm) + "." : "";
        switch (level) {
            case ANONYMOUS: {
                return TestUtil.createCredentials(properties, String.valueOf(realm) + "anon.", "", "");
            }
            case GUEST: {
                return TestUtil.createCredentials(properties, String.valueOf(realm) + "guest.", "guest@mylyn.eclipse.org", defaultPassword);
            }
            case USER: {
                return TestUtil.createCredentials(properties, realm, "tests@mylyn.eclipse.org", defaultPassword);
            }
            case READ_ONLY: {
                return TestUtil.createCredentials(properties, realm, "read-only@mylyn.eclipse.org", defaultPassword);
            }
            case ADMIN: {
                return TestUtil.createCredentials(properties, String.valueOf(realm) + "admin.", "admin@mylyn.eclipse.org", null);
            }
        }
        throw new AssertionFailedError("invalid privilege level");
    }

    private static Credentials createCredentials(Properties properties, String prefix, String defaultUsername, String defaultPassword) {
        String username = properties.getProperty(String.valueOf(prefix) + "user");
        String password = properties.getProperty(String.valueOf(prefix) + "pass");
        if (username == null) {
            username = defaultUsername;
        }
        if (password == null) {
            password = defaultPassword;
        }
        if (username == null || password == null) {
            throw new AssertionFailedError("username or password not found in <plug-in dir>/credentials.properties, make sure file is valid");
        }
        return new Credentials(username, password);
    }

    public static File getFile(Object source, String filename) throws IOException {
        return CommonTestUtil.getFile((Object)source, (String)filename);
    }

    @Deprecated
    public static boolean runHeartbeatTestsOnly() {
        return !Boolean.parseBoolean(System.getProperty("org.eclipse.mylyn.tests.all"));
    }

    public static class Credentials {
        public final String username;
        public final String password;

        public Credentials(String username, String password) {
            this.username = username;
            this.password = password;
        }

        public String toString() {
            return String.valueOf(this.getClass().getSimpleName()) + " [username=" + this.username + ",password=" + this.password + "]";
        }

        public String getShortUserName() {
            if (this.username.contains("@")) {
                return this.username.substring(0, this.username.indexOf("@"));
            }
            return this.username;
        }
    }

    public static enum PrivilegeLevel {
        ANONYMOUS,
        GUEST,
        USER,
        ADMIN,
        READ_ONLY;

    }
}

