/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.reviews.ui.compare;

import java.lang.reflect.Field;
import java.util.Iterator;
import org.eclipse.compare.contentmergeviewer.TextMergeViewer;
import org.eclipse.compare.internal.MergeSourceViewer;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextInputListener;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewerExtension5;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.internal.reviews.ui.annotations.CommentAnnotation;
import org.eclipse.mylyn.internal.reviews.ui.annotations.ReviewAnnotationModel;
import org.eclipse.mylyn.internal.reviews.ui.compare.CompareUtil;
import org.eclipse.mylyn.internal.reviews.ui.compare.Direction;
import org.eclipse.mylyn.internal.reviews.ui.compare.ReviewCompareInputListener;
import org.eclipse.mylyn.internal.reviews.ui.compare.ReviewItemSetCompareEditorInput;
import org.eclipse.mylyn.reviews.core.model.IFileItem;
import org.eclipse.mylyn.reviews.core.model.IReviewItem;
import org.eclipse.mylyn.reviews.ui.ReviewBehavior;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.widgets.Display;

public class ReviewCompareAnnotationSupport {
    private static String KEY_ANNOTAION_SUPPORT = ReviewItemSetCompareEditorInput.class.getName();
    private ReviewBehavior behavior;
    private final ReviewAnnotationModel leftAnnotationModel = new ReviewAnnotationModel();
    private ReviewCompareInputListener leftViewerListener;
    private final ReviewAnnotationModel rightAnnotationModel = new ReviewAnnotationModel();
    private ReviewCompareInputListener rightViewerListener;
    private MergeSourceViewer leftSourceViewer;
    private MergeSourceViewer rightSourceViewer;

    public static ReviewCompareAnnotationSupport getAnnotationSupport(Viewer contentViewer) {
        ReviewCompareAnnotationSupport support = (ReviewCompareAnnotationSupport)contentViewer.getData(KEY_ANNOTAION_SUPPORT);
        if (support == null) {
            support = new ReviewCompareAnnotationSupport(contentViewer);
            contentViewer.setData(KEY_ANNOTAION_SUPPORT, (Object)support);
        }
        return support;
    }

    public ReviewCompareAnnotationSupport(Viewer contentViewer) {
        this.install(contentViewer);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ReviewCompareAnnotationSupport other = (ReviewCompareAnnotationSupport)obj;
        if (this.leftAnnotationModel == null ? other.leftAnnotationModel != null : !this.leftAnnotationModel.equals(other.leftAnnotationModel)) {
            return false;
        }
        return !(this.rightAnnotationModel == null ? other.rightAnnotationModel != null : !this.rightAnnotationModel.equals(other.rightAnnotationModel));
    }

    public ReviewBehavior getBehavior() {
        return this.behavior;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.leftAnnotationModel == null ? 0 : this.leftAnnotationModel.hashCode());
        result = 31 * result + (this.rightAnnotationModel == null ? 0 : this.rightAnnotationModel.hashCode());
        return result;
    }

    public void install(Viewer contentViewer) {
        if (contentViewer instanceof TextMergeViewer) {
            TextMergeViewer textMergeViewer = (TextMergeViewer)contentViewer;
            try {
                Class<TextMergeViewer> clazz = TextMergeViewer.class;
                Field declaredField = clazz.getDeclaredField("fLeft");
                declaredField.setAccessible(true);
                this.leftSourceViewer = (MergeSourceViewer)declaredField.get(textMergeViewer);
                declaredField = clazz.getDeclaredField("fRight");
                declaredField.setAccessible(true);
                this.rightSourceViewer = (MergeSourceViewer)declaredField.get(textMergeViewer);
                this.leftViewerListener = this.registerInputListener(this.leftSourceViewer, this.leftAnnotationModel);
                this.rightViewerListener = this.registerInputListener(this.rightSourceViewer, this.rightAnnotationModel);
            }
            catch (Throwable t) {
                StatusHandler.log((IStatus)new Status(2, "org.eclipse.mylyn.reviews.ui", "Could not initialize annotation model for " + Viewer.class.getName(), t));
            }
        }
    }

    public Annotation gotoAnnotation(Direction direction) {
        Position leftPosition = new Position(0, 0);
        Annotation leftAnnotation = this.findAnnotation(this.leftSourceViewer, direction, leftPosition, this.leftAnnotationModel);
        Position rightPosition = new Position(0, 0);
        Annotation rightAnnotation = this.findAnnotation(this.rightSourceViewer, direction, rightPosition, this.rightAnnotationModel);
        if (leftAnnotation == null && rightAnnotation != null) {
            this.selectAndReveal(this.rightSourceViewer, rightPosition);
            return rightAnnotation;
        }
        if (leftAnnotation != null && rightAnnotation == null) {
            this.selectAndReveal(this.leftSourceViewer, leftPosition);
            return leftAnnotation;
        }
        if (leftAnnotation != null && rightAnnotation != null) {
            if (direction == Direction.FORWARDS && leftPosition.offset <= rightPosition.offset || direction == Direction.BACKWARDS && leftPosition.offset >= rightPosition.offset) {
                this.selectAndReveal(this.leftSourceViewer, leftPosition);
                return leftAnnotation;
            }
            this.selectAndReveal(this.rightSourceViewer, rightPosition);
            return rightAnnotation;
        }
        return null;
    }

    private void selectAndReveal(MergeSourceViewer sourceViewer, Position position) {
        StyledText widget = sourceViewer.getSourceViewer().getTextWidget();
        widget.setRedraw(false);
        this.adjustHighlightRange(sourceViewer.getSourceViewer(), position.offset, position.length);
        sourceViewer.getSourceViewer().revealRange(position.offset, position.length);
        sourceViewer.getSourceViewer().setSelectedRange(position.offset, position.length);
        widget.setRedraw(true);
    }

    protected void adjustHighlightRange(SourceViewer sourceViewer, int offset, int length) {
        if (sourceViewer instanceof ITextViewerExtension5) {
            ITextViewerExtension5 extension = (ITextViewerExtension5)sourceViewer;
            extension.exposeModelRange((IRegion)new Region(offset, length));
        } else if (!this.isVisible(sourceViewer, offset, length)) {
            sourceViewer.resetVisibleRegion();
        }
    }

    private boolean isVisible(SourceViewer viewer, int offset, int length) {
        if (viewer instanceof ITextViewerExtension5) {
            ITextViewerExtension5 extension = (ITextViewerExtension5)viewer;
            IRegion overlap = extension.modelRange2WidgetRange((IRegion)new Region(offset, length));
            return overlap != null;
        }
        return viewer.overlapsWithVisibleRegion(offset, length);
    }

    public void setReviewItem(IFileItem item, ReviewBehavior behavior) {
        this.leftAnnotationModel.setItem((IReviewItem)item.getBase(), behavior);
        this.rightAnnotationModel.setItem((IReviewItem)item.getTarget(), behavior);
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    if (ReviewCompareAnnotationSupport.this.leftViewerListener != null) {
                        ReviewCompareAnnotationSupport.this.leftViewerListener.forceCustomAnnotationHover();
                    }
                    if (ReviewCompareAnnotationSupport.this.rightViewerListener != null) {
                        ReviewCompareAnnotationSupport.this.rightViewerListener.forceCustomAnnotationHover();
                    }
                }
                catch (Exception e) {
                    StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.reviews.ui", "Error attaching annotation hover", (Throwable)e));
                }
            }
        });
    }

    private ReviewCompareInputListener registerInputListener(MergeSourceViewer sourceViewer, ReviewAnnotationModel annotationModel) {
        ReviewCompareInputListener listener = new ReviewCompareInputListener(sourceViewer, annotationModel);
        SourceViewer viewer = CompareUtil.getSourceViewer(sourceViewer);
        if (viewer != null) {
            viewer.addTextInputListener((ITextInputListener)listener);
        }
        listener.registerContextMenu();
        return listener;
    }

    protected Annotation findAnnotation(MergeSourceViewer viewer, Direction direction, Position annotationPosition, ReviewAnnotationModel annotationModel) {
        if (viewer == null) {
            return null;
        }
        ITextSelection selection = (ITextSelection)viewer.getSourceViewer().getSelectionProvider().getSelection();
        int offset = selection.getOffset();
        int length = selection.getLength();
        CommentAnnotation nextAnnotation = null;
        Position nextAnnotationPosition = null;
        CommentAnnotation containingAnnotation = null;
        Position containingAnnotationPosition = null;
        boolean currentAnnotation = false;
        IDocument document = annotationModel.getDocument();
        if (document == null) {
            return null;
        }
        int endOfDocument = document.getLength();
        int distance = Integer.MAX_VALUE;
        Iterator<CommentAnnotation> e = annotationModel.getAnnotationIterator();
        while (e.hasNext()) {
            CommentAnnotation a = e.next();
            Position p = a.getPosition();
            if (p == null) continue;
            if (direction == Direction.FORWARDS && p.offset == offset || direction == Direction.BACKWARDS && p.offset + p.getLength() == offset + length) {
                if (containingAnnotation != null && (direction != Direction.FORWARDS || p.length < containingAnnotationPosition.length) && (direction != Direction.BACKWARDS || p.length < containingAnnotationPosition.length)) continue;
                containingAnnotation = a;
                containingAnnotationPosition = p;
                currentAnnotation = p.length == length;
                continue;
            }
            int currentDistance = 0;
            if (direction == Direction.FORWARDS) {
                currentDistance = p.getOffset() - offset;
                if (currentDistance < 0) {
                    currentDistance = endOfDocument + currentDistance;
                }
                if (currentDistance >= distance && (currentDistance != distance || p.length >= nextAnnotationPosition.length)) continue;
                distance = currentDistance;
                nextAnnotation = a;
                nextAnnotationPosition = p;
                continue;
            }
            currentDistance = offset + length - (p.getOffset() + p.length);
            if (currentDistance < 0) {
                currentDistance = endOfDocument + currentDistance;
            }
            if (currentDistance >= distance && (currentDistance != distance || p.length >= nextAnnotationPosition.length)) continue;
            distance = currentDistance;
            nextAnnotation = a;
            nextAnnotationPosition = p;
        }
        if (!(containingAnnotationPosition == null || currentAnnotation && nextAnnotation != null)) {
            annotationPosition.setOffset(containingAnnotationPosition.getOffset());
            annotationPosition.setLength(containingAnnotationPosition.getLength());
            return containingAnnotation;
        }
        if (nextAnnotationPosition != null) {
            annotationPosition.setOffset(nextAnnotationPosition.getOffset());
            annotationPosition.setLength(nextAnnotationPosition.getLength());
        }
        return nextAnnotation;
    }
}

