/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.trac.tests.ui;

import junit.framework.TestCase;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.mylyn.commons.net.AuthenticationCredentials;
import org.eclipse.mylyn.commons.net.AuthenticationType;
import org.eclipse.mylyn.internal.tasks.ui.wizards.EditRepositoryWizard;
import org.eclipse.mylyn.internal.trac.core.TracRepositoryConnector;
import org.eclipse.mylyn.internal.trac.core.client.ITracClient;
import org.eclipse.mylyn.internal.trac.ui.wizard.TracRepositorySettingsPage;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.wizards.AbstractRepositorySettingsPage;
import org.eclipse.mylyn.tests.util.TasksUiTestUtil;
import org.eclipse.mylyn.trac.tests.support.TracFixture;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class TracRepositorySettingsPageTest
extends TestCase {
    private MyTracRepositorySettingsPage page;
    private TracRepositorySettingsPage.TracValidator validator;
    private WizardDialog dialog;
    private TracFixture fixture;

    protected void setUp() throws Exception {
        super.setUp();
        this.page = new MyTracRepositorySettingsPage(null);
        Wizard wizard = new Wizard(){

            public boolean performFinish() {
                return true;
            }
        };
        wizard.addPage((IWizardPage)this.page);
        this.dialog = new WizardDialog(null, (IWizard)wizard);
        this.dialog.create();
        this.fixture = TracFixture.current();
    }

    protected void tearDown() throws Exception {
        if (this.dialog != null) {
            this.dialog.close();
        }
    }

    protected void initialize(TracFixture fixture) throws Exception {
        TaskRepository repository = fixture.repository();
        this.page.setAnonymous(false);
        this.page.setUrl(repository.getRepositoryUrl());
        AuthenticationCredentials credentials = repository.getCredentials(AuthenticationType.REPOSITORY);
        this.page.setUserId(credentials == null ? null : credentials.getUserName());
        this.page.setPassword(credentials == null ? null : credentials.getPassword());
        this.page.setTracVersion(fixture.getAccessMode());
        MyTracRepositorySettingsPage myTracRepositorySettingsPage = this.page;
        ((Object)((Object)myTracRepositorySettingsPage)).getClass();
        this.validator = new TracRepositorySettingsPage.TracValidator((TracRepositorySettingsPage)myTracRepositorySettingsPage, this.page.createTaskRepository(), fixture.getAccessMode());
    }

    public void testValidate() throws Exception {
        this.initialize(this.fixture);
        this.validator.run((IProgressMonitor)new NullProgressMonitor());
        TracRepositorySettingsPageTest.assertNull((Object)this.validator.getResult());
        TracRepositorySettingsPageTest.assertNull((Object)this.validator.getStatus());
        this.page.applyValidatorResult((AbstractRepositorySettingsPage.Validator)this.validator);
        TracRepositorySettingsPageTest.assertEquals((Object)this.fixture.getAccessMode(), (Object)this.page.getTracVersion());
        TracRepositorySettingsPageTest.assertEquals((String)"Authentication credentials are valid.", (String)this.page.getMessage());
    }

    public void testValidateAutomaticUser() throws Exception {
        this.initialize(this.fixture);
        this.page.setTracVersion(null);
        MyTracRepositorySettingsPage myTracRepositorySettingsPage = this.page;
        ((Object)((Object)myTracRepositorySettingsPage)).getClass();
        this.validator = new TracRepositorySettingsPage.TracValidator((TracRepositorySettingsPage)myTracRepositorySettingsPage, this.page.createTaskRepository(), null);
        this.validator.run((IProgressMonitor)new NullProgressMonitor());
        TracRepositorySettingsPageTest.assertEquals((Object)ITracClient.Version.XML_RPC, (Object)this.validator.getResult());
        TracRepositorySettingsPageTest.assertNull((Object)this.validator.getStatus());
        this.page.applyValidatorResult((AbstractRepositorySettingsPage.Validator)this.validator);
        TracRepositorySettingsPageTest.assertEquals((Object)ITracClient.Version.XML_RPC, (Object)this.page.getTracVersion());
        TracRepositorySettingsPageTest.assertEquals((String)"Authentication credentials are valid.", (String)this.page.getMessage());
    }

    public void testValidateAutomaticAnonymous() throws Exception {
        this.initialize(this.fixture);
        this.page.setUserId("");
        this.page.setPassword("");
        this.page.setTracVersion(null);
        MyTracRepositorySettingsPage myTracRepositorySettingsPage = this.page;
        ((Object)((Object)myTracRepositorySettingsPage)).getClass();
        this.validator = new TracRepositorySettingsPage.TracValidator((TracRepositorySettingsPage)myTracRepositorySettingsPage, this.page.createTaskRepository(), null);
        this.validator.run((IProgressMonitor)new NullProgressMonitor());
        TracRepositorySettingsPageTest.assertEquals((Object)ITracClient.Version.TRAC_0_9, (Object)this.validator.getResult());
        TracRepositorySettingsPageTest.assertNotNull((Object)this.validator.getStatus());
        this.page.applyValidatorResult((AbstractRepositorySettingsPage.Validator)this.validator);
        TracRepositorySettingsPageTest.assertEquals((Object)ITracClient.Version.TRAC_0_9, (Object)this.page.getTracVersion());
        TracRepositorySettingsPageTest.assertEquals((String)"Authentication credentials are valid. Note: Insufficient permissions for XML-RPC access, falling back to web access.", (String)this.page.getMessage());
    }

    public void testValidateInvalid() throws Exception {
        this.initialize(this.fixture);
        this.page.setUrl("http://mylyn.org/doesnotexist");
        this.page.setTracVersion(null);
        MyTracRepositorySettingsPage myTracRepositorySettingsPage = this.page;
        ((Object)((Object)myTracRepositorySettingsPage)).getClass();
        this.validator = new TracRepositorySettingsPage.TracValidator((TracRepositorySettingsPage)myTracRepositorySettingsPage, this.page.createTaskRepository(), null);
        try {
            this.validator.run((IProgressMonitor)new NullProgressMonitor());
            TracRepositorySettingsPageTest.fail((String)"Expected CoreException");
        }
        catch (CoreException e) {
            this.validator.setStatus(e.getStatus());
        }
        this.page.applyValidatorResult((AbstractRepositorySettingsPage.Validator)this.validator);
        TracRepositorySettingsPageTest.assertNull((Object)this.page.getTracVersion());
        TracRepositorySettingsPageTest.assertEquals((int)3, (int)this.page.getMessageType());
    }

    public void testValidUrl() throws Exception {
        TracRepositorySettingsPageTest.assertFalse((boolean)this.page.isValidUrl(""));
        TracRepositorySettingsPageTest.assertFalse((boolean)this.page.isValidUrl("http:/google.com"));
        TracRepositorySettingsPageTest.assertFalse((boolean)this.page.isValidUrl("http:/google.com/"));
        TracRepositorySettingsPageTest.assertFalse((boolean)this.page.isValidUrl("http://google.com/"));
        TracRepositorySettingsPageTest.assertFalse((boolean)this.page.isValidUrl("http://google.com/foo /space"));
        TracRepositorySettingsPageTest.assertTrue((boolean)this.page.isValidUrl("http://google.com"));
        TracRepositorySettingsPageTest.assertTrue((boolean)this.page.isValidUrl("https://google.com"));
        TracRepositorySettingsPageTest.assertTrue((boolean)this.page.isValidUrl("http://mylyn.org/trac30"));
        TracRepositorySettingsPageTest.assertTrue((boolean)this.page.isValidUrl("http://www.mylyn.org/trac30"));
    }

    public void testClientManagerChangeTaskRepositorySettings() throws Exception {
        TracRepositoryConnector connector = this.fixture.connector();
        TaskRepository repository = this.fixture.singleRepository();
        repository.setVersion(ITracClient.Version.TRAC_0_9.name());
        ITracClient client = connector.getClientManager().getTracClient(repository);
        TracRepositorySettingsPageTest.assertEquals((Object)ITracClient.Version.TRAC_0_9, (Object)client.getAccessMode());
        TasksUiTestUtil.ensureTasksUiInitialization();
        EditRepositoryWizard wizard = new EditRepositoryWizard(repository);
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        WizardDialog dialog = new WizardDialog(shell, (IWizard)wizard);
        try {
            dialog.create();
            ((TracRepositorySettingsPage)wizard.getSettingsPage()).setTracVersion(ITracClient.Version.XML_RPC);
            TracRepositorySettingsPageTest.assertTrue((boolean)wizard.performFinish());
            client = connector.getClientManager().getTracClient(repository);
            TracRepositorySettingsPageTest.assertEquals((Object)ITracClient.Version.XML_RPC, (Object)client.getAccessMode());
        }
        finally {
            dialog.close();
        }
    }

    private static class MyTracRepositorySettingsPage
    extends TracRepositorySettingsPage {
        public MyTracRepositorySettingsPage(TaskRepository taskRepository) {
            super(taskRepository);
        }

        protected void applyValidatorResult(AbstractRepositorySettingsPage.Validator validator) {
            if (validator.getStatus() == null) {
                validator.setStatus(Status.OK_STATUS);
            }
            super.applyValidatorResult(validator);
        }

        protected boolean isValidUrl(String name) {
            return super.isValidUrl(name);
        }
    }
}

