/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.trac.tests.client;

import junit.framework.TestCase;
import org.eclipse.mylyn.commons.net.AbstractWebLocation;
import org.eclipse.mylyn.commons.net.WebLocation;
import org.eclipse.mylyn.commons.repositories.core.auth.UserCredentials;
import org.eclipse.mylyn.commons.sdk.util.CommonTestUtil;
import org.eclipse.mylyn.internal.trac.core.TracClientFactory;
import org.eclipse.mylyn.internal.trac.core.client.ITracClient;
import org.eclipse.mylyn.internal.trac.core.client.TracException;
import org.eclipse.mylyn.internal.trac.core.client.TracLoginException;
import org.eclipse.mylyn.internal.trac.core.client.TracWebClient;
import org.eclipse.mylyn.internal.trac.core.client.TracXmlRpcClient;
import org.eclipse.mylyn.trac.tests.support.TracFixture;

public class TracClientFactoryTest
extends TestCase {
    private TracFixture fixture;

    protected void setUp() throws Exception {
        this.fixture = TracFixture.current();
    }

    public void testCreateClient() throws Exception {
        WebLocation location = new WebLocation(this.fixture.getRepositoryUrl(), "user", "password");
        ITracClient client = TracClientFactory.createClient((AbstractWebLocation)location, (ITracClient.Version)this.fixture.getAccessMode());
        if (this.fixture.getAccessMode() == ITracClient.Version.TRAC_0_9) {
            TracClientFactoryTest.assertTrue((boolean)(client instanceof TracWebClient));
        } else {
            TracClientFactoryTest.assertTrue((boolean)(client instanceof TracXmlRpcClient));
        }
    }

    public void testCreateClientNull() throws Exception {
        WebLocation location = new WebLocation(this.fixture.getRepositoryUrl(), "user", "password");
        ITracClient client = TracClientFactory.createClient((AbstractWebLocation)location, null);
        TracClientFactoryTest.assertEquals((Object)ITracClient.Version.XML_RPC, (Object)client.getAccessMode());
    }

    public void testProbeClient() throws Exception {
        String url = this.fixture.getRepositoryUrl();
        UserCredentials credentials = CommonTestUtil.getCredentials((CommonTestUtil.PrivilegeLevel)CommonTestUtil.PrivilegeLevel.USER);
        WebLocation location = new WebLocation(url, credentials.getUserName(), credentials.getPassword());
        ITracClient.Version version = TracClientFactory.probeClient((AbstractWebLocation)location);
        if (this.fixture.isXmlRpcEnabled()) {
            TracClientFactoryTest.assertEquals((Object)ITracClient.Version.XML_RPC, (Object)version);
        }
    }

    public void testProbeClientNoCredentials() throws Exception {
        String url = this.fixture.getRepositoryUrl();
        WebLocation location = new WebLocation(url, "", "");
        try {
            ITracClient.Version version = TracClientFactory.probeClient((AbstractWebLocation)location);
            if (this.fixture.requiresAuthentication()) {
                TracClientFactoryTest.fail((String)"Expected TracLoginException");
            }
            TracClientFactoryTest.assertEquals((Object)ITracClient.Version.TRAC_0_9, (Object)version);
        }
        catch (TracLoginException e) {
            if (this.fixture.requiresAuthentication()) {
                return;
            }
            throw e;
        }
    }

    public void testProbeClientInvalidCredentials() throws Exception {
        try {
            WebLocation location = new WebLocation(this.fixture.getRepositoryUrl(), "invaliduser", "password");
            ITracClient.Version version = TracClientFactory.probeClient((AbstractWebLocation)location);
            TracClientFactoryTest.fail((String)("Expected TracLoginException, got " + version));
        }
        catch (TracLoginException tracLoginException) {}
    }

    public void testProbeClientInvalidLocation() throws Exception {
        try {
            WebLocation location = new WebLocation(String.valueOf(this.fixture.getRepositoryUrl()) + "/nonexistant", "", "");
            ITracClient.Version version = TracClientFactory.probeClient((AbstractWebLocation)location);
            TracClientFactoryTest.fail((String)("Expected TracException, got " + version));
        }
        catch (TracException tracException) {}
    }
}

