/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.ide.ui;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.context.ui.AbstractFocusViewAction;
import org.eclipse.mylyn.context.ui.InterestFilter;
import org.eclipse.mylyn.internal.ide.ui.MarkerInterestFilter;
import org.eclipse.mylyn.internal.ide.ui.MarkerViewLabelProvider;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.internal.views.markers.ExtendedMarkersView;
import org.eclipse.ui.internal.views.markers.MarkersTreeViewer;
import org.eclipse.ui.views.markers.internal.TableViewLabelProvider;

public abstract class AbstractFocusMarkerViewAction
extends AbstractFocusViewAction {
    private StructuredViewer cachedViewer = null;

    public AbstractFocusMarkerViewAction() {
        super((InterestFilter)new MarkerInterestFilter(), true, true, false);
    }

    public AbstractFocusMarkerViewAction(InterestFilter interestFilter, boolean manageViewer, boolean manageFilters, boolean manageLinking) {
        super(interestFilter, manageFilters, manageFilters, manageLinking);
    }

    protected void updateMarkerViewLabelProvider(StructuredViewer viewer) {
        IBaseLabelProvider currentProvider;
        if (viewer != null && (currentProvider = viewer.getLabelProvider()) instanceof TableViewLabelProvider && !(currentProvider instanceof MarkerViewLabelProvider)) {
            viewer.setLabelProvider((IBaseLabelProvider)new MarkerViewLabelProvider((TableViewLabelProvider)currentProvider));
        }
    }

    public List<StructuredViewer> getViewers() {
        ArrayList<StructuredViewer> viewers = new ArrayList<StructuredViewer>();
        if (this.cachedViewer == null) {
            try {
                IViewPart viewPart = super.getPartForAction();
                if (viewPart != null) {
                    Class<ExtendedMarkersView> clazz = ExtendedMarkersView.class;
                    Field field = clazz.getDeclaredField("viewer");
                    field.setAccessible(true);
                    this.cachedViewer = (MarkersTreeViewer)field.get(viewPart);
                    if (this.cachedViewer != null && !this.cachedViewer.getControl().isDisposed()) {
                        this.updateMarkerViewLabelProvider(this.cachedViewer);
                    }
                }
            }
            catch (Exception e) {
                StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.ide", "Could not get problems view viewer", (Throwable)e));
            }
        }
        if (this.cachedViewer != null) {
            viewers.add(this.cachedViewer);
        }
        return viewers;
    }

    public void update() {
        super.update();
        this.cachedViewer = null;
        for (StructuredViewer viewer : this.getViewers()) {
            TableViewer tableViewer;
            if (!(viewer instanceof TableViewer) || (tableViewer = (TableViewer)viewer).getLabelProvider() instanceof MarkerViewLabelProvider) continue;
            tableViewer.setLabelProvider((IBaseLabelProvider)new MarkerViewLabelProvider((TableViewLabelProvider)tableViewer.getLabelProvider()));
        }
    }
}

