/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.tasks.tests.ui;

import junit.framework.TestCase;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.mylyn.commons.workbench.WorkbenchUtil;
import org.eclipse.mylyn.internal.tasks.core.data.TaskDataState;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.internal.tasks.ui.editors.BooleanAttributeEditor;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.data.ITaskDataWorkingCopy;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.core.data.TaskAttributeMapper;
import org.eclipse.mylyn.tasks.core.data.TaskData;
import org.eclipse.mylyn.tasks.core.data.TaskDataModel;
import org.eclipse.mylyn.tasks.tests.connector.MockTask;
import org.eclipse.mylyn.tasks.ui.editors.AbstractAttributeEditor;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class AttributeEditorTest
extends TestCase {
    private TaskRepository repository;
    private TaskData taskData;
    private TaskDataModel manager;

    protected void setUp() throws Exception {
        this.repository = new TaskRepository("mock", "http://mockrepository.test");
        TasksUiPlugin.getRepositoryManager().addRepository(this.repository);
        this.taskData = new TaskData(new TaskAttributeMapper(this.repository), "mock", "http://mockrepository.test", "1");
        this.manager = this.createManager();
    }

    public void testDetermineNotRequired() throws Exception {
        TaskAttribute attribute = new TaskAttribute(this.taskData.getRoot(), "not.required.field");
        MockAttributeEditor editor = new MockAttributeEditor(this.manager, attribute);
        AttributeEditorTest.assertFalse((boolean)editor.needsValue());
        attribute.setValue("");
        AttributeEditorTest.assertFalse((boolean)editor.needsValue());
        attribute.setValue("abc");
        AttributeEditorTest.assertFalse((boolean)editor.needsValue());
    }

    public void testDetermineRequired() throws Exception {
        TaskAttribute attribute = new TaskAttribute(this.taskData.getRoot(), "a.required.field");
        attribute.getMetaData().setRequired(true);
        MockAttributeEditor editor = new MockAttributeEditor(this.manager, attribute);
        AttributeEditorTest.assertTrue((boolean)editor.needsValue());
        attribute.setValue("");
        AttributeEditorTest.assertTrue((boolean)editor.needsValue());
        attribute.setValue("abc");
        AttributeEditorTest.assertFalse((boolean)editor.needsValue());
    }

    public void testDecorateRequired() throws Exception {
        final StringBuilder eventLog = new StringBuilder();
        TaskAttribute attribute = new TaskAttribute(this.taskData.getRoot(), "a.required.field");
        MockAttributeEditor editor = new MockAttributeEditor(this, this.manager, attribute){

            protected void decorateRequired() {
                eventLog.append("decorateRequired");
            }
        };
        AttributeEditorTest.assertEquals((String)"", (String)eventLog.toString());
        Color someColor = WorkbenchUtil.getShell().getDisplay().getSystemColor(13);
        editor.decorate(someColor);
        AttributeEditorTest.assertEquals((String)"", (String)eventLog.toString());
        attribute.getMetaData().setRequired(true);
        editor.decorate(someColor);
        AttributeEditorTest.assertEquals((String)"decorateRequired", (String)eventLog.toString());
        eventLog.setLength(0);
        attribute.getMetaData().setRequired(false);
        editor.decorate(someColor);
        AttributeEditorTest.assertEquals((String)"", (String)eventLog.toString());
    }

    public void testDecorateRequiredOnChange() throws Exception {
        final StringBuilder eventLog = new StringBuilder();
        TaskAttribute attribute = new TaskAttribute(this.taskData.getRoot(), "a.required.field");
        MockAttributeEditor editor = new MockAttributeEditor(this, this.manager, attribute){

            protected void decorateRequired() {
                eventLog.append("decorateRequired");
            }

            @Override
            public boolean needsValue() {
                eventLog.append("asked");
                return super.needsValue();
            }
        };
        AttributeEditorTest.assertEquals((String)"", (String)eventLog.toString());
        Color someColor = WorkbenchUtil.getShell().getDisplay().getSystemColor(13);
        attribute.getMetaData().setRequired(true);
        editor.decorate(someColor);
        AttributeEditorTest.assertEquals((String)"askeddecorateRequired", (String)eventLog.toString());
        eventLog.setLength(0);
        attribute.setValue("someValue");
        this.manager.attributeChanged(attribute);
        AttributeEditorTest.assertEquals((String)"asked", (String)eventLog.toString());
    }

    public void testDecorateRequiredReal() throws Exception {
        TaskAttribute attribute = new TaskAttribute(this.taskData.getRoot(), "a.required.field");
        MockAttributeEditor editor = new MockAttributeEditor(this.manager, attribute);
        Color someColor = WorkbenchUtil.getShell().getDisplay().getSystemColor(13);
        attribute.getMetaData().setRequired(true);
        editor.decorate(someColor);
        attribute.getMetaData().setRequired(false);
        this.manager.attributeChanged(attribute);
    }

    public void testNoDecorateWithoutLabel() throws Exception {
        TaskAttribute attribute = new TaskAttribute(this.taskData.getRoot(), "a.required.field");
        MockAttributeEditor editor = new MockAttributeEditor(this, this.manager, attribute){

            @Override
            public Label getLabelControl() {
                return null;
            }
        };
        Color someColor = WorkbenchUtil.getShell().getDisplay().getSystemColor(13);
        attribute.getMetaData().setRequired(true);
        editor.decorate(someColor);
        attribute.getMetaData().setRequired(false);
        this.manager.attributeChanged(attribute);
    }

    public void testBooleanAttribute() throws Exception {
        TaskAttribute attribute = new TaskAttribute(this.taskData.getRoot(), "a.required.boolean");
        attribute.getMetaData().setType("boolean");
        attribute.getMetaData().setRequired(true);
        MockBooleanAttributeEditor editor = new MockBooleanAttributeEditor(this.manager, attribute);
        AttributeEditorTest.assertFalse((boolean)editor.needsValue());
    }

    private TaskDataModel createManager() throws Exception {
        MockTask task = new MockTask("taskId");
        TaskDataState state = new TaskDataState("kind", "url", "taskId");
        state.setEditsData(this.taskData);
        state.setLocalTaskData(this.taskData);
        TaskDataModel manager = new TaskDataModel(this.repository, (ITask)task, (ITaskDataWorkingCopy)state);
        return manager;
    }

    private class MockAttributeEditor
    extends AbstractAttributeEditor {
        private MockAttributeEditor(TaskDataModel manager, TaskAttribute taskAttribute) throws CoreException {
            super(manager, taskAttribute);
            this.setControl((Control)new Shell());
        }

        public void createControl(Composite parent, FormToolkit toolkit) {
        }

        public boolean needsValue() {
            return super.needsValue();
        }

        public void refresh() {
        }

        public Label getLabelControl() {
            return new Label((Composite)new Shell(), 0);
        }

        protected boolean shouldAutoRefresh() {
            return true;
        }

        /* synthetic */ MockAttributeEditor(TaskDataModel taskDataModel, TaskAttribute taskAttribute, MockAttributeEditor mockAttributeEditor, MockAttributeEditor mockAttributeEditor2) throws CoreException {
            this(taskDataModel, taskAttribute);
        }
    }

    private class MockBooleanAttributeEditor
    extends BooleanAttributeEditor {
        public MockBooleanAttributeEditor(TaskDataModel manager, TaskAttribute taskAttribute) {
            super(manager, taskAttribute);
        }

        public boolean needsValue() {
            return super.needsValue();
        }
    }
}

