/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.tasks.tests;

import java.util.Set;
import junit.framework.TestCase;
import org.eclipse.mylyn.internal.tasks.core.AbstractTask;
import org.eclipse.mylyn.internal.tasks.core.AbstractTaskCategory;
import org.eclipse.mylyn.internal.tasks.core.AbstractTaskContainer;
import org.eclipse.mylyn.internal.tasks.core.LocalTask;
import org.eclipse.mylyn.internal.tasks.core.RepositoryQuery;
import org.eclipse.mylyn.internal.tasks.core.TaskCategory;
import org.eclipse.mylyn.internal.tasks.core.TaskList;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.tests.connector.MockRepositoryQuery;
import org.eclipse.mylyn.tasks.tests.connector.MockTask;

public class TaskListTest
extends TestCase {
    private TaskList taskList;

    protected void setUp() throws Exception {
        this.taskList = new TaskList();
    }

    public void testGetCategories() {
        this.taskList.addCategory(new TaskCategory("a"));
        TaskListTest.assertEquals((int)2, (int)this.taskList.getCategories().size());
    }

    public void testLocalSubTaskAdd() {
        LocalTask task = new LocalTask("1", "summary");
        LocalTask subTask = new LocalTask("2", "subTask");
        this.taskList.addTask((ITask)task);
        this.taskList.addTask((ITask)subTask, (AbstractTaskContainer)task);
        TaskListTest.assertEquals((int)1, (int)task.getChildren().size());
        TaskListTest.assertEquals((Object)subTask, task.getChildren().iterator().next());
    }

    public void testLocalTaskAddToSelf() {
        LocalTask task = new LocalTask("1", "summary");
        this.taskList.addTask((ITask)task);
        TaskListTest.assertFalse((boolean)this.taskList.addTask((ITask)task, (AbstractTaskContainer)task));
        TaskListTest.assertEquals((int)0, (int)task.getChildren().size());
        TaskListTest.assertEquals((int)1, (int)task.getParentContainers().size());
    }

    public void testLocalSubTaskAddCycle() {
        LocalTask task = new LocalTask("1", "summary");
        LocalTask subTask = new LocalTask("2", "subTask");
        this.taskList.addTask((ITask)task);
        this.taskList.addTask((ITask)subTask, (AbstractTaskContainer)task);
        this.taskList.addTask((ITask)task, (AbstractTaskContainer)subTask);
        TaskListTest.assertEquals((int)2, (int)this.taskList.getAllTasks().size());
        TaskListTest.assertEquals((int)1, (int)this.taskList.getCategories().size());
        TaskListTest.assertEquals((int)1, (int)((AbstractTaskCategory)this.taskList.getCategories().iterator().next()).getChildren().size());
        TaskListTest.assertEquals((int)1, (int)task.getChildren().size());
        TaskListTest.assertEquals((int)0, (int)subTask.getChildren().size());
        TaskListTest.assertEquals((Object)subTask, task.getChildren().iterator().next());
    }

    public void testLocalSubTaskAddDeepCycle() {
        LocalTask task = new LocalTask("1", "summary");
        LocalTask subTask1 = new LocalTask("2", "subTask");
        LocalTask subTask2 = new LocalTask("3", "subTask");
        LocalTask subTask3 = new LocalTask("4", "subTask");
        LocalTask subTask4 = new LocalTask("5", "subTask");
        LocalTask subTask5 = new LocalTask("6", "subTask");
        LocalTask subTask6 = new LocalTask("7", "subTask");
        LocalTask subTask7 = new LocalTask("8", "subTask");
        LocalTask subTask8 = new LocalTask("9", "subTask");
        LocalTask subTask9 = new LocalTask("10", "subTask");
        LocalTask subTask10 = new LocalTask("11", "subTask");
        this.taskList.addTask((ITask)task);
        this.taskList.addTask((ITask)subTask1, (AbstractTaskContainer)task);
        this.taskList.addTask((ITask)subTask2, (AbstractTaskContainer)subTask1);
        this.taskList.addTask((ITask)subTask3, (AbstractTaskContainer)subTask2);
        this.taskList.addTask((ITask)subTask4, (AbstractTaskContainer)subTask3);
        this.taskList.addTask((ITask)subTask5, (AbstractTaskContainer)subTask4);
        this.taskList.addTask((ITask)subTask6, (AbstractTaskContainer)subTask5);
        this.taskList.addTask((ITask)subTask7, (AbstractTaskContainer)subTask6);
        this.taskList.addTask((ITask)subTask8, (AbstractTaskContainer)subTask7);
        this.taskList.addTask((ITask)subTask9, (AbstractTaskContainer)subTask8);
        this.taskList.addTask((ITask)subTask10, (AbstractTaskContainer)subTask9);
        this.taskList.addTask((ITask)task, (AbstractTaskContainer)subTask10);
        TaskListTest.assertEquals((int)11, (int)this.taskList.getAllTasks().size());
        TaskListTest.assertEquals((int)1, (int)this.taskList.getCategories().size());
        TaskListTest.assertEquals((int)1, (int)((AbstractTaskCategory)this.taskList.getCategories().iterator().next()).getChildren().size());
        TaskListTest.assertEquals((int)1, (int)task.getChildren().size());
        TaskListTest.assertEquals((Object)subTask1, task.getChildren().iterator().next());
        TaskListTest.assertEquals((int)1, (int)subTask1.getChildren().size());
        TaskListTest.assertEquals((Object)subTask2, subTask1.getChildren().iterator().next());
        TaskListTest.assertEquals((int)1, (int)subTask2.getChildren().size());
        TaskListTest.assertEquals((Object)subTask3, subTask2.getChildren().iterator().next());
        TaskListTest.assertEquals((int)1, (int)subTask3.getChildren().size());
        TaskListTest.assertEquals((Object)subTask4, subTask3.getChildren().iterator().next());
        TaskListTest.assertEquals((int)1, (int)subTask4.getChildren().size());
        TaskListTest.assertEquals((Object)subTask5, subTask4.getChildren().iterator().next());
        TaskListTest.assertEquals((int)1, (int)subTask5.getChildren().size());
        TaskListTest.assertEquals((Object)subTask6, subTask5.getChildren().iterator().next());
        TaskListTest.assertEquals((int)1, (int)subTask6.getChildren().size());
        TaskListTest.assertEquals((Object)subTask7, subTask6.getChildren().iterator().next());
        TaskListTest.assertEquals((int)1, (int)subTask7.getChildren().size());
        TaskListTest.assertEquals((Object)subTask8, subTask7.getChildren().iterator().next());
        TaskListTest.assertEquals((int)1, (int)subTask8.getChildren().size());
        TaskListTest.assertEquals((Object)subTask9, subTask8.getChildren().iterator().next());
        TaskListTest.assertEquals((int)1, (int)subTask9.getChildren().size());
        TaskListTest.assertEquals((Object)subTask10, subTask9.getChildren().iterator().next());
        TaskListTest.assertEquals((int)0, (int)subTask10.getChildren().size());
    }

    public void testLocalSubTaskAddMaxSubTaskDepthDeepCycle() {
        LocalTask task = new LocalTask("1", "summary");
        LocalTask subTask1 = new LocalTask("2", "subTask");
        LocalTask subTask2 = new LocalTask("3", "subTask");
        LocalTask subTask3 = new LocalTask("4", "subTask");
        LocalTask subTask4 = new LocalTask("5", "subTask");
        LocalTask subTask5 = new LocalTask("6", "subTask");
        LocalTask subTask6 = new LocalTask("7", "subTask");
        LocalTask subTask7 = new LocalTask("8", "subTask");
        LocalTask subTask8 = new LocalTask("9", "subTask");
        LocalTask subTask9 = new LocalTask("10", "subTask");
        LocalTask subTask10 = new LocalTask("11", "subTask");
        LocalTask subTask11 = new LocalTask("12", "subTask");
        this.taskList.addTask((ITask)task);
        this.taskList.addTask((ITask)subTask1, (AbstractTaskContainer)task);
        this.taskList.addTask((ITask)subTask2, (AbstractTaskContainer)subTask1);
        this.taskList.addTask((ITask)subTask3, (AbstractTaskContainer)subTask2);
        this.taskList.addTask((ITask)subTask4, (AbstractTaskContainer)subTask3);
        this.taskList.addTask((ITask)subTask5, (AbstractTaskContainer)subTask4);
        this.taskList.addTask((ITask)subTask6, (AbstractTaskContainer)subTask5);
        this.taskList.addTask((ITask)subTask7, (AbstractTaskContainer)subTask6);
        this.taskList.addTask((ITask)subTask8, (AbstractTaskContainer)subTask7);
        this.taskList.addTask((ITask)subTask9, (AbstractTaskContainer)subTask8);
        this.taskList.addTask((ITask)subTask10, (AbstractTaskContainer)subTask9);
        this.taskList.addTask((ITask)subTask11, (AbstractTaskContainer)subTask10);
        this.taskList.addTask((ITask)task, (AbstractTaskContainer)subTask11);
        TaskListTest.assertEquals((int)12, (int)this.taskList.getAllTasks().size());
        TaskListTest.assertEquals((int)1, (int)this.taskList.getCategories().size());
        TaskListTest.assertEquals((int)1, (int)((AbstractTaskCategory)this.taskList.getCategories().iterator().next()).getChildren().size());
        TaskListTest.assertEquals((int)1, (int)task.getChildren().size());
        TaskListTest.assertEquals((Object)subTask1, task.getChildren().iterator().next());
        TaskListTest.assertEquals((int)1, (int)subTask1.getChildren().size());
        TaskListTest.assertEquals((Object)subTask2, subTask1.getChildren().iterator().next());
        TaskListTest.assertEquals((int)1, (int)subTask2.getChildren().size());
        TaskListTest.assertEquals((Object)subTask3, subTask2.getChildren().iterator().next());
        TaskListTest.assertEquals((int)1, (int)subTask3.getChildren().size());
        TaskListTest.assertEquals((Object)subTask4, subTask3.getChildren().iterator().next());
        TaskListTest.assertEquals((int)1, (int)subTask4.getChildren().size());
        TaskListTest.assertEquals((Object)subTask5, subTask4.getChildren().iterator().next());
        TaskListTest.assertEquals((int)1, (int)subTask5.getChildren().size());
        TaskListTest.assertEquals((Object)subTask6, subTask5.getChildren().iterator().next());
        TaskListTest.assertEquals((int)1, (int)subTask6.getChildren().size());
        TaskListTest.assertEquals((Object)subTask7, subTask6.getChildren().iterator().next());
        TaskListTest.assertEquals((int)1, (int)subTask7.getChildren().size());
        TaskListTest.assertEquals((Object)subTask8, subTask7.getChildren().iterator().next());
        TaskListTest.assertEquals((int)1, (int)subTask8.getChildren().size());
        TaskListTest.assertEquals((Object)subTask9, subTask8.getChildren().iterator().next());
        TaskListTest.assertEquals((int)1, (int)subTask9.getChildren().size());
        TaskListTest.assertEquals((Object)subTask10, subTask9.getChildren().iterator().next());
        TaskListTest.assertEquals((int)1, (int)subTask10.getChildren().size());
        TaskListTest.assertEquals((Object)subTask11, subTask10.getChildren().iterator().next());
        TaskListTest.assertEquals((int)0, (int)subTask11.getChildren().size());
    }

    public void testLocalSubTaskAddReallyDeepCycle() {
        LocalTask task = new LocalTask("1", "summary");
        LocalTask subTask1 = new LocalTask("2", "subTask");
        LocalTask subTask2 = new LocalTask("3", "subTask");
        LocalTask subTask3 = new LocalTask("4", "subTask");
        LocalTask subTask4 = new LocalTask("5", "subTask");
        LocalTask subTask5 = new LocalTask("6", "subTask");
        LocalTask subTask6 = new LocalTask("7", "subTask");
        LocalTask subTask7 = new LocalTask("8", "subTask");
        LocalTask subTask8 = new LocalTask("9", "subTask");
        LocalTask subTask9 = new LocalTask("10", "subTask");
        LocalTask subTask10 = new LocalTask("11", "subTask");
        LocalTask subTask11 = new LocalTask("12", "subTask");
        LocalTask subTask12 = new LocalTask("13", "subTask");
        LocalTask subTask13 = new LocalTask("14", "subTask");
        LocalTask subTask14 = new LocalTask("15", "subTask");
        LocalTask subTask15 = new LocalTask("16", "subTask");
        LocalTask subTask16 = new LocalTask("17", "subTask");
        LocalTask subTask17 = new LocalTask("18", "subTask");
        LocalTask subTask18 = new LocalTask("19", "subTask");
        this.taskList.addTask((ITask)task);
        this.taskList.addTask((ITask)subTask1, (AbstractTaskContainer)task);
        this.taskList.addTask((ITask)subTask2, (AbstractTaskContainer)subTask1);
        this.taskList.addTask((ITask)subTask3, (AbstractTaskContainer)subTask2);
        this.taskList.addTask((ITask)subTask4, (AbstractTaskContainer)subTask3);
        this.taskList.addTask((ITask)subTask5, (AbstractTaskContainer)subTask4);
        this.taskList.addTask((ITask)subTask6, (AbstractTaskContainer)subTask5);
        this.taskList.addTask((ITask)subTask7, (AbstractTaskContainer)subTask6);
        this.taskList.addTask((ITask)subTask8, (AbstractTaskContainer)subTask7);
        this.taskList.addTask((ITask)subTask9, (AbstractTaskContainer)subTask8);
        this.taskList.addTask((ITask)subTask10, (AbstractTaskContainer)subTask9);
        this.taskList.addTask((ITask)subTask11, (AbstractTaskContainer)subTask10);
        this.taskList.addTask((ITask)subTask12, (AbstractTaskContainer)subTask11);
        this.taskList.addTask((ITask)subTask13, (AbstractTaskContainer)subTask12);
        this.taskList.addTask((ITask)subTask14, (AbstractTaskContainer)subTask13);
        this.taskList.addTask((ITask)subTask15, (AbstractTaskContainer)subTask14);
        this.taskList.addTask((ITask)subTask16, (AbstractTaskContainer)subTask15);
        this.taskList.addTask((ITask)subTask17, (AbstractTaskContainer)subTask16);
        this.taskList.addTask((ITask)subTask18, (AbstractTaskContainer)subTask17);
        this.taskList.addTask((ITask)task, (AbstractTaskContainer)subTask18);
        TaskListTest.assertEquals((int)19, (int)this.taskList.getAllTasks().size());
        TaskListTest.assertEquals((int)1, (int)this.taskList.getCategories().size());
        TaskListTest.assertEquals((int)1, (int)((AbstractTaskCategory)this.taskList.getCategories().iterator().next()).getChildren().size());
        TaskListTest.assertEquals((int)1, (int)task.getChildren().size());
        TaskListTest.assertEquals((Object)subTask1, task.getChildren().iterator().next());
        TaskListTest.assertEquals((int)1, (int)subTask1.getChildren().size());
        TaskListTest.assertEquals((Object)subTask2, subTask1.getChildren().iterator().next());
        TaskListTest.assertEquals((int)1, (int)subTask2.getChildren().size());
        TaskListTest.assertEquals((Object)subTask3, subTask2.getChildren().iterator().next());
        TaskListTest.assertEquals((int)1, (int)subTask3.getChildren().size());
        TaskListTest.assertEquals((Object)subTask4, subTask3.getChildren().iterator().next());
        TaskListTest.assertEquals((int)1, (int)subTask4.getChildren().size());
        TaskListTest.assertEquals((Object)subTask5, subTask4.getChildren().iterator().next());
        TaskListTest.assertEquals((int)1, (int)subTask5.getChildren().size());
        TaskListTest.assertEquals((Object)subTask6, subTask5.getChildren().iterator().next());
        TaskListTest.assertEquals((int)1, (int)subTask6.getChildren().size());
        TaskListTest.assertEquals((Object)subTask7, subTask6.getChildren().iterator().next());
        TaskListTest.assertEquals((int)1, (int)subTask7.getChildren().size());
        TaskListTest.assertEquals((Object)subTask8, subTask7.getChildren().iterator().next());
        TaskListTest.assertEquals((int)1, (int)subTask8.getChildren().size());
        TaskListTest.assertEquals((Object)subTask9, subTask8.getChildren().iterator().next());
        TaskListTest.assertEquals((int)1, (int)subTask9.getChildren().size());
        TaskListTest.assertEquals((Object)subTask10, subTask9.getChildren().iterator().next());
        TaskListTest.assertEquals((int)1, (int)subTask10.getChildren().size());
        TaskListTest.assertEquals((Object)subTask11, subTask10.getChildren().iterator().next());
        TaskListTest.assertEquals((int)1, (int)subTask11.getChildren().size());
        TaskListTest.assertEquals((Object)subTask12, subTask11.getChildren().iterator().next());
        TaskListTest.assertEquals((int)1, (int)subTask11.getChildren().size());
        TaskListTest.assertEquals((Object)subTask12, subTask11.getChildren().iterator().next());
        TaskListTest.assertEquals((int)1, (int)subTask12.getChildren().size());
        TaskListTest.assertEquals((Object)subTask13, subTask12.getChildren().iterator().next());
        TaskListTest.assertEquals((int)1, (int)subTask13.getChildren().size());
        TaskListTest.assertEquals((Object)subTask14, subTask13.getChildren().iterator().next());
        TaskListTest.assertEquals((int)1, (int)subTask14.getChildren().size());
        TaskListTest.assertEquals((Object)subTask15, subTask14.getChildren().iterator().next());
        TaskListTest.assertEquals((int)1, (int)subTask15.getChildren().size());
        TaskListTest.assertEquals((Object)subTask16, subTask15.getChildren().iterator().next());
        TaskListTest.assertEquals((int)1, (int)subTask16.getChildren().size());
        TaskListTest.assertEquals((Object)subTask17, subTask16.getChildren().iterator().next());
        TaskListTest.assertEquals((int)1, (int)subTask17.getChildren().size());
        TaskListTest.assertEquals((Object)subTask18, subTask17.getChildren().iterator().next());
        TaskListTest.assertEquals((int)0, (int)subTask18.getChildren().size());
    }

    public void testQueryAndCategoryNameClash() {
        TaskCategory category = new TaskCategory("TestClash");
        this.taskList.addCategory(category);
        TaskListTest.assertTrue((boolean)this.taskList.getCategories().contains(category));
        TaskListTest.assertEquals((int)2, (int)this.taskList.getCategories().size());
        MockRepositoryQuery query = new MockRepositoryQuery("TestClash");
        this.taskList.addQuery((RepositoryQuery)query);
        TaskListTest.assertTrue((boolean)this.taskList.getCategories().contains(category));
        TaskListTest.assertEquals((int)2, (int)this.taskList.getCategories().size());
    }

    public void testMoveToRoot() {
        LocalTask task1 = new LocalTask("t1", "t1");
        this.taskList.addTask((ITask)task1, this.taskList.getUnmatchedContainer("local"));
        TaskListTest.assertEquals((int)1, (int)this.taskList.getDefaultCategory().getChildren().size());
        TaskListTest.assertEquals((Object)this.taskList.getDefaultCategory(), (Object)TaskCategory.getParentTaskCategory((ITask)task1));
        TaskCategory cat1 = new TaskCategory("c1");
        this.taskList.addCategory(cat1);
        this.taskList.addTask((ITask)task1, (AbstractTaskContainer)cat1);
        TaskListTest.assertEquals((int)0, (int)this.taskList.getDefaultCategory().getChildren().size());
        TaskListTest.assertEquals((Object)cat1, (Object)TaskCategory.getParentTaskCategory((ITask)task1));
        this.taskList.addTask((ITask)task1, this.taskList.getUnmatchedContainer("local"));
        TaskListTest.assertEquals((int)1, (int)this.taskList.getDefaultCategory().getChildren().size());
        TaskListTest.assertEquals((int)0, (int)cat1.getChildren().size());
        TaskListTest.assertEquals((Object)this.taskList.getDefaultCategory(), (Object)TaskCategory.getParentTaskCategory((ITask)task1));
    }

    public void testDeleteCategory() {
        TaskListTest.assertEquals((int)1, (int)this.taskList.getCategories().size());
        TaskCategory category = new TaskCategory("cat");
        this.taskList.addCategory(category);
        TaskListTest.assertEquals((int)2, (int)this.taskList.getCategories().size());
        this.taskList.deleteCategory((AbstractTaskCategory)category);
        TaskListTest.assertEquals((int)1, (int)this.taskList.getCategories().size());
    }

    public void testDeleteCategoryMovesTasksToRoot() {
        MockTask task = new MockTask("delete");
        TaskCategory category = new TaskCategory("cat");
        this.taskList.addCategory(category);
        this.taskList.addTask((ITask)task, (AbstractTaskContainer)category);
        TaskListTest.assertEquals((int)0, (int)this.taskList.getDefaultCategory().getChildren().size());
        this.taskList.deleteCategory((AbstractTaskCategory)category);
        this.taskList.getUnmatchedContainer("http://mockrepository.test");
    }

    public void testRenameCategory() {
        TaskCategory category = new TaskCategory("handle", "cat");
        this.taskList.addCategory(category);
        TaskListTest.assertEquals((int)2, (int)this.taskList.getCategories().size());
        this.taskList.renameContainer((AbstractTaskContainer)category, "newDescription");
        AbstractTaskCategory container = this.taskList.getContainerForHandle("handle");
        TaskListTest.assertNotNull((Object)container);
        TaskListTest.assertEquals((String)"newDescription", (String)container.getSummary());
        this.taskList.deleteCategory(container);
        TaskListTest.assertEquals((int)1, (int)this.taskList.getCategories().size());
    }

    public void testDeleteCategoryAfterRename() {
        String newDesc = "newDescription";
        TaskListTest.assertNotNull((Object)this.taskList);
        TaskListTest.assertEquals((int)1, (int)this.taskList.getCategories().size());
        TaskCategory category = new TaskCategory("cat");
        this.taskList.addCategory(category);
        TaskListTest.assertEquals((int)2, (int)this.taskList.getCategories().size());
        this.taskList.renameContainer((AbstractTaskContainer)category, newDesc);
        this.taskList.deleteCategory((AbstractTaskCategory)category);
        TaskListTest.assertEquals((int)1, (int)this.taskList.getCategories().size());
    }

    public void testCreateSameCategoryName() {
        TaskListTest.assertEquals((int)1, (int)this.taskList.getCategories().size());
        TaskCategory category = new TaskCategory("cat");
        this.taskList.addCategory(category);
        TaskListTest.assertEquals((int)2, (int)this.taskList.getCategories().size());
        TaskCategory category2 = new TaskCategory("cat");
        try {
            this.taskList.addCategory(category2);
            TaskListTest.fail((String)"expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        TaskListTest.assertEquals((int)2, (int)this.taskList.getCategories().size());
        AbstractTaskCategory container = this.taskList.getContainerForHandle("cat");
        TaskListTest.assertEquals((Object)container, (Object)category);
    }

    public void testDeleteRootTask() {
        LocalTask task = new LocalTask("1", "label");
        this.taskList.addTask((ITask)task);
        this.taskList.deleteTask((ITask)task);
        TaskListTest.assertEquals((int)0, (int)this.taskList.getAllTasks().size());
        TaskListTest.assertEquals((int)0, (int)this.taskList.getDefaultCategory().getChildren().size());
    }

    public void testDeleteFromCategory() {
        TaskListTest.assertEquals((int)0, (int)this.taskList.getAllTasks().size());
        TaskListTest.assertEquals((int)0, (int)this.taskList.getDefaultCategory().getChildren().size());
        TaskListTest.assertEquals((int)1, (int)this.taskList.getCategories().size());
        LocalTask task = new LocalTask("1", "label");
        TaskCategory category = new TaskCategory("handleAndDescription");
        this.taskList.addTask((ITask)task);
        TaskListTest.assertEquals((int)1, (int)this.taskList.getDefaultCategory().getChildren().size());
        this.taskList.addCategory(category);
        this.taskList.addTask((ITask)task, (AbstractTaskContainer)category);
        TaskListTest.assertEquals((int)2, (int)this.taskList.getCategories().size());
        TaskListTest.assertEquals((int)1, (int)category.getChildren().size());
        TaskListTest.assertEquals((int)0, (int)this.taskList.getDefaultCategory().getChildren().size());
        TaskListTest.assertEquals((int)1, (int)this.taskList.getAllTasks().size());
        this.taskList.deleteTask((ITask)task);
        TaskListTest.assertEquals((int)0, (int)this.taskList.getAllTasks().size());
        TaskListTest.assertEquals((int)0, (int)this.taskList.getDefaultCategory().getChildren().size());
        TaskListTest.assertEquals((int)0, (int)category.getChildren().size());
    }

    public void testDeleteRepositoryTask() {
        String repositoryUrl = "http://somewhere.com";
        MockTask task = new MockTask(repositoryUrl, "1");
        this.taskList.addTask((ITask)task, (AbstractTaskContainer)this.taskList.getDefaultCategory());
        MockRepositoryQuery query = new MockRepositoryQuery("query");
        this.taskList.addQuery((RepositoryQuery)query);
        this.taskList.addTask((ITask)task, (AbstractTaskContainer)query);
        TaskListTest.assertEquals((int)1, (int)this.taskList.getAllTasks().size());
        TaskListTest.assertEquals((int)1, (int)this.taskList.getDefaultCategory().getChildren().size());
        this.taskList.deleteTask((ITask)task);
        TaskListTest.assertEquals((int)0, (int)this.taskList.getAllTasks().size());
        TaskListTest.assertEquals((int)0, (int)this.taskList.getDefaultCategory().getChildren().size());
    }

    public void testgetQueriesAndHitsForHandle() {
        MockTask hit1 = new MockTask("1");
        MockTask hit2 = new MockTask("2");
        MockTask hit3 = new MockTask("3");
        MockTask hit1twin = new MockTask("1");
        MockTask hit2twin = new MockTask("2");
        MockTask hit3twin = new MockTask("3");
        MockRepositoryQuery query1 = new MockRepositoryQuery("query1");
        MockRepositoryQuery query2 = new MockRepositoryQuery("query2");
        this.taskList.addQuery((RepositoryQuery)query1);
        this.taskList.addQuery((RepositoryQuery)query2);
        this.taskList.addTask((ITask)hit1, (AbstractTaskContainer)query1);
        this.taskList.addTask((ITask)hit2, (AbstractTaskContainer)query1);
        this.taskList.addTask((ITask)hit3, (AbstractTaskContainer)query1);
        TaskListTest.assertEquals((int)3, (int)query1.getChildren().size());
        this.taskList.addTask((ITask)hit1twin, (AbstractTaskContainer)query2);
        this.taskList.addTask((ITask)hit2twin, (AbstractTaskContainer)query2);
        this.taskList.addTask((ITask)hit3twin, (AbstractTaskContainer)query2);
        TaskListTest.assertEquals((int)3, (int)query2.getChildren().size());
        Set queriesReturned = hit1.getParentContainers();
        TaskListTest.assertNotNull((Object)queriesReturned);
        TaskListTest.assertEquals((int)2, (int)queriesReturned.size());
        TaskListTest.assertTrue((boolean)queriesReturned.contains((Object)query1));
        TaskListTest.assertTrue((boolean)queriesReturned.contains((Object)query2));
    }

    public void testUpdateQueryHits() {
        MockTask hit1 = new MockTask("1");
        MockTask hit2 = new MockTask("2");
        MockTask hit3 = new MockTask("3");
        MockTask hit1twin = new MockTask("1");
        MockTask hit2twin = new MockTask("2");
        MockTask hit3twin = new MockTask("3");
        MockRepositoryQuery query1 = new MockRepositoryQuery("query1");
        this.taskList.addQuery((RepositoryQuery)query1);
        this.taskList.addTask((ITask)hit1, (AbstractTaskContainer)query1);
        this.taskList.addTask((ITask)hit2, (AbstractTaskContainer)query1);
        this.taskList.addTask((ITask)hit3, (AbstractTaskContainer)query1);
        this.taskList.addTask((ITask)hit1twin, (AbstractTaskContainer)query1);
        this.taskList.addTask((ITask)hit2twin, (AbstractTaskContainer)query1);
        this.taskList.addTask((ITask)hit3twin, (AbstractTaskContainer)query1);
        TaskListTest.assertEquals((int)3, (int)query1.getChildren().size());
        for (ITask child : query1.getChildren()) {
            this.taskList.removeFromContainer((AbstractTaskContainer)query1, child);
        }
        TaskListTest.assertEquals((int)0, (int)query1.getChildren().size());
        this.taskList.addTask((ITask)hit1, (AbstractTaskContainer)query1);
        this.taskList.addTask((ITask)hit2, (AbstractTaskContainer)query1);
        TaskListTest.assertEquals((int)2, (int)query1.getChildren().size());
        hit1.setNotified(true);
        this.taskList.addTask((ITask)hit1twin, (AbstractTaskContainer)query1);
        this.taskList.addTask((ITask)hit2twin, (AbstractTaskContainer)query1);
        this.taskList.addTask((ITask)hit3twin, (AbstractTaskContainer)query1);
        TaskListTest.assertEquals((int)3, (int)query1.getChildren().size());
        TaskListTest.assertTrue((boolean)query1.getChildren().contains((Object)hit1twin));
        TaskListTest.assertTrue((boolean)query1.getChildren().contains((Object)hit2twin));
        TaskListTest.assertTrue((boolean)query1.getChildren().contains((Object)hit3twin));
        for (ITask hit : query1.getChildren()) {
            if (hit.equals((Object)hit1twin)) {
                TaskListTest.assertTrue((boolean)((AbstractTask)hit).isNotified());
                continue;
            }
            TaskListTest.assertFalse((boolean)((AbstractTask)hit).isNotified());
        }
    }

    public void testGetRepositoryTasks() {
        String repositoryUrl = "https://bugs.eclipse.org/bugs";
        String bugNumber = "106939";
        MockTask task1 = new MockTask(repositoryUrl, bugNumber);
        this.taskList.addTask((ITask)task1);
        MockTask task2 = new MockTask("https://unresolved", bugNumber);
        this.taskList.addTask((ITask)task2);
        TaskListTest.assertEquals((int)2, (int)this.taskList.getAllTasks().size());
        Set tasksReturned = this.taskList.getTasks(repositoryUrl);
        TaskListTest.assertNotNull((Object)tasksReturned);
        TaskListTest.assertEquals((int)1, (int)tasksReturned.size());
        TaskListTest.assertTrue((boolean)tasksReturned.contains((Object)task1));
    }
}

