/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.tasks.tests;

import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TimeZone;
import junit.framework.TestCase;
import org.eclipse.mylyn.internal.tasks.core.AbstractTask;
import org.eclipse.mylyn.internal.tasks.core.AbstractTaskContainer;
import org.eclipse.mylyn.internal.tasks.core.DateRange;
import org.eclipse.mylyn.internal.tasks.core.LocalTask;
import org.eclipse.mylyn.internal.tasks.core.RepositoryQuery;
import org.eclipse.mylyn.internal.tasks.core.TaskCategory;
import org.eclipse.mylyn.internal.tasks.core.TaskList;
import org.eclipse.mylyn.internal.tasks.core.TaskTask;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.internal.tasks.ui.util.TasksUiInternal;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylyn.tasks.core.IRepositoryQuery;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.ITaskContainer;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.tests.TaskTestUtil;
import org.eclipse.mylyn.tasks.ui.TasksUi;

public class TaskListExternalizationTest
extends TestCase {
    private TaskList taskList;
    private TaskRepository repository;

    protected void setUp() throws Exception {
        super.setUp();
        TasksUiPlugin.getDefault().getPreferenceStore().setValue("org.eclipse.mylyn.tasks.ui.repositories.synch.schedule", false);
        TaskTestUtil.resetTaskListAndRepositories();
        this.repository = new TaskRepository("mock", "http://mockrepository.test");
        TasksUiPlugin.getRepositoryManager().addRepository(this.repository);
        this.taskList = TasksUiPlugin.getTaskList();
    }

    protected void tearDown() throws Exception {
        TaskTestUtil.resetTaskList();
    }

    public void testTaskAttributes() throws Exception {
        LocalTask task1 = TasksUiInternal.createNewLocalTask((String)"task 1");
        task1.setAttribute("key", "value");
        TaskListExternalizationTest.assertEquals((int)1, (int)task1.getAttributes().size());
        TaskTestUtil.saveAndReadTasklist();
        task1 = this.taskList.getTask(task1.getHandleIdentifier());
        TaskListExternalizationTest.assertNotNull((Object)task1);
        TaskListExternalizationTest.assertEquals((int)1, (int)task1.getAttributes().size());
        TaskListExternalizationTest.assertEquals((String)"value", (String)task1.getAttribute("key"));
    }

    public void testTaskAttributeDelete() throws Exception {
        LocalTask task1 = TasksUiInternal.createNewLocalTask((String)"task 1");
        task1.setAttribute("key", "value");
        task1.setAttribute("key", null);
        TaskListExternalizationTest.assertEquals((int)0, (int)task1.getAttributes().size());
        TaskListExternalizationTest.assertEquals(null, (String)task1.getAttribute("key"));
        TaskTestUtil.saveAndReadTasklist();
        task1 = this.taskList.getTask(task1.getHandleIdentifier());
        TaskListExternalizationTest.assertNotNull((Object)task1);
        TaskListExternalizationTest.assertEquals((int)0, (int)task1.getAttributes().size());
        TaskListExternalizationTest.assertEquals(null, (String)task1.getAttribute("key"));
    }

    public void testUncategorizedTasksNotLost() throws Exception {
        RepositoryQuery query = TaskTestUtil.createMockQuery("1");
        this.taskList.addQuery(query);
        TaskTask task = TaskTestUtil.createMockTask("1");
        this.taskList.addTask((ITask)task, (AbstractTaskContainer)query);
        this.taskList.addTask((ITask)task, (AbstractTaskContainer)this.taskList.getDefaultCategory());
        TaskListExternalizationTest.assertTrue((boolean)query.contains(task.getHandleIdentifier()));
        TaskListExternalizationTest.assertTrue((boolean)this.taskList.getDefaultCategory().contains(task.getHandleIdentifier()));
        TaskTestUtil.saveAndReadTasklist();
        TaskListExternalizationTest.assertTrue((boolean)this.taskList.getDefaultCategory().contains(task.getHandleIdentifier()));
    }

    public void testUniqueTaskId() throws Exception {
        LocalTask task1 = TasksUiInternal.createNewLocalTask((String)"label");
        this.taskList.addTask((ITask)task1);
        LocalTask task2 = TasksUiInternal.createNewLocalTask((String)"label");
        this.taskList.addTask((ITask)task2);
        TaskListExternalizationTest.assertEquals((int)2, (int)this.taskList.getLastLocalTaskId());
        this.taskList.deleteTask((ITask)task2);
        LocalTask task3 = TasksUiInternal.createNewLocalTask((String)"label");
        this.taskList.addTask((ITask)task3);
        TaskListExternalizationTest.assertTrue((String)(String.valueOf(task3.getHandleIdentifier()) + " should end with 3"), (boolean)task3.getHandleIdentifier().endsWith("3"));
        TaskListExternalizationTest.assertEquals((int)3, (int)this.taskList.getLastLocalTaskId());
        TaskListExternalizationTest.assertEquals((int)2, (int)this.taskList.getAllTasks().size());
        TaskTestUtil.saveAndReadTasklist();
        TaskListExternalizationTest.assertEquals((int)2, (int)this.taskList.getAllTasks().size());
        TaskListExternalizationTest.assertEquals((int)3, (int)this.taskList.getLastLocalTaskId());
        LocalTask task4 = TasksUiInternal.createNewLocalTask((String)"label");
        TaskListExternalizationTest.assertTrue((String)(String.valueOf(task4.getHandleIdentifier()) + " should end with 4"), (boolean)task4.getHandleIdentifier().endsWith("4"));
    }

    public void testSingleTaskDeletion() throws Exception {
        TaskTask task = TaskTestUtil.createMockTask("1");
        this.taskList.addTask((ITask)task, this.taskList.getUnmatchedContainer("local"));
        TaskListExternalizationTest.assertEquals((int)1, (int)this.taskList.getAllTasks().size());
        this.taskList.deleteTask((ITask)task);
        TaskListExternalizationTest.assertEquals((int)0, (int)this.taskList.getAllTasks().size());
        this.taskList.addTask((ITask)task, this.taskList.getUnmatchedContainer("local"));
        TaskListExternalizationTest.assertEquals((int)1, (int)this.taskList.getAllTasks().size());
        TaskTestUtil.saveAndReadTasklist();
        TaskListExternalizationTest.assertEquals((int)1, (int)this.taskList.getAllTasks().size());
        this.taskList.deleteTask((ITask)task);
        TaskListExternalizationTest.assertEquals((int)0, (int)this.taskList.getAllTasks().size());
        TaskTestUtil.saveAndReadTasklist();
        TaskListExternalizationTest.assertEquals((int)0, (int)this.taskList.getAllTasks().size());
    }

    public void testCategoryPersistance() throws Exception {
        TaskTask task = TaskTestUtil.createMockTask("1");
        TaskCategory category = new TaskCategory("cat");
        this.taskList.addCategory(category);
        this.taskList.addTask((ITask)task, (AbstractTaskContainer)category);
        TaskListExternalizationTest.assertNotNull((Object)this.taskList);
        TaskListExternalizationTest.assertEquals((int)2, (int)this.taskList.getCategories().size());
        TaskTestUtil.saveAndReadTasklist();
        TaskListExternalizationTest.assertEquals((String)("" + this.taskList.getCategories()), (int)2, (int)this.taskList.getCategories().size());
        TaskListExternalizationTest.assertEquals((int)1, (int)this.taskList.getAllTasks().size());
    }

    public void testCreate() throws Exception {
        TaskTask repositoryTask = TaskTestUtil.createMockTask("1");
        this.taskList.addTask((ITask)repositoryTask, (AbstractTaskContainer)this.taskList.getDefaultCategory());
        TaskListExternalizationTest.assertEquals((int)1, (int)this.taskList.getDefaultCategory().getChildren().size());
        TaskTestUtil.saveAndReadTasklist();
        TaskListExternalizationTest.assertEquals((int)1, (int)this.taskList.getAllTasks().size());
    }

    public void testCreateAndMove() throws Exception {
        TaskTask repositoryTask = TaskTestUtil.createMockTask("1");
        this.taskList.addTask((ITask)repositoryTask);
        TaskListExternalizationTest.assertEquals((int)1, (int)this.taskList.getAllTasks().size());
        TaskTestUtil.saveAndReadTasklist();
        TaskListExternalizationTest.assertEquals((int)1, (int)this.taskList.getAllTasks().size());
        TaskListExternalizationTest.assertEquals((int)1, (int)this.taskList.getUnmatchedContainer("http://mockrepository.test").getChildren().size());
    }

    public void testArchiveRepositoryTaskExternalization() throws Exception {
        TaskTask repositoryTask = TaskTestUtil.createMockTask("1");
        this.taskList.addTask((ITask)repositoryTask);
        TaskListExternalizationTest.assertEquals((int)1, (int)this.taskList.getUnmatchedContainer("http://mockrepository.test").getChildren().size());
        TaskTestUtil.saveAndReadTasklist();
        TaskListExternalizationTest.assertEquals((int)1, (int)this.taskList.getUnmatchedContainer("http://mockrepository.test").getChildren().size());
    }

    public void testRepositoryTasksAndCategoriesMultiRead() throws Exception {
        ITaskContainer readCat1;
        TaskCategory cat1 = new TaskCategory("Category 1");
        this.taskList.addCategory(cat1);
        TaskTask reportInCat1 = TaskTestUtil.createMockTask("123");
        this.taskList.addTask((ITask)reportInCat1, (AbstractTaskContainer)cat1);
        TaskListExternalizationTest.assertEquals((Object)cat1, (Object)TaskCategory.getParentTaskCategory((ITask)reportInCat1));
        TaskTestUtil.saveAndReadTasklist();
        Set readCats = this.taskList.getTaskCategories();
        TaskListExternalizationTest.assertTrue((boolean)this.taskList.getCategories().contains(cat1));
        Iterator iterator = readCats.iterator();
        boolean found = false;
        while (iterator.hasNext()) {
            readCat1 = (ITaskContainer)iterator.next();
            if (!cat1.equals((Object)readCat1)) continue;
            found = true;
            TaskListExternalizationTest.assertEquals((int)1, (int)readCat1.getChildren().size());
        }
        if (!found) {
            TaskListExternalizationTest.fail((String)" Category not found afer tasklist read");
        }
        TaskTestUtil.saveAndReadTasklist();
        readCats = this.taskList.getTaskCategories();
        TaskListExternalizationTest.assertTrue((boolean)this.taskList.getCategories().contains(cat1));
        iterator = readCats.iterator();
        found = false;
        while (iterator.hasNext()) {
            readCat1 = (ITaskContainer)iterator.next();
            if (!cat1.equals((Object)readCat1)) continue;
            found = true;
            TaskListExternalizationTest.assertEquals((int)1, (int)readCat1.getChildren().size());
        }
        if (!found) {
            TaskListExternalizationTest.fail((String)" Category not found afer tasklist read");
        }
    }

    public void testSubTaskExternalization() throws Exception {
        HashSet<LocalTask> rootTasks = new HashSet<LocalTask>();
        LocalTask task1 = new LocalTask("1", "task1");
        this.taskList.addTask((ITask)task1);
        rootTasks.add(task1);
        LocalTask sub2 = new LocalTask("2", "sub 2");
        this.taskList.addTask((ITask)sub2, (AbstractTaskContainer)task1);
        TaskListExternalizationTest.assertEquals((int)1, (int)task1.getChildren().size());
        TaskListExternalizationTest.assertTrue((boolean)rootTasks.containsAll(this.taskList.getDefaultCategory().getChildren()));
        TaskTestUtil.saveAndReadTasklist();
        Collection readList = this.taskList.getDefaultCategory().getChildren();
        for (ITask task : readList) {
            if (!task.equals(task1)) continue;
            TaskListExternalizationTest.assertEquals((String)task1.getSummary(), (String)task.getSummary());
            TaskListExternalizationTest.assertEquals((int)1, (int)((ITaskContainer)task).getChildren().size());
        }
    }

    public void testCreationAndExternalization() throws Exception {
        HashSet<LocalTask> rootTasks = new HashSet<LocalTask>();
        LocalTask task1 = TasksUiInternal.createNewLocalTask((String)"task 1");
        rootTasks.add(task1);
        TaskListExternalizationTest.assertEquals((int)1, (int)this.taskList.getAllTasks().size());
        LocalTask sub1 = TasksUiInternal.createNewLocalTask((String)"sub 1");
        this.taskList.addTask((ITask)sub1, (AbstractTaskContainer)task1);
        int baseRootElementsCount = 3;
        TaskListExternalizationTest.assertEquals((int)baseRootElementsCount, (int)this.taskList.getRootElements().size());
        LocalTask task2 = TasksUiInternal.createNewLocalTask((String)"task 2");
        rootTasks.add(task2);
        TaskListExternalizationTest.assertEquals((int)3, (int)this.taskList.getAllTasks().size());
        HashSet<TaskCategory> categories = new HashSet<TaskCategory>();
        HashSet<Object> cat1Contents = new HashSet<Object>();
        TaskCategory cat1 = new TaskCategory("Category 1");
        this.taskList.addCategory(cat1);
        categories.add(cat1);
        TaskListExternalizationTest.assertEquals((int)(baseRootElementsCount + 1), (int)this.taskList.getRootElements().size());
        LocalTask task3 = TasksUiInternal.createNewLocalTask((String)"task 3");
        this.taskList.addTask((ITask)task3, (AbstractTaskContainer)cat1);
        cat1Contents.add(task3);
        TaskListExternalizationTest.assertEquals((int)4, (int)this.taskList.getAllTasks().size());
        TaskListExternalizationTest.assertEquals((Object)cat1, (Object)TaskCategory.getParentTaskCategory((ITask)task3));
        LocalTask sub2 = TasksUiInternal.createNewLocalTask((String)"sub 2");
        TaskListExternalizationTest.assertEquals((int)5, (int)this.taskList.getAllTasks().size());
        this.taskList.addTask((ITask)sub2, (AbstractTaskContainer)task3);
        LocalTask task4 = TasksUiInternal.createNewLocalTask((String)"task 4");
        this.taskList.addTask((ITask)task4, (AbstractTaskContainer)cat1);
        cat1Contents.add(task4);
        TaskListExternalizationTest.assertEquals((int)6, (int)this.taskList.getAllTasks().size());
        TaskTask reportInCat1 = TaskTestUtil.createMockTask("123");
        this.taskList.addTask((ITask)reportInCat1, (AbstractTaskContainer)cat1);
        TaskListExternalizationTest.assertEquals((Object)cat1, (Object)TaskCategory.getParentTaskCategory((ITask)reportInCat1));
        cat1Contents.add(reportInCat1);
        TaskListExternalizationTest.assertEquals((int)7, (int)this.taskList.getAllTasks().size());
        TaskListExternalizationTest.assertEquals((int)(baseRootElementsCount + 1), (int)this.taskList.getRootElements().size());
        TaskTestUtil.saveAndReadTasklist();
        Collection readList = this.taskList.getDefaultCategory().getChildren();
        for (ITask task : readList) {
            if (!task.equals(task1)) continue;
            TaskListExternalizationTest.assertEquals((String)task1.getSummary(), (String)task.getSummary());
            TaskListExternalizationTest.assertEquals((int)1, (int)((AbstractTaskContainer)task).getChildren().size());
        }
        Set readCats = this.taskList.getTaskCategories();
        TaskListExternalizationTest.assertTrue((boolean)this.taskList.getCategories().contains(cat1));
        Iterator iterator = readCats.iterator();
        boolean found = false;
        while (iterator.hasNext()) {
            ITaskContainer readCat1 = (ITaskContainer)iterator.next();
            if (!cat1.equals((Object)readCat1)) continue;
            found = true;
            for (ITask task : readCat1.getChildren()) {
                TaskListExternalizationTest.assertTrue((boolean)cat1Contents.contains(task));
            }
        }
        if (!found) {
            TaskListExternalizationTest.fail((String)" Category not found afer tasklist read");
        }
    }

    public void testExternalizationOfHandlesWithDash() throws Exception {
        LocalTask task1 = TasksUiInternal.createNewLocalTask((String)"task 1");
        this.taskList.addTask((ITask)task1, (AbstractTaskContainer)this.taskList.getDefaultCategory());
        TaskTestUtil.saveAndReadTasklist();
        TaskListExternalizationTest.assertTrue((boolean)this.taskList.getDefaultCategory().getChildren().contains(task1));
    }

    public void testQueryRemovedTaskInCategory() throws Exception {
        TaskTask mockTask = TaskTestUtil.createMockTask("1");
        RepositoryQuery mockQuery = TaskTestUtil.createMockQuery("mock query");
        this.taskList.addQuery(mockQuery);
        this.taskList.addTask((ITask)mockTask, (AbstractTaskContainer)mockQuery);
        TaskListExternalizationTest.assertTrue((boolean)this.taskList.getDefaultCategory().isEmpty());
        this.taskList.addTask((ITask)mockTask, (AbstractTaskContainer)this.taskList.getDefaultCategory());
        TaskListExternalizationTest.assertEquals((int)1, (int)this.taskList.getCategories().size());
        TaskListExternalizationTest.assertFalse((boolean)this.taskList.getDefaultCategory().isEmpty());
        TaskTestUtil.saveAndReadTasklist();
        TaskListExternalizationTest.assertEquals((int)1, (int)this.taskList.getCategories().size());
        TaskListExternalizationTest.assertEquals((int)1, (int)this.taskList.getQueries().size());
        TaskListExternalizationTest.assertFalse((boolean)this.taskList.getDefaultCategory().isEmpty());
        this.taskList.deleteQuery(mockQuery);
        TaskTestUtil.saveAndReadTasklist();
        TaskListExternalizationTest.assertEquals((int)1, (int)this.taskList.getCategories().size());
        TaskListExternalizationTest.assertEquals((int)0, (int)this.taskList.getQueries().size());
        TaskListExternalizationTest.assertFalse((boolean)this.taskList.getDefaultCategory().isEmpty());
    }

    public void testAddLocalTask() {
        Set tasks = this.taskList.getTasks("local");
        TaskListExternalizationTest.assertTrue((boolean)tasks.isEmpty());
        LocalTask localTask = TasksUiInternal.createNewLocalTask((String)"Task 1");
        TaskListExternalizationTest.assertNotNull((Object)localTask);
        TaskListExternalizationTest.assertEquals((int)1, (int)((AbstractTask)localTask).getParentContainers().size());
    }

    public void testRemindedPersistance() throws Exception {
        String bugNumber = "106939";
        ITask task = TasksUi.getRepositoryModel().createTask(this.repository, bugNumber);
        TaskTask task1 = null;
        if (task instanceof TaskTask) {
            task1 = (TaskTask)task;
        }
        TaskListExternalizationTest.assertNotNull(task1);
        TasksUiPlugin.getTaskList().addTask((ITask)task1);
        task1.setReminded(true);
        TaskTestUtil.saveAndReadTasklist();
        TaskList taskList = TasksUiPlugin.getTaskList();
        TaskListExternalizationTest.assertEquals((int)1, (int)taskList.getAllTasks().size());
        Set tasksReturned = taskList.getTasks("http://mockrepository.test");
        TaskListExternalizationTest.assertNotNull((Object)tasksReturned);
        TaskListExternalizationTest.assertEquals((int)1, (int)tasksReturned.size());
        for (ITask taskRet : tasksReturned) {
            TaskListExternalizationTest.assertTrue((boolean)((AbstractTask)taskRet).isReminded());
        }
    }

    public void testRepositoryTaskExternalization() throws Exception {
        TaskTask task = (TaskTask)TasksUi.getRepositoryModel().createTask(this.repository, "1");
        task.setTaskKind("kind");
        TasksUiPlugin.getTaskList().addTask((ITask)task);
        TaskTestUtil.saveAndReadTasklist();
        TaskListExternalizationTest.assertEquals((int)1, (int)TasksUiPlugin.getTaskList().getUnmatchedContainer("http://mockrepository.test").getChildren().size());
        ITask readTask = (ITask)TasksUiPlugin.getTaskList().getUnmatchedContainer("http://mockrepository.test").getChildren().iterator().next();
        TaskListExternalizationTest.assertEquals((String)task.getHandleIdentifier(), (String)readTask.getHandleIdentifier());
        TaskListExternalizationTest.assertEquals((String)task.getSummary(), (String)readTask.getSummary());
        TaskListExternalizationTest.assertEquals((String)task.getTaskKind(), (String)readTask.getTaskKind());
    }

    public void testQueryExternalization() throws Exception {
        RepositoryQuery query = (RepositoryQuery)TasksUi.getRepositoryModel().createRepositoryQuery(this.repository);
        TaskListExternalizationTest.assertEquals((String)"http://mockrepository.test", (String)query.getRepositoryUrl());
        TaskListExternalizationTest.assertEquals((String)"<never>", (String)query.getLastSynchronizedTimeStamp());
        query.setLastSynchronizedStamp("today");
        TasksUiPlugin.getTaskList().addQuery(query);
        TaskTestUtil.saveAndReadTasklist();
        TaskListExternalizationTest.assertEquals((int)1, (int)TasksUiPlugin.getTaskList().getQueries().size());
        IRepositoryQuery readQuery = (IRepositoryQuery)TasksUiPlugin.getTaskList().getQueries().iterator().next();
        TaskListExternalizationTest.assertEquals((String)query.getRepositoryUrl(), (String)readQuery.getRepositoryUrl());
        TaskListExternalizationTest.assertEquals((String)"today", (String)query.getLastSynchronizedTimeStamp());
        TaskListExternalizationTest.assertEquals((String)"http://mockrepository.test", (String)readQuery.getRepositoryUrl());
    }

    public void testDeleteQuery() {
        RepositoryQuery query = new RepositoryQuery("mock", "queryUrl");
        query.setRepositoryUrl("repositoryUrl");
        TasksUiPlugin.getTaskList().addQuery(query);
        IRepositoryQuery readQuery = (IRepositoryQuery)TasksUiPlugin.getTaskList().getQueries().iterator().next();
        TaskListExternalizationTest.assertEquals((Object)query, (Object)readQuery);
        TasksUiPlugin.getTaskList().deleteQuery(query);
        TaskListExternalizationTest.assertEquals((int)0, (int)TasksUiPlugin.getTaskList().getQueries().size());
    }

    public void testDeleteQueryAfterRename() {
        RepositoryQuery query = new RepositoryQuery("mock", "queryUrl");
        query.setRepositoryUrl("repositoryUrl");
        TasksUiPlugin.getTaskList().addQuery(query);
        IRepositoryQuery readQuery = (IRepositoryQuery)TasksUiPlugin.getTaskList().getQueries().iterator().next();
        TaskListExternalizationTest.assertEquals((Object)query, (Object)readQuery);
        query.setSummary("newName");
        TasksUiPlugin.getTaskList().deleteQuery(query);
        TaskListExternalizationTest.assertEquals((int)0, (int)TasksUiPlugin.getTaskList().getQueries().size());
    }

    public void testCreateQueryWithSameName() {
        block2: {
            RepositoryQuery query = new RepositoryQuery("mock", "queryUrl");
            query.setRepositoryUrl("repositoryUrl");
            TasksUiPlugin.getTaskList().addQuery(query);
            TaskListExternalizationTest.assertEquals((int)1, (int)TasksUiPlugin.getTaskList().getQueries().size());
            IRepositoryQuery readQuery = (IRepositoryQuery)TasksUiPlugin.getTaskList().getQueries().iterator().next();
            TaskListExternalizationTest.assertEquals((Object)query, (Object)readQuery);
            try {
                query = new RepositoryQuery("mock", "queryUrl");
                query.setRepositoryUrl("repositoryUrl");
                TasksUiPlugin.getTaskList().addQuery(query);
                TaskListExternalizationTest.fail((String)"Expected IllegalArgumentException");
            }
            catch (IllegalArgumentException e) {
                if (e.getMessage().equals("Handle queryUrl already exists in task list")) break block2;
                throw e;
            }
        }
        TaskListExternalizationTest.assertEquals((int)1, (int)TasksUiPlugin.getTaskList().getQueries().size());
    }

    public void testRepositoryUrlHandles() throws Exception {
        String taskId = "123";
        String repositoryUrl = "http://mock.eclipse.org";
        TaskRepository repository = new TaskRepository("mock", repositoryUrl);
        TasksUiPlugin.getRepositoryManager().addRepository(repository);
        TaskTask bugTask = new TaskTask("mock", repositoryUrl, taskId);
        bugTask.setSummary("Summary");
        TaskListExternalizationTest.assertEquals((String)repositoryUrl, (String)bugTask.getRepositoryUrl());
        TasksUiPlugin.getTaskList().addTask((ITask)bugTask);
        TaskTestUtil.saveAndReadTasklist();
        ITask readReport = TasksUiPlugin.getTaskList().getTask(repositoryUrl, taskId);
        TaskListExternalizationTest.assertEquals((String)"Summary", (String)readReport.getSummary());
        TaskListExternalizationTest.assertEquals((String)repositoryUrl, (String)readReport.getRepositoryUrl());
        TasksUiPlugin.getRepositoryManager().removeRepository(repository);
    }

    public void testDueDateExternalization() throws Exception {
        LocalTask task = new LocalTask("1", "task 1");
        Date dueDate = new Date();
        task.setDueDate(dueDate);
        TasksUiPlugin.getTaskList().addTask((ITask)task);
        TaskListExternalizationTest.assertEquals((int)1, (int)TasksUiPlugin.getTaskList().getAllTasks().size());
        TaskTestUtil.saveAndReadTasklist();
        TaskListExternalizationTest.assertEquals((int)1, (int)TasksUiPlugin.getTaskList().getAllTasks().size());
        Collection readList = TasksUiPlugin.getTaskList().getDefaultCategory().getChildren();
        ITask readTask = (ITask)readList.iterator().next();
        TaskListExternalizationTest.assertTrue((boolean)readTask.getSummary().equals("task 1"));
        TaskListExternalizationTest.assertTrue((readTask.getDueDate().compareTo(dueDate) == 0 ? 1 : 0) != 0);
    }

    public void testPastReminder() throws InterruptedException {
        LocalTask task = new LocalTask("1", "1");
        task.setScheduledForDate(new DateRange(Calendar.getInstance()));
        Thread.sleep(2000L);
        TaskListExternalizationTest.assertFalse((boolean)TasksUiPlugin.getTaskActivityManager().isPastReminder((AbstractTask)task));
        Calendar cal = Calendar.getInstance();
        cal.add(12, 2);
        task.setScheduledForDate(new DateRange(cal));
        TaskListExternalizationTest.assertFalse((boolean)TasksUiPlugin.getTaskActivityManager().isPastReminder((AbstractTask)task));
        Calendar cal1 = Calendar.getInstance();
        cal1.add(12, -2);
        task.setScheduledForDate(new DateRange(cal1, cal));
        TaskListExternalizationTest.assertFalse((boolean)TasksUiPlugin.getTaskActivityManager().isPastReminder((AbstractTask)task));
        Calendar cal2 = Calendar.getInstance();
        cal2.add(12, -2);
        task.setScheduledForDate(new DateRange(cal2));
        task.setCompletionDate(new Date());
        TaskListExternalizationTest.assertFalse((boolean)TasksUiPlugin.getTaskActivityManager().isPastReminder((AbstractTask)task));
    }

    public void testDates() throws Exception {
        TaskTestUtil.resetTaskListAndRepositories();
        Date start = Calendar.getInstance().getTime();
        Date creation = new Date();
        LocalTask task = new LocalTask("1", "task 1");
        TasksUiPlugin.getTaskList().addTask((ITask)task);
        TaskListExternalizationTest.assertNull((Object)task.getCreationDate());
        task.setCreationDate(start);
        TaskListExternalizationTest.assertEquals((Object)start, (Object)task.getCreationDate());
        TaskListExternalizationTest.assertNull((Object)task.getCompletionDate());
        task.setCompletionDate(creation);
        TaskListExternalizationTest.assertEquals((Object)creation, (Object)task.getCompletionDate());
        TaskListExternalizationTest.assertEquals((int)1, (int)TasksUiPlugin.getTaskList().getRootElements().size());
        TasksUiPlugin.getExternalizationManager().requestSave();
        TaskListExternalizationTest.assertNotNull((Object)TasksUiPlugin.getTaskList());
        TaskListExternalizationTest.assertEquals((int)1, (int)TasksUiPlugin.getTaskList().getDefaultCategory().getChildren().size());
        Collection readList = TasksUiPlugin.getTaskList().getDefaultCategory().getChildren();
        AbstractTask readTask = (AbstractTask)readList.iterator().next();
        TaskListExternalizationTest.assertTrue((boolean)readTask.getSummary().equals("task 1"));
        TaskListExternalizationTest.assertEquals((String)("should be: " + creation), (Object)task.getCreationDate(), (Object)readTask.getCreationDate());
        TaskListExternalizationTest.assertEquals((Object)task.getCompletionDate(), (Object)readTask.getCompletionDate());
        TaskListExternalizationTest.assertEquals((Object)task.getScheduledForDate(), (Object)readTask.getScheduledForDate());
    }

    public void testDatesTimeZone() throws Exception {
        TaskTestUtil.resetTaskListAndRepositories();
        TimeZone.setDefault(TimeZone.getTimeZone("PRC"));
        LocalTask task = new LocalTask("1", "task 1");
        Date creationDate = new Date();
        task.setCreationDate(creationDate);
        TasksUiPlugin.getTaskList().addTask((ITask)task);
        TaskListExternalizationTest.assertEquals((int)1, (int)TasksUiPlugin.getTaskList().getAllTasks().size());
        TaskTestUtil.saveNow();
        TimeZone.setDefault(TimeZone.getTimeZone("CST"));
        TaskTestUtil.resetTaskList();
        TasksUiPlugin.getDefault().initializeDataSources();
        TaskListExternalizationTest.assertEquals((int)1, (int)TasksUiPlugin.getTaskList().getAllTasks().size());
        Collection readList = TasksUiPlugin.getTaskList().getDefaultCategory().getChildren();
        ITask readTask = (ITask)readList.iterator().next();
        TaskListExternalizationTest.assertTrue((boolean)readTask.getSummary().equals("task 1"));
        TaskListExternalizationTest.assertTrue((readTask.getCreationDate().compareTo(creationDate) == 0 ? 1 : 0) != 0);
    }

    public void testOrphanedTasks() throws Exception {
        TaskListExternalizationTest.assertEquals((int)0, (int)TasksUiPlugin.getTaskList().getAllTasks().size());
        TaskTask task = new TaskTask("mock", "http://bugs", "1");
        TasksUiPlugin.getTaskList().addTask((ITask)task);
        TaskTestUtil.saveAndReadTasklist();
        TaskListExternalizationTest.assertEquals((int)1, (int)TasksUiPlugin.getTaskList().getAllTasks().size());
        AbstractRepositoryConnector connector = TasksUiPlugin.getRepositoryManager().removeRepositoryConnector("mock");
        TaskTestUtil.saveAndReadTasklist();
        TaskListExternalizationTest.assertEquals((int)0, (int)TasksUiPlugin.getTaskList().getAllTasks().size());
        TasksUiPlugin.getExternalizationManager().save(true);
        TasksUiPlugin.getRepositoryManager().addRepositoryConnector(connector);
        TaskTestUtil.saveAndReadTasklist();
        TaskListExternalizationTest.assertEquals((int)1, (int)TasksUiPlugin.getTaskList().getAllTasks().size());
        TaskListExternalizationTest.assertNotNull((String)"1", (Object)TasksUiPlugin.getTaskList().getTask("http://bugs", "1"));
    }

    public void testOrphanedQueries() throws Exception {
        TaskListExternalizationTest.assertEquals((int)0, (int)TasksUiPlugin.getTaskList().getQueries().size());
        RepositoryQuery query = new RepositoryQuery("mock", "bugzillaQuery");
        TasksUiPlugin.getTaskList().addQuery(query);
        TasksUiPlugin.getExternalizationManager().save(true);
        TaskTestUtil.saveAndReadTasklist();
        TaskListExternalizationTest.assertEquals((int)1, (int)TasksUiPlugin.getTaskList().getQueries().size());
        AbstractRepositoryConnector connector = TasksUiPlugin.getRepositoryManager().removeRepositoryConnector("mock");
        TaskTestUtil.saveAndReadTasklist();
        TaskListExternalizationTest.assertEquals((int)0, (int)TasksUiPlugin.getTaskList().getQueries().size());
        TasksUiPlugin.getExternalizationManager().requestSave();
        TasksUiPlugin.getRepositoryManager().addRepositoryConnector(connector);
        TaskTestUtil.saveAndReadTasklist();
        TaskListExternalizationTest.assertEquals((int)1, (int)TasksUiPlugin.getTaskList().getQueries().size());
    }
}

