/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.tasks.tests;

import java.io.File;
import java.util.Date;
import junit.framework.TestCase;
import org.apache.commons.lang.RandomStringUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.mylyn.commons.sdk.util.CommonTestUtil;
import org.eclipse.mylyn.internal.tasks.core.TaskRepositoryManager;
import org.eclipse.mylyn.internal.tasks.core.data.TaskDataState;
import org.eclipse.mylyn.internal.tasks.core.data.TaskDataStore;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylyn.tasks.core.IRepositoryManager;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.data.TaskAttachmentMapper;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.core.data.TaskAttributeMapper;
import org.eclipse.mylyn.tasks.core.data.TaskCommentMapper;
import org.eclipse.mylyn.tasks.core.data.TaskData;
import org.eclipse.mylyn.tasks.core.data.TaskMapper;
import org.eclipse.mylyn.tasks.core.data.TaskOperation;
import org.eclipse.mylyn.tasks.tests.connector.MockRepositoryConnector;

public class TaskDataStoreTest
extends TestCase {
    private static final String MOCK_ID = "1";
    private TaskDataStore storage;
    private TaskRepository taskRepository;
    private File file;
    private TaskData data;
    private TaskDataState state;

    protected void setUp() throws Exception {
        TaskRepositoryManager taskRepositoryManager = new TaskRepositoryManager();
        this.storage = new TaskDataStore((IRepositoryManager)taskRepositoryManager);
        this.taskRepository = new TaskRepository("mock", "http://mockrepository.test");
        this.file = File.createTempFile("mylyn", null);
        this.file.deleteOnExit();
        taskRepositoryManager.addRepositoryConnector((AbstractRepositoryConnector)new MockRepositoryConnector());
        taskRepositoryManager.addRepository(this.taskRepository);
    }

    protected void tearDown() throws Exception {
        this.file.delete();
    }

    public void testPutAndGet() throws Exception {
        TaskDataState state = new TaskDataState("mock", "http://mockrepository.test", MOCK_ID);
        TaskData data = new TaskData(new TaskAttributeMapper(this.taskRepository), "mock", "http://mockrepository.test", MOCK_ID);
        TaskMapper mapper = new TaskMapper(data, true);
        mapper.getTaskData().getRoot().createAttribute("attributeKey1").setValue("attValue!");
        mapper.setDescription("description");
        mapper.setSummary("summary");
        mapper.setTaskKind("task kind");
        TaskData oldData = new TaskData(new TaskAttributeMapper(this.taskRepository), "mock", "http://mockrepository.test", MOCK_ID);
        state.setRepositoryData(data);
        state.setLastReadData(oldData);
        state.setEditsData(null);
        this.storage.putTaskData(this.file, state);
        TaskDataState retrieved = this.storage.getTaskDataState(this.file);
        TaskDataStoreTest.assertNotNull((Object)retrieved);
        TaskData newTaskData = retrieved.getRepositoryData();
        TaskDataStoreTest.assertNotNull((Object)newTaskData);
        TaskDataStoreTest.assertEquals((String)"mock", (String)newTaskData.getConnectorKind());
        mapper = new TaskMapper(newTaskData);
        TaskDataStoreTest.assertEquals((String)"description", (String)mapper.getDescription());
        TaskDataStoreTest.assertEquals((String)"summary", (String)mapper.getSummary());
        TaskDataStoreTest.assertEquals((String)"task kind", (String)mapper.getTaskKind());
    }

    public void testDelete() throws Exception {
        TaskData data = new TaskData(new TaskAttributeMapper(this.taskRepository), "mock", "http://mockrepository.test", MOCK_ID);
        TaskDataState state = new TaskDataState("mock", "http://mockrepository.test", MOCK_ID);
        state.setRepositoryData(data);
        this.storage.putTaskData(this.file, state);
        this.storage.deleteTaskData(this.file);
        TaskDataStoreTest.assertFalse((boolean)this.file.exists());
        TaskDataStoreTest.assertNull((Object)this.storage.getTaskDataState(this.file));
    }

    private void setupData() {
        this.data = new TaskData(new TaskAttributeMapper(this.taskRepository), "mock", "http://mockrepository.test", MOCK_ID);
        this.state = new TaskDataState("mock", "http://mockrepository.test", MOCK_ID);
        this.state.setRepositoryData(this.data);
    }

    public void testAttributes() throws Exception {
        this.setupData();
        TaskAttribute attribute = this.data.getRoot().createAttribute("testId");
        attribute.getMetaData().setLabel("testName").setReadOnly(true);
        attribute.putOption("Option Name 1", "Option Value 1");
        attribute.putOption("Option Name 2", "Option Value 2");
        attribute.addValue("Value 1");
        attribute.addValue("Value 2");
        attribute.addValue("Value 3");
        attribute.getMetaData().putValue("MetaKey1", "MetaValue1");
        attribute.getMetaData().putValue("MetaKey2", "MetaValue2");
        attribute.getMetaData().putValue("MetaKey3", "MetaValue3");
        attribute.getMetaData().putValue("MetaKey4", "MetaValue4");
        this.assertData(1);
    }

    private void assertData(int attributeCount) throws CoreException {
        this.storage.putTaskData(this.file, this.state);
        this.state = this.storage.getTaskDataState(this.file);
        TaskDataStoreTest.assertNotNull((Object)this.state);
        TaskDataStoreTest.assertNotNull((Object)this.state.getRepositoryData());
        TaskDataStoreTest.assertEquals((String)this.data.getRoot().toString(), (String)this.state.getRepositoryData().getRoot().toString());
        TaskDataStoreTest.assertEquals((int)attributeCount, (int)this.state.getRepositoryData().getRoot().getAttributes().size());
    }

    public void testOperations() throws Exception {
        this.setupData();
        TaskOperation.applyTo((TaskAttribute)this.data.getRoot().createAttribute("op1"), (String)"op1 id", (String)"op1 label");
        TaskOperation.applyTo((TaskAttribute)this.data.getRoot().createAttribute("op2"), (String)"op2 id", (String)"op2 label");
        this.assertData(2);
    }

    public void testComments() throws Exception {
        this.setupData();
        TaskCommentMapper comment1 = new TaskCommentMapper();
        comment1.setCommentId("attachmentId1");
        TaskAttribute attr = this.data.getRoot().createAttribute(MOCK_ID);
        comment1.applyTo(attr);
        attr.createAttribute("attr1").setValue("attr1Name");
        TaskCommentMapper comment2 = new TaskCommentMapper();
        comment2.setCommentId("attachmentId2");
        comment2.setCreationDate(new Date());
        comment2.setNumber(Integer.valueOf(100));
        comment2.applyTo(this.data.getRoot().createAttribute("2"));
        this.assertData(2);
    }

    public void testAttachments() throws Exception {
        this.setupData();
        TaskAttachmentMapper attachment1 = new TaskAttachmentMapper();
        attachment1.setAuthor(this.taskRepository.createPerson("thecreator"));
        attachment1.setDeprecated(Boolean.valueOf(false));
        attachment1.setPatch(Boolean.valueOf(true));
        TaskAttribute attr = this.data.getRoot().createAttribute(MOCK_ID);
        attachment1.applyTo(attr);
        attr.createAttribute("attr1").setValue("attr1Name");
        attr.createAttribute("attr2").setValue("attr1Name");
        TaskAttachmentMapper attachment2 = new TaskAttachmentMapper();
        attachment2.setAuthor(this.taskRepository.createPerson("thecreator2"));
        attachment2.setDeprecated(Boolean.valueOf(true));
        attachment2.setPatch(Boolean.valueOf(false));
        attachment2.applyTo(this.data.getRoot().createAttribute("2"));
        this.assertData(2);
    }

    public void testReadWriteInvalidCharacters() throws Exception {
        this.setupData();
        this.data.getRoot().createAttribute("attribute").setValue("\u0000");
        this.storage.putTaskData(this.file, this.state);
        try {
            TaskDataState state2 = this.storage.getTaskDataState(this.file);
            TaskDataStoreTest.fail((String)("Expected CoreException, got " + state2));
        }
        catch (CoreException coreException) {}
    }

    public void testReadWriteC0Characters() throws Exception {
        this.setupData();
        this.data.getRoot().createAttribute("attribute").setValue("\u0001\u001f");
        this.storage.putTaskData(this.file, this.state);
        TaskDataState state2 = this.storage.getTaskDataState(this.file);
        TaskDataStoreTest.assertEquals((String)this.state.getRepositoryData().getRoot().toString(), (String)state2.getRepositoryData().getRoot().toString());
    }

    public void testReadWriteC1Characters() throws Exception {
        this.setupData();
        this.data.getRoot().createAttribute("attribute").setValue("\u007f\u0080");
        this.storage.putTaskData(this.file, this.state);
        TaskDataState state2 = this.storage.getTaskDataState(this.file);
        TaskDataStoreTest.assertEquals((String)this.state.getRepositoryData().getRoot().toString(), (String)state2.getRepositoryData().getRoot().toString());
    }

    public void testReadWriteC0C1Characters() throws Exception {
        this.setupData();
        this.data.getRoot().createAttribute("attribute").setValue("\u0001\u001f\u007f\u0080");
        this.storage.putTaskData(this.file, this.state);
        if (System.getProperty("java.version").compareTo("1.6") < 0) {
            try {
                TaskDataState state2 = this.storage.getTaskDataState(this.file);
                TaskDataStoreTest.fail((String)("Expected CoreException, got '" + state2.getRepositoryData().getRoot().toString() + "'"));
            }
            catch (CoreException coreException) {}
        } else {
            TaskDataState state2 = this.storage.getTaskDataState(this.file);
            TaskDataStoreTest.assertEquals((String)this.state.getRepositoryData().getRoot().toString(), (String)state2.getRepositoryData().getRoot().toString());
        }
    }

    public void testReadWriteSetValue() throws Exception {
        this.setupData();
        TaskAttribute attribute = this.data.getRoot().createAttribute("attribute");
        TaskDataStoreTest.assertFalse((boolean)attribute.hasValue());
        attribute.setValue("foo");
        TaskDataStoreTest.assertTrue((boolean)attribute.hasValue());
        File file = File.createTempFile("mylyn", null);
        file.deleteOnExit();
        this.storage.putTaskData(file, this.state);
        TaskDataState state2 = this.storage.getTaskDataState(file);
        TaskDataStoreTest.assertTrue((boolean)state2.getRepositoryData().getRoot().getAttribute("attribute").hasValue());
    }

    public void testReadWriteUnsetValue() throws Exception {
        this.setupData();
        TaskAttribute attribute = this.data.getRoot().createAttribute("attribute");
        TaskDataStoreTest.assertFalse((boolean)attribute.hasValue());
        attribute.setValue("foo");
        TaskDataStoreTest.assertTrue((boolean)attribute.hasValue());
        attribute.clearValues();
        TaskDataStoreTest.assertFalse((boolean)attribute.hasValue());
        File file = File.createTempFile("mylyn", null);
        file.deleteOnExit();
        this.storage.putTaskData(file, this.state);
        TaskDataState state2 = this.storage.getTaskDataState(file);
        TaskDataStoreTest.assertFalse((boolean)state2.getRepositoryData().getRoot().getAttribute("attribute").hasValue());
    }

    public void testCorruptedData() throws Exception {
        if (!this.hasXerces()) {
            System.err.println("Skipping testCorruptedData() due to Xerces missing");
            return;
        }
        this.state = this.storage.getTaskDataState(CommonTestUtil.getFile((Object)((Object)this), (String)"testdata/taskdata-bug406647.zip"));
        TaskDataStoreTest.assertFalse((boolean)this.state.getRepositoryData().getRoot().toString().contains("<ke"));
        TaskDataStoreTest.assertFalse((boolean)this.state.getRepositoryData().getRoot().toString().contains("<va"));
        TaskDataStoreTest.assertFalse((boolean)this.state.getRepositoryData().getRoot().toString().contains("ey>"));
        TaskDataStoreTest.assertFalse((boolean)this.state.getRepositoryData().getRoot().toString().contains("al>"));
    }

    private boolean hasXerces() {
        try {
            Class.forName("org.apache.xerces.parsers.SAXParser");
            return true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }

    public void testRandomDataXml_1_0() throws Exception {
        this.randomData(32, Integer.MAX_VALUE);
    }

    public void testRandomDataXml_1_1() throws Exception {
        if (!this.hasXerces()) {
            System.err.println("Skipping testRandomDataXml_1_1 due to Xerces missing");
            return;
        }
        this.randomData(0, Integer.MAX_VALUE);
    }

    private void randomData(int start, int end) throws Exception {
        this.setupData();
        int i = 0;
        while (i < 1000) {
            TaskAttribute attribute = this.data.getRoot().createAttribute("testId");
            attribute.getMetaData().setLabel(this.generateString(start, end));
            attribute.putOption(this.generateString(start, end), this.generateString(start, end));
            attribute.putOption(this.generateString(start, end), this.generateString(start, end));
            attribute.addValue(this.generateString(start, end));
            attribute.addValue(this.generateString(start, end));
            if (start == 0) {
                attribute.addValue(String.valueOf(this.generateString(start, end)) + "\u0001");
            }
            ++i;
        }
        String expectedValue = this.data.getRoot().toString();
        this.storage.putTaskData(this.file, this.state);
        this.state = this.storage.getTaskDataState(this.file);
        String actualValue = this.state.getRepositoryData().getRoot().toString();
        TaskDataStoreTest.assertEquals((String)expectedValue, (String)actualValue);
    }

    private String generateString(int start, int end) {
        return RandomStringUtils.random((int)1000, (int)start, (int)end, (boolean)true, (boolean)true);
    }
}

